/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.analytics.naming;

import com.tridiumx.analytics.Analytics;
import com.tridiumx.analytics.BAnalyticService;
import com.tridiumx.analytics.data.Values;
import com.tridiumx.analytics.naming.BAbstractTrendResolver;
import com.tridiumx.analytics.naming.BAnalyticOrdScheme;
import com.tridiumx.analytics.naming.BAnalyticTrendFlagValue;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.bajax.analytics.AnalyticContext;
import javax.bajax.analytics.data.AnalyticTrend;

public class BRollupOrdScheme
extends BAnalyticOrdScheme {
    public static final BRollupOrdScheme INSTANCE = new BRollupOrdScheme();
    public static final Type TYPE = Sys.loadType(BRollupOrdScheme.class);

    @Override
    public Type getType() {
        return TYPE;
    }

    public BRollupOrdScheme() {
        super("analyticRollup");
    }

    public BRollupOrdScheme(String name) {
        super(name);
    }

    protected BValue resolve(AnalyticContext cx) {
        int currPrio = Thread.currentThread().getPriority();
        BAnalyticTrendFlagValue ret = null;
        try {
            if (Sys.isStation()) {
                Thread.currentThread().setPriority(BAnalyticService.getInstance().getThreadPriority());
            }
            ret = Values.getAdvancedStatusValue(Analytics.getRollup(cx));
        }
        catch (RuntimeException x) {
            throw x;
        }
        catch (Exception x) {
            throw new RuntimeException(x);
        }
        finally {
            Thread.currentThread().setPriority(currPrio);
        }
        return ret;
    }

    @Override
    protected BAbstractTrendResolver getResolver(AnalyticContext cx, AnalyticTrend trend) {
        return null;
    }
}

