/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.analytics.naming;

import com.tridium.collection.GenericColumnList;
import com.tridiumx.analytics.naming.AnalyticTrendCursor;
import com.tridiumx.analytics.naming.BAbstractTrendResolver;
import com.tridiumx.analytics.naming.BAnalyticTrendRecord;
import com.tridiumx.analytics.naming.BAnalyticTrendTable;
import java.util.HashMap;
import javax.baja.collection.ColumnList;
import javax.baja.collection.TableCursor;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BFacets;
import javax.baja.sys.BString;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;
import javax.bajax.analytics.AnalyticContext;
import javax.bajax.analytics.data.AnalyticTrend;
import javax.bajax.analytics.data.BCombination;

@NiagaraType
public class BAnalyticTrendResolver
extends BAbstractTrendResolver {
    public static final Type TYPE = Sys.loadType(BAnalyticTrendResolver.class);
    private AnalyticTrendCursor cursor;
    private BFacets valueFacets = BFacets.NULL;

    @Override
    public Type getType() {
        return TYPE;
    }

    public BAnalyticTrendResolver(AnalyticTrend trend, AnalyticContext context) {
        this.trend = trend;
        this.valueFacets = this.adjustUnitFacets(context);
    }

    public TableCursor<BAnalyticTrendRecord> cursor() {
        this.cursor = new AnalyticTrendCursor(this, this.trend, this.valueFacets);
        return this.cursor;
    }

    public ColumnList getColumns() {
        return this.defaultColumnList(this.trend.getContext());
    }

    public BFacets getTableFacets() {
        AnalyticContext cx = this.trend.getContext();
        HashMap<String, BString> tableFacets = new HashMap<String, BString>();
        tableFacets.put("startTime", BString.make((String)BAbsTime.make((long)cx.getStartTime()).toString()));
        tableFacets.put("endTime", BString.make((String)BAbsTime.make((long)cx.getEndTime()).toString()));
        if (this.cursor != null) {
            BAnalyticTrendRecord firstRec = this.cursor.getFirstRecord();
            BAnalyticTrendRecord lastRec = this.cursor.getLastRecord();
            if (firstRec != null) {
                tableFacets.put("firstTimestamp", BString.make((String)firstRec.toString()));
            }
            if (lastRec != null) {
                tableFacets.put("lastTimestamp", BString.make((String)lastRec.toString()));
            }
        }
        return BFacets.make((BFacets)this.valueFacets, (BFacets)BFacets.make(tableFacets));
    }

    protected BFacets adjustUnitFacets(AnalyticContext cx) {
        BFacets facets = cx.getFacets();
        BUnit unit = cx.getUnit(false);
        if (unit != null && unit.isNull()) {
            facets = BFacets.makeRemove((BFacets)facets, (String)"units");
        } else if (cx.getAggregation(false) == BCombination.count || cx.getRollup(false) == BCombination.loadFactor) {
            facets = BFacets.makeRemove((BFacets)facets, (String)"units");
        } else if (cx.getRollup(false) == BCombination.count || cx.getRollup(false) == BCombination.loadFactor) {
            facets = BFacets.makeRemove((BFacets)facets, (String)"units");
        }
        return facets;
    }

    protected GenericColumnList defaultColumnList(AnalyticContext cx) {
        return BAnalyticTrendTable.defaultColumnList(cx);
    }
}

