/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.analytics.history;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BBitString;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;

@NiagaraType
public final class BInterpolationTrendFlags
extends BBitString {
    public static final byte KNN_INTERPOLATED = 1;
    public static final byte LINEAR_INTERPOLATED = 2;
    public static final byte IGNORE_POINT = 4;
    public static final byte RESERVED_0 = 16;
    public static final byte RESERVED_1 = 32;
    public static final byte RESERVED_2 = 64;
    public static final BInterpolationTrendFlags knnInterpolated = new BInterpolationTrendFlags(1);
    public static final BInterpolationTrendFlags linearInterpolated = new BInterpolationTrendFlags(2);
    public static final BInterpolationTrendFlags ignorePoint = new BInterpolationTrendFlags(4);
    public static final BInterpolationTrendFlags DEFAULT = new BInterpolationTrendFlags(0);
    private byte bits;
    private static BBitString.Support support = new BBitString.Support((BBitString)DEFAULT);
    private Lexicon lex = Lexicon.make(BInterpolationTrendFlags.class);
    public static final Type TYPE;

    public byte getBits() {
        return this.bits;
    }

    public BInterpolationTrendFlags set(int ordinal, boolean newState) {
        byte newBits = this.getBits();
        newBits = newState ? (byte)(newBits | (byte)(0xFF & ordinal)) : (byte)(newBits & ~((byte)(0xFF & ordinal)));
        return BInterpolationTrendFlags.make(newBits);
    }

    public static BInterpolationTrendFlags make() {
        return DEFAULT;
    }

    public static BInterpolationTrendFlags make(int bits) {
        return bits == 0 ? DEFAULT : (BInterpolationTrendFlags)new BInterpolationTrendFlags((byte)(0xFF & bits)).intern();
    }

    public static BInterpolationTrendFlags make(byte bits) {
        return bits == 0 ? DEFAULT : (BInterpolationTrendFlags)new BInterpolationTrendFlags(bits).intern();
    }

    private BInterpolationTrendFlags() {
        this.bits = 0;
    }

    private BInterpolationTrendFlags(byte bits) {
        this.bits = bits;
    }

    public boolean getBit(int ordinal) {
        return (this.bits & ordinal) != 0;
    }

    public boolean getBit(String tag) {
        return this.getBit(this.tagToOrdinal(tag));
    }

    public int[] getOrdinals() {
        return new int[]{1, 2, 4};
    }

    public boolean isOrdinal(int ordinal) {
        return support.isOrdinal(ordinal);
    }

    public String getTag(int ordinal) {
        return support.getTag(ordinal);
    }

    public String getDisplayTag(int var1, Context var2) {
        return support.getTag(var1);
    }

    public BBitString getInstance(int[] ordinals) {
        byte mask = 0;
        for (int i = 0; i < ordinals.length; ++i) {
            mask = (byte)(mask | (byte)(0xFF & ordinals[i]));
        }
        return BInterpolationTrendFlags.make(mask);
    }

    public boolean isTag(String tag) {
        return support.isTag(tag);
    }

    public int tagToOrdinal(String tag) {
        return support.tagToOrdinal(tag);
    }

    public boolean isEmpty() {
        return this.bits == 0;
    }

    public String getEmptyTag() {
        return "none";
    }

    public int hashCode() {
        return this.bits;
    }

    public boolean equals(Object obj) {
        if (obj instanceof BInterpolationTrendFlags) {
            return ((BInterpolationTrendFlags)((Object)obj)).bits == this.bits;
        }
        return false;
    }

    public void encode(DataOutput out) throws IOException {
        out.writeByte(this.bits);
    }

    public BObject decode(DataInput in) throws IOException {
        return new BInterpolationTrendFlags(in.readByte()).intern();
    }

    public String encodeToString() {
        return Integer.toString(0xFF & this.bits, 16);
    }

    public BObject decodeFromString(String s) throws IOException {
        try {
            int i = Integer.parseInt(s, 16);
            byte b = (byte)(i & 0xFF);
            return b == 0 ? DEFAULT : new BInterpolationTrendFlags(b).intern();
        }
        catch (Exception var4) {
            throw new IOException("Invalid bits: " + s);
        }
    }

    public String toString(Context cx) {
        if (this.bits == 0) {
            return "{ }";
        }
        StringBuffer s = new StringBuffer();
        s.append('{');
        boolean first = true;
        if (this.getBit(1)) {
            first = false;
            s.append(this.lex.get("missingdata.appliedmdc.1"));
        }
        if (this.getBit(2)) {
            if (!first) {
                s.append(",");
            }
            first = false;
            s.append(this.lex.get("missingdata.appliedmdc.2"));
        }
        if (this.getBit(4)) {
            if (!first) {
                s.append(",");
            }
            first = false;
            s.append(this.lex.get("missingdata.appliedmdc.4"));
        }
        if (this.getBit(8)) {
            if (!first) {
                s.append(",");
            }
            first = false;
            s.append(this.getDisplayTag(8, cx));
        }
        if (this.getBit(16)) {
            if (!first) {
                s.append(",");
            }
            first = false;
            s.append(this.getDisplayTag(16, cx));
        }
        if (this.getBit(32)) {
            if (!first) {
                s.append(",");
            }
            first = false;
            s.append(this.getDisplayTag(32, cx));
        }
        if (this.getBit(64)) {
            if (!first) {
                s.append(",");
            }
            first = false;
            s.append(this.getDisplayTag(64, cx));
        }
        s.append('}');
        return s.toString();
    }

    public Type getType() {
        return TYPE;
    }

    static {
        support.add(1, "knn");
        support.add(2, "li");
        support.add(4, "ignorePoint");
        TYPE = Sys.loadType(BInterpolationTrendFlags.class);
    }
}

