/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.analytics.data;

import com.tridiumx.analytics.data.AbstractAnalyticValue;
import com.tridiumx.analytics.data.Values;
import com.tridiumx.analytics.history.BInterpolationTrendFlags;
import com.tridiumx.analytics.util.Utils;
import javax.bajax.analytics.data.AnalyticNumeric;
import javax.bajax.analytics.data.AnalyticValue;

public class NumericValue
extends AbstractAnalyticValue
implements AnalyticNumeric {
    private double value = 0.0;

    public NumericValue() {
    }

    public NumericValue(double value) {
        this.value = value;
    }

    public NumericValue(double value, int status) {
        this.value = value;
        this.status = status;
    }

    public NumericValue(long timestamp, double value, int status) {
        this.timestamp = timestamp;
        this.value = value;
        this.status = status;
    }

    public NumericValue addValue(AnalyticValue val) {
        this.value += val.toNumeric();
        return this;
    }

    @Override
    public AnalyticValue copy(AnalyticValue val) {
        this.setTimestamp(val.getTimestamp());
        this.setValue(val.toNumeric());
        this.setStatus(val.getStatus());
        this.setTrendFlags(((AbstractAnalyticValue)val).getTrendFlags());
        return this;
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public int getValueType() {
        return 2;
    }

    @Override
    public boolean isValid() {
        if (!Values.isValid(this.status)) {
            return false;
        }
        if (Double.isNaN(this.value)) {
            return false;
        }
        return !Double.isInfinite(this.value);
    }

    @Override
    public AnalyticValue newCopy() {
        NumericValue ret = new NumericValue();
        return ret.copy(this);
    }

    public AnalyticNumeric set(double value, int status) {
        this.value = value;
        this.status = status;
        return this;
    }

    public AnalyticNumeric set(long timestamp, double value, int status) {
        this.timestamp = timestamp;
        this.value = value;
        this.status = status;
        return this;
    }

    public AnalyticNumeric set(long timestamp, double value, int status, BInterpolationTrendFlags trendFlags) {
        this.trendFlags = trendFlags;
        return this.set(timestamp, value, status);
    }

    @Override
    public AnalyticNumeric setValue(double arg) {
        this.value = arg;
        return this;
    }

    @Override
    public AnalyticValue setValue(Object arg) {
        this.value = Values.getNumeric(arg);
        return this;
    }

    @Override
    public boolean toBoolean() {
        return !Utils.isEqualTo(this.value, 0.0);
    }

    @Override
    public int toEnum() {
        return (int)this.value;
    }

    @Override
    public double toNumeric() {
        return this.value;
    }

    @Override
    public String toString() {
        return this.value + "";
    }

    @Override
    public boolean valueEquals(AnalyticValue val) {
        double d = val.toNumeric();
        if (Utils.isEqualTo(this.value, d)) {
            return true;
        }
        if (Double.isNaN(d)) {
            return Double.isNaN(this.value);
        }
        if (Double.isInfinite(d)) {
            return Double.isInfinite(this.value);
        }
        return false;
    }
}

