/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.analytics.data;

import com.tridiumx.analytics.BAnalyticService;
import com.tridiumx.analytics.alert.AlertEntry;
import com.tridiumx.analytics.alert.BAnalyticAlert;
import com.tridiumx.analytics.algorithm.Algorithm;
import com.tridiumx.analytics.data.AggregateDataSource;
import com.tridiumx.analytics.data.AlgorithmDataSource;
import com.tridiumx.analytics.data.AnalyticDataSource;
import com.tridiumx.analytics.data.NavDataSource;
import com.tridiumx.analytics.data.ValueTagDataSource;
import com.tridiumx.analytics.util.Utils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.baja.control.BControlPoint;
import javax.baja.data.BIDataValue;
import javax.baja.naming.BOrd;
import javax.baja.nav.BINavNode;
import javax.baja.sys.BComponent;
import javax.baja.sys.BMarker;
import javax.baja.sys.Context;
import javax.baja.tag.Id;
import javax.baja.tag.Taggable;
import javax.baja.user.BUser;
import javax.baja.user.BUserService;
import javax.bajax.analytics.AnalyticConstants;
import javax.bajax.analytics.AnalyticContext;
import javax.bajax.analytics.data.AnalyticTrend;
import javax.bajax.analytics.data.AnalyticValue;

public class NodeInfo
implements AnalyticConstants {
    private static final Id A = Id.newId((String)"a", (String)"a");
    private BINavNode node;
    private Map<BAnalyticAlert, AlertEntry> alerts = new HashMap<BAnalyticAlert, AlertEntry>();
    private Map<String, Map<Id, AnalyticDataSource>> userDataSources = new ConcurrentHashMap<String, Map<Id, AnalyticDataSource>>(5);
    private static Map<BOrd, NodeInfo> nodeInfos = new ConcurrentHashMap<BOrd, NodeInfo>(1000);
    private static final AnalyticDataSource nullAnalyticDataSource = new NullAnalyticDataSource();

    public NodeInfo(BINavNode node) {
        this.node = node;
    }

    public static void clear() {
        nodeInfos.clear();
    }

    public AnalyticDataSource getAnalyticDataSource(Id data, boolean search, AnalyticContext cx) {
        if (cx != null && !Utils.hasOperatorRead(this.node, cx.getBase())) {
            Utils.log().log(Level.FINER, Utils.lex("noNodePermission"), this.node.getNavOrd());
            return null;
        }
        AnalyticDataSource ret = null;
        if (BAnalyticService.getInstance().getSkipDataSourceCache()) {
            if (search) {
                ret = this.findAnalyticDataSource(data, cx);
            }
        } else {
            BUser user = cx == null ? BUserService.getService().getAdmin() : cx.getUser();
            Map<Id, AnalyticDataSource> ds = this.userDataSources.get(user.getUsername());
            if (ds == null && search) {
                this.userDataSources.putIfAbsent(user.getUsername(), new ConcurrentHashMap(5));
                ds = this.userDataSources.get(user.getUsername());
            }
            String tagName = data.getName();
            if (!data.getDictionary().equals("alg")) {
                tagName = tagName + (cx == null || cx.getHistory().getBoolean() ? "-his" : "-tag");
            }
            Id cachedData = Id.newId((String)data.getDictionary(), (String)tagName);
            if (ds != null) {
                ret = ds.get(cachedData);
            }
            if (ret instanceof AggregateDataSource && ((AggregateDataSource)ret).getSources().size() == 0) {
                ret = nullAnalyticDataSource;
            }
            if (ret == null && search) {
                ret = this.findAnalyticDataSource(data, cx);
                ArrayList<AnalyticDataSource> aeList = new ArrayList<AnalyticDataSource>();
                if (ret instanceof AggregateDataSource) {
                    ArrayList<AnalyticDataSource> adsList = ((AggregateDataSource)ret).getSources();
                    for (AnalyticDataSource ad : adsList) {
                        if (ad instanceof AggregateDataSource) {
                            aeList.addAll(((AggregateDataSource)ad).getSources());
                            continue;
                        }
                        aeList.add(ad);
                    }
                } else if (!(ret instanceof NullAnalyticDataSource)) {
                    aeList.add(ret);
                }
                ds.put(cachedData, new AggregateDataSource(aeList));
            }
        }
        if (ret == nullAnalyticDataSource) {
            ret = null;
        }
        return ret;
    }

    public static NodeInfo get(BINavNode arg, boolean create) {
        NodeInfo ret = null;
        BOrd ord = null;
        ord = Utils.getNodeOrd(arg);
        ret = nodeInfos.get(ord);
        if (ret == null && create) {
            ret = new NodeInfo(arg);
            nodeInfos.put(ord, ret);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AlertEntry getEntry(BAnalyticAlert alert) {
        Map<BAnalyticAlert, AlertEntry> map = this.alerts;
        synchronized (map) {
            return this.alerts.get((Object)alert);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getEntries(Collection<AlertEntry> bucket, Context cx) {
        Map<BAnalyticAlert, AlertEntry> map = this.alerts;
        synchronized (map) {
            Map<BAnalyticAlert, AlertEntry> alertsFiltered = this.alerts.entrySet().stream().filter(p -> ((AlertEntry)p.getValue()).getAlert().getPermissions(cx).hasOperatorRead()).collect(Collectors.toMap(p -> (BAnalyticAlert)((Object)((Object)p.getKey())), p -> (AlertEntry)p.getValue()));
            bucket.addAll(alertsFiltered.values());
        }
    }

    public BINavNode getNode() {
        return this.node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putEntry(BAnalyticAlert alert, AlertEntry entry) {
        Map<BAnalyticAlert, AlertEntry> map = this.alerts;
        synchronized (map) {
            this.alerts.put(alert, entry);
        }
    }

    private static ArrayList<AnalyticDataSource> add(AnalyticDataSource src, ArrayList<AnalyticDataSource> list) {
        if (src == null) {
            return list;
        }
        if (list == null) {
            list = new ArrayList();
        }
        list.add(src);
        return list;
    }

    private AnalyticDataSource findAnalyticDataSource(Id data, AnalyticContext cx) {
        AnalyticDataSource.Provider provider;
        Collection<AnalyticDataSource> col;
        ArrayList<AnalyticDataSource> sources = null;
        if (this.node instanceof AnalyticDataSource.Provider && (col = (provider = (AnalyticDataSource.Provider)this.node).getDataSources(data)) != null && col.size() > 0) {
            if (col.size() == 1) {
                return col.iterator().next();
            }
            sources = new ArrayList<AnalyticDataSource>(col.size());
            sources.addAll(col);
            return new AggregateDataSource(sources);
        }
        AnalyticDataSource src = NodeInfo.getAnalyticDataSource(data, this.node, cx);
        if (src != null) {
            return src;
        }
        if (this.node.hasNavChildren()) {
            Optional dv;
            if (cx != null && !cx.getHistory().getBoolean() && (dv = ((Taggable)this.node).tags().get(data)).isPresent()) {
                sources = NodeInfo.add(new ValueTagDataSource((BIDataValue)dv.get()), sources);
            }
            BINavNode[] kids = this.node.getNavChildren();
            if (cx != null) {
                kids = Utils.filter(kids, cx.getBase());
            }
            int len = kids.length;
            for (int i = 0; i < len; ++i) {
                sources = NodeInfo.findAnalyticDataSource(data, kids[i], sources, cx);
            }
        }
        if (sources != null) {
            if (sources.size() == 1) {
                return (AnalyticDataSource)sources.get(0);
            }
            if (sources.size() > 1) {
                return new AggregateDataSource(sources);
            }
        }
        return nullAnalyticDataSource;
    }

    private static ArrayList<AnalyticDataSource> findAnalyticDataSource(Id data, BINavNode node, ArrayList<AnalyticDataSource> sources, AnalyticContext cx) {
        Optional dv;
        AnalyticDataSource src;
        NodeInfo info = NodeInfo.get(node, false);
        if (info != null && (src = info.getAnalyticDataSource(data, false, cx)) != null) {
            return NodeInfo.add(src, sources);
        }
        if (node instanceof AnalyticDataSource.Provider) {
            AnalyticDataSource.Provider provider = (AnalyticDataSource.Provider)node;
            Collection<AnalyticDataSource> col = provider.getDataSources(data);
            if (col != null && col.size() > 0) {
                if (sources == null) {
                    sources = new ArrayList();
                }
                sources.addAll(col);
            }
            return sources;
        }
        src = NodeInfo.getAnalyticDataSource(data, node, cx);
        if (src != null) {
            return NodeInfo.add(src, sources);
        }
        if (!node.hasNavChildren()) {
            return sources;
        }
        if (cx != null && !cx.getHistory().getBoolean() && (dv = ((Taggable)node).tags().get(data)).isPresent()) {
            sources = NodeInfo.add(new ValueTagDataSource((BIDataValue)dv.get()), sources);
        }
        BINavNode[] kids = node.getNavChildren();
        if (cx != null) {
            kids = Utils.filter(kids, cx.getBase());
        }
        for (BINavNode kid : kids) {
            if (!BAnalyticService.getInstance().isValidNodeType(kid)) {
                Logger.getLogger("analytics").log(Level.INFO, "Skipping VirtualGateway " + kid.getNavOrd() + " from node traversal");
                continue;
            }
            sources = NodeInfo.findAnalyticDataSource(data, kid, sources, cx);
        }
        return sources;
    }

    private static final AnalyticDataSource getAlgorithmDataSource(Id data, BINavNode node, AnalyticContext cx) {
        Algorithm alg = BAnalyticService.getInstance().getAlgorithm(data);
        if (alg != null && (cx == null || Utils.hasOperatorRead((BINavNode)alg, cx.getBase())) && (cx == null || !(node instanceof BComponent) || Utils.hasOperatorRead(node, cx.getBase())) && alg.isAvailable(node)) {
            return new AlgorithmDataSource(alg, node);
        }
        return null;
    }

    private static AnalyticDataSource getAnalyticDataSource(Id data, BINavNode node, AnalyticContext cx) {
        if (!BAnalyticService.getInstance().isValidNodeType(node)) {
            return nullAnalyticDataSource;
        }
        if (data.getDictionary().equals("alg")) {
            return NodeInfo.getAlgorithmDataSource(data, node, cx);
        }
        node = Utils.getProxyTarget(node);
        return NodeInfo.getNavDataSource(data, node, cx);
    }

    private static AnalyticDataSource getNavDataSource(Id data, BINavNode node, AnalyticContext cx) {
        Taggable t;
        if (node instanceof BControlPoint && (t = (Taggable)node).tags().contains(data)) {
            boolean isAPoint = t.tags().contains(A);
            if (BAnalyticService.getInstance().getAutoTagAnalyticPoint() && !isAPoint) {
                long incPtCount = BAnalyticService.aPointCountGL.incrementAndGet();
                if (BAnalyticService.getInstance().getLimitAutoTagging()) {
                    if (incPtCount <= BAnalyticService.aPointLimitGL) {
                        t.tags().set(A, (BIDataValue)BMarker.MARKER);
                        isAPoint = true;
                    } else {
                        BAnalyticService.aPointCountGL.decrementAndGet();
                    }
                } else {
                    t.tags().set(A, (BIDataValue)BMarker.MARKER);
                    isAPoint = true;
                }
            }
            if (isAPoint) {
                if (node instanceof AnalyticDataSource) {
                    return (AnalyticDataSource)node;
                }
                if (cx != null && !cx.getHistory().getBoolean()) {
                    return new ValueTagDataSource(node, data);
                }
                return new NavDataSource(node);
            }
            Utils.log().log(Level.FINER, Utils.lex("notAnalyticPoint"), node.getNavOrd());
        }
        return null;
    }

    private boolean isNullAnalyticDataSource(AnalyticDataSource dataSource) {
        return dataSource instanceof NullAnalyticDataSource || dataSource == nullAnalyticDataSource;
    }

    public boolean isAnalyticDataSourceNotNull(Id dataId, boolean search) {
        AnalyticDataSource analyticDataSource = this.getAnalyticDataSource(dataId, search, null);
        if (analyticDataSource == null || this.isNullAnalyticDataSource(analyticDataSource)) {
            return false;
        }
        if (analyticDataSource instanceof AggregateDataSource) {
            return !((AggregateDataSource)analyticDataSource).getSources().stream().allMatch(this::isNullAnalyticDataSource);
        }
        return true;
    }

    private static class NullAnalyticDataSource
    implements AnalyticDataSource {
        NullAnalyticDataSource() {
        }

        @Override
        public AnalyticTrend getTrend(AnalyticContext cx) {
            return null;
        }

        @Override
        public AnalyticValue getValue(AnalyticContext cx) {
            return null;
        }

        @Override
        public boolean hasTrend(AnalyticContext cx) {
            return false;
        }
    }
}

