/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.analytics.data;

import com.tridiumx.analytics.BAnalyticService;
import com.tridiumx.analytics.algorithm.missingdata.BMissingDataStrategy;
import com.tridiumx.analytics.algorithm.outlier.BOutlierHandling;
import com.tridiumx.analytics.data.AnalyticDataPolicy;
import com.tridiumx.analytics.data.BAnalyticDataFolder;
import com.tridiumx.analytics.data.BAnalyticDataPolicy;
import com.tridiumx.analytics.util.Utils;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.tag.Id;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="id", type="String", defaultValue="", facets={@Facet(name="BFacets.FIELD_EDITOR", value="\"analytics:DataDefFe\"")}), @NiagaraProperty(name="missingDataStrategy", type="analytics:MissingDataStrategy", defaultValue="BMissingDataStrategy.DEFAULT"), @NiagaraProperty(name="outlier", type="analytics:OutlierHandling", defaultValue="BOutlierHandling.DEFAULT")})
public class BAnalyticDataDefinition
extends BAnalyticDataPolicy {
    public static final Property id = BAnalyticDataDefinition.newProperty((int)0, (String)"", (BFacets)BFacets.make((String)"fieldEditor", (String)"analytics:DataDefFe"));
    public static final Property missingDataStrategy = BAnalyticDataDefinition.newProperty((int)0, (BValue)BMissingDataStrategy.DEFAULT, null);
    public static final Property outlier = BAnalyticDataDefinition.newProperty((int)0, (BValue)BOutlierHandling.DEFAULT, null);
    public static final Type TYPE = Sys.loadType(BAnalyticDataDefinition.class);
    protected Id targetId;

    public String getId() {
        return this.getString(id);
    }

    public void setId(String v) {
        this.setString(id, v, null);
    }

    public BMissingDataStrategy getMissingDataStrategy() {
        return (BMissingDataStrategy)this.get(missingDataStrategy);
    }

    public void setMissingDataStrategy(BMissingDataStrategy v) {
        this.set(missingDataStrategy, (BValue)v, null);
    }

    public BOutlierHandling getOutlier() {
        return (BOutlierHandling)this.get(outlier);
    }

    public void setOutlier(BOutlierHandling v) {
        this.set(outlier, (BValue)v, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    @Override
    public void changed(Property p, Context cx) {
        if (this.isRunning() && p.equals(id)) {
            this.updateConfig();
        }
    }

    @Override
    public Id getDataId() {
        return this.targetId;
    }

    public boolean isParentLegal(BComponent parent) {
        if (!this.isRunning()) {
            return true;
        }
        return parent instanceof BAnalyticDataFolder;
    }

    public void started() throws Exception {
        if (Sys.atSteadyState()) {
            this.atSteadyState();
        }
        this.updateConfig();
        super.started();
    }

    public void stopped() throws Exception {
        BAnalyticService svc = BAnalyticService.getInstance();
        if (svc != null && this.targetId != null) {
            svc.unregisterDataPolicy(this.targetId);
        }
        this.targetId = null;
        super.stopped();
    }

    @Override
    protected void updateConfig() {
        BAnalyticService svc = BAnalyticService.getInstance();
        String tmp = this.getId();
        if (tmp.length() == 0) {
            this.updateConfig(2, Utils.lex("invalidId"));
            if (this.targetId != null) {
                svc.unregisterDataPolicy(this.targetId);
            }
            return;
        }
        Id tmpId = null;
        try {
            tmpId = Id.newId((String)tmp);
        }
        catch (Exception x) {
            AnalyticDataPolicy tmpPolicy;
            this.updateConfig(2, Utils.lex("invalidId") + ": " + x.toString());
            if (this.targetId != null && (tmpPolicy = svc.getDataPolicy(this.targetId, false)) == this) {
                svc.unregisterDataPolicy(this.targetId);
            }
            return;
        }
        AnalyticDataPolicy tmpPolicy = svc.getDataPolicy(tmpId, false);
        if (tmpPolicy != null && tmpPolicy != this) {
            String faultCause = null;
            faultCause = tmpPolicy instanceof BComponent ? ((BComponent)tmpPolicy).toPathString() : tmpPolicy.getClass().getName() + " - " + tmpPolicy.toString();
            faultCause = Utils.lex("duplicateOf") + ' ' + faultCause;
            this.targetId = null;
            this.updateConfig(2, faultCause);
            return;
        }
        if (this.targetId == null) {
            this.targetId = tmpId;
            svc.registerDataPolicy(this.targetId, this);
        } else if (!tmp.equals(this.targetId.getQName())) {
            svc.unregisterDataPolicy(this.targetId);
            this.targetId = tmpId;
            svc.registerDataPolicy(this.targetId, this);
        }
        this.updateConfig(0, null);
    }
}

