/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.analytics.combine;

import com.tridiumx.analytics.combine.AbstractCombiner;
import com.tridiumx.analytics.data.NumericValue;
import com.tridiumx.analytics.history.BInterpolationTrendFlags;
import javax.bajax.analytics.data.AnalyticValue;

public class StandardDeviationCombiner
extends AbstractCombiner {
    private NumericValue analytic = new NumericValue();
    private double prevM;
    private double currM;
    private double prevS;
    private double currS;
    private int n = 0;

    public StandardDeviationCombiner() {
        this(14);
    }

    public StandardDeviationCombiner(int type) {
        super(type);
        this.reset();
    }

    @Override
    public AnalyticValue getValue() {
        double variance = this.n > 1 ? this.currS / (double)(this.n - 1) : 0.0;
        double result = Math.sqrt(variance);
        this.analytic.setValue(result);
        return this.analytic;
    }

    @Override
    protected void doReset() {
        this.n = 0;
        this.analytic.set(0L, 0.0, 64, BInterpolationTrendFlags.DEFAULT);
    }

    @Override
    protected boolean doUpdate(AnalyticValue arg) {
        double x = arg.toNumeric();
        ++this.n;
        if (this.n == 1) {
            this.prevM = this.currM = x;
            this.prevS = 0.0;
            this.analytic.setTimestamp(arg.getTimestamp());
            this.analytic.setStatus(arg.getStatus());
        } else {
            this.currM = this.prevM + (x - this.prevM) / (double)this.n;
            this.currS = this.prevS + (x - this.prevM) * (x - this.currM);
            this.prevM = this.currM;
            this.prevS = this.currS;
            this.analytic.setTimestamp(arg.getTimestamp());
            this.analytic.orStatus(arg);
        }
        this.analytic.orTrendFlags(arg);
        return true;
    }
}

