/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.analytics.aon;

import com.tridiumx.analytics.aon.Aobj;
import com.tridiumx.analytics.aon.AonIo;
import com.tridiumx.analytics.aon.AonWriter;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

class _AonWriter
implements AonWriter {
    private boolean minify = false;
    private PrintWriter out;
    private boolean zip = false;
    private ZipOutputStream zout;

    public _AonWriter(File file) throws IOException {
        this.out = new PrintWriter(new FileOutputStream(file));
    }

    public _AonWriter(File file, boolean zip) throws IOException {
        if (zip) {
            this.zout = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
            this.zout.putNextEntry(new ZipEntry("aon.txt"));
            this.out = new PrintWriter(this.zout);
            this.zip = true;
            return;
        }
        this.out = new PrintWriter(new FileOutputStream(file));
    }

    public _AonWriter(OutputStream out) throws IOException {
        this.out = new PrintWriter(out);
    }

    public _AonWriter(OutputStream out, boolean zip) throws IOException {
        if (zip) {
            ZipOutputStream zout = new ZipOutputStream(out);
            zout.putNextEntry(new ZipEntry("aon.txt"));
            out = zout;
            this.zip = true;
        }
        this.out = new PrintWriter(out);
    }

    public _AonWriter(Writer out) {
        this.out = out instanceof PrintWriter ? (PrintWriter)out : new PrintWriter(out);
    }

    public _AonWriter(PrintWriter out) {
        this.out = out;
    }

    @Override
    public void close() {
        if (this.zout != null) {
            try {
                this.zout.closeEntry();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.zout = null;
        }
        if (this.out != null) {
            this.out.close();
            this.out = null;
        }
    }

    @Override
    public boolean isMinify() {
        return this.minify;
    }

    @Override
    public boolean isZip() {
        return this.zip;
    }

    @Override
    public AonWriter flush() {
        this.out.flush();
        return this;
    }

    @Override
    public AonWriter print(String s) {
        this.out.print(s);
        return this;
    }

    @Override
    public AonWriter println(String s) {
        this.out.println(s);
        return this;
    }

    @Override
    public AonWriter println() {
        this.out.println();
        return this;
    }

    @Override
    public AonWriter setMinify(boolean minify) {
        this.minify = minify;
        return this;
    }

    @Override
    public AonWriter write(Aobj obj) {
        AonIo.write(obj, this.out, this.minify);
        return this;
    }

    @Override
    public AonWriter write(String str) {
        AonIo.write(str, this.out);
        return this;
    }
}

