/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.analytics.aon;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.zip.ZipInputStream;

class AonReader
extends Reader {
    private Reader in;
    private char[] buf;
    private int len = 0;
    private int next = 0;

    public AonReader(InputStream in) throws IOException {
        this(in, "UTF-8");
    }

    public AonReader(InputStream in, String charset) throws IOException {
        if (in.markSupported()) {
            byte[] zip = new byte[4];
            in.mark(4);
            in.read(zip);
            in.reset();
            if (zip[0] == 80 && zip[1] == 75 && zip[2] == 3 && zip[3] == 4) {
                ZipInputStream unzip = new ZipInputStream(new BufferedInputStream(in));
                unzip.getNextEntry();
                in = unzip;
            }
        }
        this.in = charset == null ? new InputStreamReader(in) : new InputStreamReader(in, charset);
        this.buf = new char[8192];
        this.len = this.buf.length;
    }

    public AonReader(Reader in) {
        this.in = in;
        this.buf = new char[8192];
        this.len = this.buf.length;
    }

    public AonReader(char[] buf) {
        this.buf = buf;
        this.len = buf.length;
    }

    private void fill() throws IOException {
        int n;
        if (this.in == null) {
            return;
        }
        int dst = 0;
        while ((n = this.in.read(this.buf, dst, this.buf.length - dst)) == 0) {
        }
        if (n > 0) {
            this.len = dst + n;
            this.next = dst;
        }
    }

    @Override
    public int read() throws IOException {
        if (this.next >= this.len) {
            this.fill();
            if (this.next >= this.len) {
                return -1;
            }
        }
        return this.buf[this.next++];
    }

    @Override
    public int read(char[] buf, int off, int len) throws IOException {
        throw new IllegalStateException("Will never be called");
    }

    public void unread() {
        if (this.next > 0) {
            --this.next;
        }
    }

    @Override
    public boolean ready() throws IOException {
        return this.next < this.len || this.in.ready();
    }

    @Override
    public void close() throws IOException {
        this.in = null;
        this.buf = null;
    }
}

