/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.analytics.algorithm;

import com.tridiumx.analytics.AnalyticContextWrapper;
import com.tridiumx.analytics.util.Utils;
import java.util.LinkedList;
import java.util.List;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.bajax.analytics.AnalyticContext;
import javax.bajax.analytics.algorithm.BBlockPin;
import javax.bajax.analytics.algorithm.BOutputBlock;
import javax.bajax.analytics.algorithm.BlockTrend;
import javax.bajax.analytics.data.AnalyticTrend;
import javax.bajax.analytics.data.AnalyticValue;
import javax.bajax.analytics.data.BCombination;
import javax.bajax.analytics.data.Combiner;
import javax.bajax.analytics.time.BAnalyticTimeRange;

public class BSlidingWindowBlock
extends BOutputBlock {
    public static final Property trendIn = BSlidingWindowBlock.newProperty((int)8, (BValue)new BBlockPin(), null);
    public static final Property rollup = BSlidingWindowBlock.newProperty((int)8, (BValue)BCombination.first, null);
    public static final Property useRequestRollup = BSlidingWindowBlock.newProperty((int)0, (boolean)false, null);
    public static final Property window = BSlidingWindowBlock.newProperty((int)8, (BValue)BRelTime.HOUR, null);
    public static final Type TYPE = Sys.loadType(BSlidingWindowBlock.class);

    public BBlockPin getTrendIn() {
        return (BBlockPin)this.get(trendIn);
    }

    public void setTrendIn(BBlockPin v) {
        this.set(trendIn, (BValue)v, null);
    }

    public BCombination getRollup() {
        return (BCombination)this.get(rollup);
    }

    public void setRollup(BCombination v) {
        this.set(rollup, (BValue)v, null);
    }

    public boolean getUseRequestRollup() {
        return this.getBoolean(useRequestRollup);
    }

    public void setUseRequestRollup(boolean v) {
        this.setBoolean(useRequestRollup, v, null);
    }

    public BRelTime getWindow() {
        return (BRelTime)this.get(window);
    }

    public void setWindow(BRelTime v) {
        this.set(window, (BValue)v, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    @Override
    public AnalyticValue getValue(AnalyticContext cx) {
        AnalyticValue val;
        Combiner roll = this.getRollup().makeCombiner();
        if (!this.getInput(0).hasTrend(cx)) {
            roll.update(this.getInput(0).getValue(cx));
            return roll.getValue();
        }
        cx = new AnalyticContextWrapper(cx);
        BAbsTime end = Clock.time();
        BAbsTime start = end.subtract(this.getWindow());
        cx.setTimeRange(BAnalyticTimeRange.make(start, end));
        AnalyticTrend trend = this.getInput(0).getTrend(cx);
        long endTs = cx.getEndTime();
        while (trend.hasNext() && !Utils.isEnded((val = trend.next()).getTimestamp(), endTs)) {
            roll.update(val);
        }
        return roll.getValue();
    }

    @Override
    public AnalyticTrend getTrend(AnalyticContext cx) {
        return new MyTrend(this, cx);
    }

    @Override
    public boolean hasTrend(AnalyticContext cx) {
        return this.getInput(0).hasTrend(cx);
    }

    private static class MyTrend
    extends BlockTrend {
        private List<AnalyticValue> rows = new LinkedList<AnalyticValue>();
        private Combiner roll;
        private long windowMillis;

        public MyTrend(BSlidingWindowBlock block, AnalyticContext cx) {
            super(block, cx);
            this.roll = block.getUseRequestRollup() ? cx.getRollup(true).makeCombiner() : block.getRollup().makeCombiner();
            this.windowMillis = block.getWindow().getMillis() - 1L;
        }

        @Override
        protected AnalyticValue getNext() {
            if (!this.advance()) {
                return null;
            }
            AnalyticValue val = this.getValue(0);
            this.rows.add(val.newCopy());
            long oldest = val.getTimestamp() - this.windowMillis;
            val = this.rows.get(0);
            while (val.getTimestamp() < oldest) {
                this.rows.remove(0);
                val = this.rows.get(0);
            }
            this.roll.reset();
            this.rows.forEach(this.roll);
            this.roll.getValue().setTimestamp(this.getValue(0).getTimestamp());
            return this.roll.getValue();
        }
    }
}

