/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.analytics.algorithm;

import com.tridiumx.analytics.algorithm.AlgorithmBlock;
import com.tridiumx.analytics.algorithm.BPsychrometricMode;
import com.tridiumx.analytics.util.Utils;
import javax.baja.sys.BDouble;
import javax.baja.sys.BFacets;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.bajax.analytics.AnalyticContext;
import javax.bajax.analytics.algorithm.BBlockPin;
import javax.bajax.analytics.algorithm.BOutputBlock;
import javax.bajax.analytics.algorithm.BlockTrend;
import javax.bajax.analytics.data.AnalyticNumeric;
import javax.bajax.analytics.data.AnalyticTrend;
import javax.bajax.analytics.data.AnalyticValue;

public class BPsychrometricBlock
extends BOutputBlock {
    public static final Property temperatureIn = BPsychrometricBlock.newProperty((int)8, (BValue)new BBlockPin(), null);
    public static final Property humidityIn = BPsychrometricBlock.newProperty((int)8, (BValue)new BBlockPin(), null);
    public static final Property units = BPsychrometricBlock.newProperty((int)0, (boolean)true, (BFacets)BFacets.makeBoolean((String)Utils.lex("english"), (String)Utils.lex("metric")));
    public static final Property mode = BPsychrometricBlock.newProperty((int)8, (BValue)BPsychrometricMode.enthalpy, null);
    public static final Type TYPE = Sys.loadType(BPsychrometricBlock.class);
    private static double[] p = new double[]{0.01083, 0.011438, 0.012078, 0.01275, 0.013456, 0.014198, 0.014977, 0.015795, 0.016655, 0.017556, 0.018502, 0.019496, 0.020537, 0.021629, 0.022775, 0.023975, 0.025233, 0.026552, 0.027933, 0.02938, 0.030894, 0.03248, 0.03414, 0.035878, 0.037697, 0.039598, 0.041587, 0.043667, 0.045841, 0.048114, 0.050489, 0.052971, 0.055564, 0.058273, 0.061097, 0.064053, 0.067133, 0.070349, 0.073705, 0.077208, 0.080859, 0.08467, 0.088643, 0.09229, 0.09607, 0.09998, 0.10403, 0.10823, 0.11257, 0.11707, 0.12173, 0.12655, 0.13153, 0.13669, 0.14203, 0.14755, 0.15327, 0.15917, 0.16528, 0.17159, 0.17811, 0.18485, 0.19181, 0.199, 0.20643, 0.2141, 0.22203, 0.2302, 0.23865, 0.24736, 0.25635, 0.26563, 0.2752, 0.28507, 0.29525, 0.30575, 0.31657, 0.32772, 0.33922, 0.35107, 0.36329, 0.37587, 0.38883, 0.40217, 0.41593, 0.43009, 0.44466, 0.45967, 0.47511, 0.491, 0.50737, 0.5242, 0.5415, 0.55933, 0.57763, 0.59648, 0.61585, 0.63576, 0.65625, 0.67726, 0.6989, 0.72113, 0.74395, 0.76742, 0.79151, 0.81628, 0.8417, 0.86779, 0.89459, 0.92211, 0.95034, 0.97934, 1.00906, 1.03958, 1.0709, 1.10304, 1.13602, 1.1698, 1.20446, 1.24003, 1.27646, 1.31383, 1.35219, 1.39139, 1.43167, 1.47288, 1.51515, 1.55845, 1.60281, 1.64824, 1.69473, 1.74243, 1.79125, 1.84119, 1.8924, 1.94477, 1.99832, 2.05324, 2.10939, 2.16687, 2.22565, 2.28581, 2.34731, 2.41036, 2.47464, 2.54053, 2.60789, 2.67671, 2.74713, 2.81907, 2.89262, 2.96782, 3.04475, 3.12324, 3.2035, 3.28548, 3.36935, 3.45494, 3.54239, 3.63165, 3.72283};

    public BBlockPin getTemperatureIn() {
        return (BBlockPin)this.get(temperatureIn);
    }

    public void setTemperatureIn(BBlockPin v) {
        this.set(temperatureIn, (BValue)v, null);
    }

    public BBlockPin getHumidityIn() {
        return (BBlockPin)this.get(humidityIn);
    }

    public void setHumidityIn(BBlockPin v) {
        this.set(humidityIn, (BValue)v, null);
    }

    public boolean getUnits() {
        return this.getBoolean(units);
    }

    public void setUnits(boolean v) {
        this.setBoolean(units, v, null);
    }

    public BPsychrometricMode getMode() {
        return (BPsychrometricMode)this.get(mode);
    }

    public void setMode(BPsychrometricMode v) {
        this.set(mode, (BValue)v, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    @Override
    public AnalyticTrend getTrend(AnalyticContext cx) {
        return new MyTrend(this, cx);
    }

    @Override
    public AnalyticValue getValue(AnalyticContext cx) {
        return this.eval(this.getInputValue(0, cx), this.getInputValue(1, cx));
    }

    private AnalyticValue eval(AnalyticValue tempIn, AnalyticValue humIn) {
        double rh;
        boolean valid = true;
        double temp = tempIn.toNumeric();
        boolean isEnglish = this.getUnits();
        if (!isEnglish) {
            temp = this.toEnglishTemp(temp);
        }
        if (!BPsychrometricBlock.isTempValid(temp)) {
            valid = false;
        }
        if (!BPsychrometricBlock.isRHValid(rh = humIn.toNumeric())) {
            valid = false;
        }
        double res = 0.0;
        try {
            switch (this.getMode().getOrdinal()) {
                case 0: {
                    double press = BPsychrometricBlock.vaporPressure(temp, rh);
                    if (!BPsychrometricBlock.isPressureValid(press)) {
                        valid = false;
                    }
                    res = BPsychrometricBlock.vaporTemperature(press);
                    if (!isEnglish) {
                        res = this.toMetricTemp(res);
                    }
                    break;
                }
                case 1: {
                    double pw = BPsychrometricBlock.vaporPressure(temp, rh);
                    double w = 0.62198 * pw / (14.696 - pw);
                    res = 0.24 * temp + w * (1061.0 + 0.444 * temp);
                    if (!isEnglish) {
                        res = this.toMetricEnthalpy(res);
                    }
                    break;
                }
                case 2: {
                    res = BPsychrometricBlock.saturationPressure(temp);
                    if (!isEnglish) {
                        res = this.toMetricPsr(res);
                    }
                    break;
                }
                case 3: {
                    res = BPsychrometricBlock.vaporPressure(temp, rh);
                    if (!isEnglish) {
                        res = this.toMetricPsr(res);
                    }
                    break;
                }
                default: {
                    res = BPsychrometricBlock.wetbulbTemp(temp, rh);
                    if (!isEnglish) {
                        res = this.toMetricTemp(res);
                    }
                    break;
                }
            }
        }
        catch (Exception x) {
            valid = false;
        }
        if (tempIn instanceof AnalyticNumeric) {
            if (valid) {
                ((AnalyticNumeric)tempIn).setValue(res);
            } else {
                ((AnalyticNumeric)tempIn).setValue(0.0).setStatus(64);
            }
        } else if (valid) {
            tempIn.setValue(BDouble.make((double)res));
        } else {
            tempIn.setValue(BDouble.make((double)res)).setStatus(64);
        }
        return tempIn.orStatus(humIn);
    }

    private static boolean isPressureValid(double press) {
        return !(press < 0.01083) && !(press > 3.72283) && !Double.isNaN(press);
    }

    private static boolean isTempValid(double temp) {
        return !(temp < -10.0) && !(temp > 150.0) && !Double.isNaN(temp);
    }

    private static boolean isRHValid(double rh) {
        return !(rh < 0.1) && !(rh > 100.0) && !Double.isNaN(rh);
    }

    public static double saturationPressure(double temp) {
        double dx = 0.01;
        if (temp < 0.0) {
            dx = 0.0 - dx;
        }
        int t1 = (int)temp * 10;
        int t2 = (int)(temp * 10.0 + dx);
        int t3 = t2 - t1;
        int i = t1 / 10 + 10;
        return (p[i + 1] - p[i]) * ((double)(t3 * 10) / 100.0) + p[i];
    }

    private double toEnglishTemp(double arg) {
        return 1.8 * arg + 32.0;
    }

    private double toMetricEnthalpy(double arg) {
        return (arg - 7.68152) * 2.326;
    }

    private double toMetricPsr(double arg) {
        return arg * 6.89475729;
    }

    private double toMetricTemp(double arg) {
        return (arg - 32.0) * 0.5555555555555556;
    }

    private static double vaporPressure(double temp, double rh) {
        return BPsychrometricBlock.saturationPressure(temp) * rh / 100.0;
    }

    private static double vaporTemperature(double press) {
        int i = 0;
        while (press > p[i]) {
            ++i;
        }
        if (Utils.isEqualTo(press, p[i])) {
            return i - 10;
        }
        return (press - p[i - 1]) / (p[i] - p[i - 1]) + (double)(i - 11);
    }

    private static double wetbulbTemp(double temp, double RH) {
        int i = 0;
        double pw = RH * BPsychrometricBlock.saturationPressure(temp) / 100.0;
        double w = 0.62198 * pw / (14.7 - pw);
        double err = 1.0;
        double t = temp;
        double tn = -11.0;
        double tw = 0.0;
        while (err > 1.0E-6 && i < 20) {
            ++i;
            tw = (t + tn) * 0.5;
            double pww = BPsychrometricBlock.saturationPressure(tw);
            double ww = 0.62198 * pww / (14.7 - pww);
            double wn = ((1093.0 - 0.556 * tw) * ww - 0.24 * (temp - tw)) / (1093.0 + 0.444 * temp - tw);
            if (wn < 0.0) {
                tn += 5.0;
                continue;
            }
            err = w - wn;
            if (err < 0.0) {
                t = tw;
            } else {
                tn = tw;
            }
            err = err < 0.0 ? 0.0 - err : err;
        }
        return tw;
    }

    private class MyTrend
    extends BlockTrend {
        public MyTrend(AlgorithmBlock block, AnalyticContext cx) {
            super(block, cx);
        }

        @Override
        protected AnalyticValue getNext() {
            if (!this.advance()) {
                return null;
            }
            return BPsychrometricBlock.this.eval(this.getValue(0), this.getValue(1));
        }
    }
}

