/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.analytics.algorithm;

import com.tridiumx.analytics.AnalyticContextWrapper;
import com.tridiumx.analytics.data.Values;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.bajax.analytics.AnalyticConstants;
import javax.bajax.analytics.AnalyticContext;
import javax.bajax.analytics.algorithm.BBlockPin;
import javax.bajax.analytics.algorithm.BOutputBlock;
import javax.bajax.analytics.algorithm.BlockTrend;
import javax.bajax.analytics.data.AnalyticNumeric;
import javax.bajax.analytics.data.AnalyticTrend;
import javax.bajax.analytics.data.AnalyticValue;
import javax.bajax.analytics.time.BAnalyticTimeRange;

public class BDemandToConsumptionBlock
extends BOutputBlock
implements AnalyticConstants {
    public static final Property trendIn = BDemandToConsumptionBlock.newProperty((int)8, (BValue)new BBlockPin(), null);
    public static final Type TYPE = Sys.loadType(BDemandToConsumptionBlock.class);

    public BBlockPin getTrendIn() {
        return (BBlockPin)this.get(trendIn);
    }

    public void setTrendIn(BBlockPin v) {
        this.set(trendIn, (BValue)v, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    @Override
    public AnalyticValue getValue(AnalyticContext cx) {
        AnalyticValue current = this.getInput(0).getValue(cx);
        cx = new AnalyticContextWrapper(cx);
        BAbsTime now = Clock.time();
        BAbsTime start = now.subtract(BRelTime.HOUR);
        cx.setTimeRange(BAnalyticTimeRange.make(start, now));
        AnalyticTrend trend = this.getInput(0).getTrend(cx);
        long end = cx.getEndTime();
        AnalyticValue last = null;
        AnalyticValue row = null;
        while (trend.hasNext() && (row = trend.next()).getTimestamp() <= end) {
            if (last == null) {
                last = row;
                continue;
            }
            if (!row.isValid()) continue;
            last = row;
        }
        if (last == null) {
            return current.setStatus(64);
        }
        long time = current.getTimestamp() - last.getTimestamp();
        if (time <= 0L) {
            return current.setStatus(64);
        }
        double val = current.toNumeric() * ((double)time / 3600000.0);
        if (current instanceof AnalyticNumeric) {
            AnalyticNumeric ret = (AnalyticNumeric)current;
            ret.setValue(val);
            return ret;
        }
        return Values.makeNumeric(val).setTimestamp(current.getTimestamp()).setStatus(current.getStatus());
    }

    @Override
    public AnalyticTrend getTrend(AnalyticContext cx) {
        return new MyTrend(this, cx);
    }

    private static class MyTrend
    extends BlockTrend {
        AnalyticNumeric cache = null;
        AnalyticValue last = null;

        public MyTrend(BDemandToConsumptionBlock block, AnalyticContext cx) {
            super(block, cx);
        }

        @Override
        protected AnalyticValue getNext() {
            while (this.advance()) {
                AnalyticValue row = this.getValue(0);
                if (this.last == null) {
                    this.last = row.newCopy();
                    this.cache = AnalyticValue.makeNumeric();
                    continue;
                }
                long time = row.getTimestamp() - this.last.getTimestamp();
                if (time <= 0L) continue;
                double val = row.toNumeric() * ((double)time / 3600000.0);
                this.cache.setValue(val).setTimestamp(this.last.getTimestamp()).setStatus(this.last.getStatus());
                this.last.copyTimestamp(row).copyStatus(row);
                return this.cache;
            }
            return null;
        }
    }
}

