/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.analytics.algorithm;

import com.tridiumx.analytics.algorithm.AlgorithmBlock;
import com.tridiumx.analytics.data.BooleanValue;
import com.tridiumx.analytics.util.Utils;
import javax.baja.sys.BFacets;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.bajax.analytics.AnalyticContext;
import javax.bajax.analytics.algorithm.BBlockPin;
import javax.bajax.analytics.algorithm.BOutputBlock;
import javax.bajax.analytics.algorithm.BlockTrend;
import javax.bajax.analytics.data.AnalyticTrend;
import javax.bajax.analytics.data.AnalyticValue;

public class BDeadbandSwitchBlock
extends BOutputBlock {
    public static final Property testIn = BDeadbandSwitchBlock.newProperty((int)8, (BValue)new BBlockPin(), null);
    public static final Property baselineIn = BDeadbandSwitchBlock.newProperty((int)8, (BValue)new BBlockPin(), null);
    public static final Property deadbandIn = BDeadbandSwitchBlock.newProperty((int)8, (BValue)new BBlockPin(), null);
    public static final Property trueIn = BDeadbandSwitchBlock.newProperty((int)8, (BValue)new BBlockPin(), null);
    public static final Property falseIn = BDeadbandSwitchBlock.newProperty((int)8, (BValue)new BBlockPin(), null);
    public static final Property deadbandMode = BDeadbandSwitchBlock.newProperty((int)8, (boolean)true, (BFacets)BFacets.makeBoolean((String)Utils.lex("absolute"), (String)Utils.lex("percent")));
    public static final Property percentMode = BDeadbandSwitchBlock.newProperty((int)8, (boolean)true, (BFacets)BFacets.makeBoolean((String)Utils.lex("percent"), (String)Utils.lex("decimal")));
    public static final Type TYPE = Sys.loadType(BDeadbandSwitchBlock.class);

    public BBlockPin getTestIn() {
        return (BBlockPin)this.get(testIn);
    }

    public void setTestIn(BBlockPin v) {
        this.set(testIn, (BValue)v, null);
    }

    public BBlockPin getBaselineIn() {
        return (BBlockPin)this.get(baselineIn);
    }

    public void setBaselineIn(BBlockPin v) {
        this.set(baselineIn, (BValue)v, null);
    }

    public BBlockPin getDeadbandIn() {
        return (BBlockPin)this.get(deadbandIn);
    }

    public void setDeadbandIn(BBlockPin v) {
        this.set(deadbandIn, (BValue)v, null);
    }

    public BBlockPin getTrueIn() {
        return (BBlockPin)this.get(trueIn);
    }

    public void setTrueIn(BBlockPin v) {
        this.set(trueIn, (BValue)v, null);
    }

    public BBlockPin getFalseIn() {
        return (BBlockPin)this.get(falseIn);
    }

    public void setFalseIn(BBlockPin v) {
        this.set(falseIn, (BValue)v, null);
    }

    public boolean getDeadbandMode() {
        return this.getBoolean(deadbandMode);
    }

    public void setDeadbandMode(boolean v) {
        this.setBoolean(deadbandMode, v, null);
    }

    public boolean getPercentMode() {
        return this.getBoolean(percentMode);
    }

    public void setPercentMode(boolean v) {
        this.setBoolean(percentMode, v, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    @Override
    public AnalyticValue getInputDefault(int idx, AnalyticContext cx) {
        if (idx == 3) {
            return new BooleanValue(System.currentTimeMillis(), true, 0);
        }
        return new BooleanValue(System.currentTimeMillis(), false, 0);
    }

    @Override
    public AnalyticTrend getTrend(AnalyticContext cx) {
        return new MyTrend(this, cx);
    }

    public boolean isAbsolute() {
        return this.getDeadbandMode();
    }

    public boolean isDecimal() {
        return !this.getPercentMode();
    }

    @Override
    public AnalyticValue getValue(AnalyticContext cx) {
        AnalyticValue base = this.getInput(1).getValue(cx);
        AnalyticValue dead = this.getInput(2).getValue(cx);
        double val = base.toNumeric();
        double band = 0.0;
        band = this.isAbsolute() ? dead.toNumeric() : (this.isDecimal() ? val * dead.toNumeric() : val * (dead.toNumeric() / 100.0));
        double min = val - band;
        double max = val + band;
        AnalyticValue test = this.getInput(0).getValue(cx);
        val = test.toNumeric();
        if (val < min || val > max) {
            return this.getInputValue(4, cx).orStatus(test).orStatus(base).orStatus(dead);
        }
        return this.getInputValue(3, cx).orStatus(test).orStatus(base).orStatus(dead);
    }

    @Override
    public boolean isInputRequired(int idx) {
        return idx < 3;
    }

    private class MyTrend
    extends BlockTrend {
        public MyTrend(AlgorithmBlock block, AnalyticContext cx) {
            super(block, cx);
        }

        @Override
        protected AnalyticValue getNext() {
            if (!this.advance()) {
                return null;
            }
            AnalyticValue base = this.getValue(1);
            AnalyticValue dead = this.getValue(2);
            double val = base.toNumeric();
            double band = 0.0;
            band = BDeadbandSwitchBlock.this.isAbsolute() ? dead.toNumeric() : (BDeadbandSwitchBlock.this.isDecimal() ? val * dead.toNumeric() : val * (dead.toNumeric() / 100.0));
            double min = val - band;
            double max = val + band;
            AnalyticValue test = this.getValue(0);
            val = test.toNumeric();
            if (val < min || val > max) {
                return this.getValue(4).orStatus(test).orStatus(base).orStatus(dead);
            }
            return this.getValue(3).orStatus(test).orStatus(base).orStatus(dead);
        }
    }
}

