/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.analytics.algorithm;

import com.tridiumx.analytics.AnalyticContextWrapper;
import com.tridiumx.analytics.algorithm.AlgorithmBlock;
import com.tridiumx.analytics.data.BooleanValue;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.bajax.analytics.AnalyticContext;
import javax.bajax.analytics.algorithm.BBlockPin;
import javax.bajax.analytics.algorithm.BOutputBlock;
import javax.bajax.analytics.algorithm.BlockTrend;
import javax.bajax.analytics.data.AnalyticTrend;
import javax.bajax.analytics.data.AnalyticValue;
import javax.bajax.analytics.time.BAnalyticTimeRange;

public class BCovSwitchBlock
extends BOutputBlock {
    public static final Property testIn = BCovSwitchBlock.newProperty((int)8, (BValue)new BBlockPin(), null);
    public static final Property trueIn = BCovSwitchBlock.newProperty((int)8, (BValue)new BBlockPin(), null);
    public static final Property falseIn = BCovSwitchBlock.newProperty((int)8, (BValue)new BBlockPin(), null);
    public static final Property valueSearchLimit = BCovSwitchBlock.newProperty((int)8, (BValue)BRelTime.HOUR, null);
    public static final Type TYPE = Sys.loadType(BCovSwitchBlock.class);

    public BBlockPin getTestIn() {
        return (BBlockPin)this.get(testIn);
    }

    public void setTestIn(BBlockPin v) {
        this.set(testIn, (BValue)v, null);
    }

    public BBlockPin getTrueIn() {
        return (BBlockPin)this.get(trueIn);
    }

    public void setTrueIn(BBlockPin v) {
        this.set(trueIn, (BValue)v, null);
    }

    public BBlockPin getFalseIn() {
        return (BBlockPin)this.get(falseIn);
    }

    public void setFalseIn(BBlockPin v) {
        this.set(falseIn, (BValue)v, null);
    }

    public BRelTime getValueSearchLimit() {
        return (BRelTime)this.get(valueSearchLimit);
    }

    public void setValueSearchLimit(BRelTime v) {
        this.set(valueSearchLimit, (BValue)v, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    @Override
    public AnalyticValue getInputDefault(int idx, AnalyticContext cx) {
        if (idx == 1) {
            return new BooleanValue(System.currentTimeMillis(), true, 0);
        }
        return new BooleanValue(System.currentTimeMillis(), false, 0);
    }

    @Override
    public AnalyticTrend getTrend(AnalyticContext cx) {
        return new MyTrend(this, cx);
    }

    @Override
    public AnalyticValue getValue(AnalyticContext cx) {
        AnalyticTrend trend = this.getInput(0).getTrend(this.prepareContext(cx));
        long end = trend.getContext().getEndTime();
        AnalyticValue last = null;
        AnalyticValue tmp = null;
        while (trend.hasNext()) {
            tmp = trend.next();
            if (end > 0L && tmp.getTimestamp() > end) break;
            if (last == null) {
                last = tmp.newCopy();
                continue;
            }
            last.copy(tmp);
        }
        AnalyticValue current = this.getInput(0).getValue(cx);
        tmp = last != null && !current.statusValueEquals(last) ? this.getInputValue(1, cx) : this.getInputValue(2, cx);
        return tmp.orStatus(current);
    }

    @Override
    public boolean isInputRequired(int idx) {
        return idx == 0;
    }

    private AnalyticContext prepareContext(AnalyticContext cx) {
        AnalyticContextWrapper w = new AnalyticContextWrapper(cx);
        BAbsTime now = Clock.time();
        BAbsTime start = now.subtract(this.getValueSearchLimit());
        w.setTimeRange(BAnalyticTimeRange.make(start, now));
        return w;
    }

    private static class MyTrend
    extends BlockTrend {
        private AnalyticValue last;

        public MyTrend(AlgorithmBlock block, AnalyticContext cx) {
            super(block, cx);
        }

        @Override
        protected AnalyticValue getNext() {
            if (!this.advance()) {
                return null;
            }
            AnalyticValue val = this.getValue(0);
            if (this.last == null) {
                this.last = val.newCopy();
            }
            AnalyticValue ret = null;
            ret = !val.statusValueEquals(this.last) ? this.getValue(1) : this.getValue(2);
            this.last.copy(val);
            return ret.orStatus(val);
        }
    }
}

