/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.analytics.algorithm;

import com.tridiumx.analytics.algorithm.AlgorithmBlock;
import com.tridiumx.analytics.algorithm.BBooleanOperator;
import com.tridiumx.analytics.data.AbstractAnalyticValue;
import com.tridiumx.analytics.data.BooleanValue;
import com.tridiumx.analytics.history.BInterpolationTrendFlags;
import javax.baja.sys.Action;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.bajax.analytics.AnalyticContext;
import javax.bajax.analytics.algorithm.BBlockPin;
import javax.bajax.analytics.algorithm.BOutputBlock;
import javax.bajax.analytics.algorithm.BlockTrend;
import javax.bajax.analytics.data.AnalyticTrend;
import javax.bajax.analytics.data.AnalyticValue;

public class BBiSwitchBlock
extends BOutputBlock {
    public static final Property in1 = BBiSwitchBlock.newProperty((int)8, (BValue)new BBlockPin(), null);
    public static final Property operator = BBiSwitchBlock.newProperty((int)8, (BValue)BBooleanOperator.equal, null);
    public static final Property in2 = BBiSwitchBlock.newProperty((int)8, (BValue)new BBlockPin(), null);
    public static final Property trueIn = BBiSwitchBlock.newProperty((int)8, (BValue)new BBlockPin(), null);
    public static final Property falseIn = BBiSwitchBlock.newProperty((int)8, (BValue)new BBlockPin(), null);
    public static final Action configureOperator = BBiSwitchBlock.newAction((int)0, (BValue)BBooleanOperator.equal, null);
    public static final Type TYPE = Sys.loadType(BBiSwitchBlock.class);

    public BBlockPin getIn1() {
        return (BBlockPin)this.get(in1);
    }

    public void setIn1(BBlockPin v) {
        this.set(in1, (BValue)v, null);
    }

    public BBooleanOperator getOperator() {
        return (BBooleanOperator)this.get(operator);
    }

    public void setOperator(BBooleanOperator v) {
        this.set(operator, (BValue)v, null);
    }

    public BBlockPin getIn2() {
        return (BBlockPin)this.get(in2);
    }

    public void setIn2(BBlockPin v) {
        this.set(in2, (BValue)v, null);
    }

    public BBlockPin getTrueIn() {
        return (BBlockPin)this.get(trueIn);
    }

    public void setTrueIn(BBlockPin v) {
        this.set(trueIn, (BValue)v, null);
    }

    public BBlockPin getFalseIn() {
        return (BBlockPin)this.get(falseIn);
    }

    public void setFalseIn(BBlockPin v) {
        this.set(falseIn, (BValue)v, null);
    }

    public void configureOperator(BBooleanOperator arg) {
        this.invoke(configureOperator, (BValue)arg, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    public void doConfigureOperator(BBooleanOperator op) {
        this.setOperator(op);
    }

    public BValue getActionParameterDefault(Action a) {
        if (a == configureOperator) {
            return this.get(operator);
        }
        return super.getActionParameterDefault(a);
    }

    @Override
    public AnalyticValue getInputDefault(int idx, AnalyticContext cx) {
        if (idx == 2) {
            return new BooleanValue(System.currentTimeMillis(), true, 0);
        }
        return new BooleanValue(System.currentTimeMillis(), false, 0);
    }

    @Override
    public AnalyticTrend getTrend(AnalyticContext cx) {
        return new MyTrend(this, cx);
    }

    @Override
    public AnalyticValue getValue(AnalyticContext cx) {
        AnalyticValue val0 = this.getInputValue(0, cx);
        BBooleanOperator op = this.getOperator();
        AnalyticValue ret = null;
        if (op == BBooleanOperator.or) {
            if (val0.toBoolean()) {
                ret = this.getInputValue(2, cx);
                ret.setTimestamp(val0.getTimestamp());
                ret.setStatus(val0.getStatus() | ret.getStatus());
                return ret;
            }
        } else if (op == BBooleanOperator.and && !val0.toBoolean()) {
            ret = this.getInputValue(3, cx);
            ret.setTimestamp(val0.getTimestamp());
            ret.setStatus(val0.getStatus() | ret.getStatus());
            return ret;
        }
        AnalyticValue val1 = this.getInputValue(1, cx);
        ret = this.getOperator().evaluate(val0, val1) ? this.getInputValue(2, cx) : this.getInputValue(3, cx);
        return ret.orStatus(val0).orStatus(val1);
    }

    @Override
    public boolean isInputRequired(int idx) {
        return idx < 2;
    }

    private class MyTrend
    extends BlockTrend {
        public MyTrend(AlgorithmBlock block, AnalyticContext cx) {
            super(block, cx);
        }

        @Override
        protected AnalyticValue getNext() {
            if (!this.advance()) {
                return null;
            }
            AnalyticValue ret = null;
            AnalyticValue val0 = this.getValue(0);
            AnalyticValue val1 = this.getValue(1);
            ret = BBiSwitchBlock.this.getOperator().evaluate(val0, val1) ? this.getValue(2) : this.getValue(3);
            if (this.getValue(3).toBoolean()) {
                ret.setStatus(val0.getStatus() | val1.getStatus() | ret.getStatus());
            } else {
                ret.setStatus(val0.getStatus() | val1.getStatus());
            }
            if (ret instanceof AbstractAnalyticValue) {
                AbstractAnalyticValue aVal0 = (AbstractAnalyticValue)val0;
                AbstractAnalyticValue aVal1 = (AbstractAnalyticValue)val1;
                int trendFlags = aVal0.getTrendFlags().getBits() | aVal1.getTrendFlags().getBits();
                ((AbstractAnalyticValue)ret).setTrendFlags(BInterpolationTrendFlags.make(trendFlags));
            }
            ret.setTimestamp(val0.getTimestamp());
            return ret;
        }
    }
}

