/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.analytics.algorithm;

import com.tridiumx.analytics.algorithm.AlgorithmBlock;
import com.tridiumx.analytics.algorithm.BBiMathOperator;
import com.tridiumx.analytics.data.AbstractAnalyticValue;
import com.tridiumx.analytics.history.BInterpolationTrendFlags;
import javax.baja.sys.Action;
import javax.baja.sys.BDouble;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.bajax.analytics.AnalyticContext;
import javax.bajax.analytics.algorithm.BBlockPin;
import javax.bajax.analytics.algorithm.BOutputBlock;
import javax.bajax.analytics.algorithm.BlockTrend;
import javax.bajax.analytics.data.AnalyticNumeric;
import javax.bajax.analytics.data.AnalyticTrend;
import javax.bajax.analytics.data.AnalyticValue;

public class BBiMathBlock
extends BOutputBlock {
    public static final Property in1 = BBiMathBlock.newProperty((int)8, (BValue)new BBlockPin(), null);
    public static final Property operator = BBiMathBlock.newProperty((int)8, (BValue)BBiMathOperator.add, null);
    public static final Property in2 = BBiMathBlock.newProperty((int)8, (BValue)new BBlockPin(), null);
    public static final Action configureOperator = BBiMathBlock.newAction((int)0, (BValue)BBiMathOperator.add, null);
    public static final Type TYPE = Sys.loadType(BBiMathBlock.class);

    public BBlockPin getIn1() {
        return (BBlockPin)this.get(in1);
    }

    public void setIn1(BBlockPin v) {
        this.set(in1, (BValue)v, null);
    }

    public BBiMathOperator getOperator() {
        return (BBiMathOperator)this.get(operator);
    }

    public void setOperator(BBiMathOperator v) {
        this.set(operator, (BValue)v, null);
    }

    public BBlockPin getIn2() {
        return (BBlockPin)this.get(in2);
    }

    public void setIn2(BBlockPin v) {
        this.set(in2, (BValue)v, null);
    }

    public void configureOperator(BBiMathOperator arg) {
        this.invoke(configureOperator, (BValue)arg, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    public void doConfigureOperator(BBiMathOperator op) {
        this.setOperator(op);
    }

    public BValue getActionParameterDefault(Action a) {
        if (a == configureOperator) {
            return this.get(operator);
        }
        return super.getActionParameterDefault(a);
    }

    @Override
    public AnalyticTrend getTrend(AnalyticContext cx) {
        return new MyTrend(this, cx);
    }

    @Override
    public AnalyticValue getValue(AnalyticContext cx) {
        return this.eval(this.getInputValue(0, cx), this.getInputValue(1, cx));
    }

    private AnalyticValue eval(AnalyticValue in1, AnalyticValue in2) {
        AnalyticValue ret = in1;
        double result = this.getOperator().evaluate(in1.toNumeric(), in2.toNumeric());
        int sts = in1.getStatus() | in2.getStatus();
        if (Double.isNaN(result) || Double.isInfinite(result)) {
            sts |= 0x40;
        }
        if (ret instanceof AnalyticNumeric) {
            ((AnalyticNumeric)ret).setValue(result);
        } else {
            ret.setValue(BDouble.make((double)result));
        }
        ret.setStatus(sts);
        if (ret instanceof AbstractAnalyticValue) {
            AbstractAnalyticValue val1 = (AbstractAnalyticValue)in1;
            AbstractAnalyticValue val2 = (AbstractAnalyticValue)in2;
            int trendFlags = val1.getTrendFlags().getBits() | val2.getTrendFlags().getBits();
            ((AbstractAnalyticValue)ret).setTrendFlags(BInterpolationTrendFlags.make(trendFlags));
        }
        return ret;
    }

    private class MyTrend
    extends BlockTrend {
        public MyTrend(AlgorithmBlock block, AnalyticContext cx) {
            super(block, cx);
        }

        @Override
        protected AnalyticValue getNext() {
            if (!this.advance()) {
                return null;
            }
            return BBiMathBlock.this.eval(this.getValue(0), this.getValue(1));
        }
    }
}

