/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.analytics.alert;

import javax.baja.sys.BFrozenEnum;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.bajax.analytics.AnalyticConstants;

public final class BAlertWeight
extends BFrozenEnum
implements AnalyticConstants {
    public static final int OCCURRENCES = 0;
    public static final int RUNTIME_MILLIS = 1;
    public static final int RUNTIME_SECONDS = 2;
    public static final int RUNTIME_MINUTES = 3;
    public static final int RUNTIME_HOURS = 4;
    public static final BAlertWeight occurrences = new BAlertWeight(0);
    public static final BAlertWeight runtimeMillis = new BAlertWeight(1);
    public static final BAlertWeight runtimeSeconds = new BAlertWeight(2);
    public static final BAlertWeight runtimeMinutes = new BAlertWeight(3);
    public static final BAlertWeight runtimeHours = new BAlertWeight(4);
    public static final BAlertWeight DEFAULT = occurrences;
    public static final Type TYPE = Sys.loadType(BAlertWeight.class);

    public static BAlertWeight make(int ordinal) {
        return (BAlertWeight)occurrences.getRange().get(ordinal, false);
    }

    public static BAlertWeight make(String tag) {
        return (BAlertWeight)occurrences.getRange().get(tag);
    }

    private BAlertWeight(int ordinal) {
        super(ordinal);
    }

    public Type getType() {
        return TYPE;
    }

    public boolean isRuntime() {
        return this != occurrences;
    }

    public double convert(long millis) {
        double ms = millis;
        switch (this.getOrdinal()) {
            case 2: {
                return ms / 1000.0;
            }
            case 3: {
                return ms / 60000.0;
            }
            case 4: {
                return ms / 3600000.0;
            }
        }
        return millis;
    }
}

