/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.web.mobile;

import com.tridium.util.PxUtil;
import com.tridium.web.IHxConfigProvider;
import com.tridium.web.IWebEnvProvider;
import com.tridium.web.WebEnv;
import com.tridium.web.WebProcessException;
import com.tridium.web.WebUtil;
import com.tridium.web.servlets.BFileUploadView;
import javax.baja.agent.AgentFilter;
import javax.baja.agent.AgentInfo;
import javax.baja.agent.AgentList;
import javax.baja.agent.BAbstractPxView;
import javax.baja.naming.BOrd;
import javax.baja.nav.BNavFileNode;
import javax.baja.nav.NavFileDecoder;
import javax.baja.registry.TypeInfo;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.user.BUser;
import javax.baja.util.BTypeSpec;
import javax.baja.web.BIWebProfile;
import javax.baja.web.BServletView;
import javax.baja.web.BWebProfileConfig;
import javax.baja.web.IWebEnv;
import javax.baja.web.WebOp;
import javax.baja.web.mobile.BIMobilePxView;
import javax.baja.web.mobile.BIMobileWebOperationalView;
import javax.baja.web.mobile.BIMobileWebProfile;
import javax.baja.web.mobile.BIMobileWebView;
import javax.baja.web.mobile.BMobileWebProfileConfig;

public abstract class BMobileWebProfile
extends BObject
implements BIMobileWebProfile,
IWebEnvProvider,
IHxConfigProvider {
    public static final Type TYPE = Sys.loadType(BMobileWebProfile.class);
    private static final String[] emptyStringArray = new String[0];
    private static final TypeInfo servlet = BServletView.TYPE.getTypeInfo();

    public Type getType() {
        return TYPE;
    }

    public String[] listConfig() {
        return emptyStringArray;
    }

    public BValue getConfig(String key) {
        return null;
    }

    public BFacets getConfigFacets(String key) {
        return BFacets.NULL;
    }

    public void setConfig(String key, BValue value) {
    }

    @Override
    public String[] getAppNames() {
        return emptyStringArray;
    }

    @Override
    public boolean hasView(BObject target, AgentInfo agentInfo) {
        return true;
    }

    @Override
    public BWebProfileConfig getHxProfileConfig(BWebProfileConfig mobileConfig) {
        BWebProfileConfig hxConfig = new BWebProfileConfig();
        hxConfig.setTypeSpec(BTypeSpec.make((String)"hx:HandheldHxProfile"));
        String themeName = this.getBajauxThemeName(mobileConfig);
        hxConfig.add("selectedHxTheme", (BValue)BDynamicEnum.make((int)0, (BEnumRange)BEnumRange.make((String[])new String[]{themeName})));
        return hxConfig;
    }

    public String getBajauxThemeName(BWebProfileConfig mobileConfig) {
        BTypeSpec spec = (BTypeSpec)mobileConfig.get("theme");
        if (spec != null) {
            if (spec.getTypeName().contains("Zebra")) {
                return "Zebra";
            }
            if (spec.getTypeName().contains("Lucid")) {
                return "Lucid";
            }
        }
        return "Zebra";
    }

    public static IWebEnv webEnv() {
        return WebEnvHolder.INSTANCE;
    }

    @Override
    public final IWebEnv getWebEnv(WebOp op) throws WebProcessException {
        return BMobileWebProfile.webEnv();
    }

    public final AgentFilter getMobileAgentFilter(Context cx) {
        return new MobileFilter(cx);
    }

    private static interface WebEnvHolder {
        public static final MobileEnv INSTANCE = new MobileEnv();
    }

    private static final class MobileViewFilter
    extends AgentFilter {
        private Context cx;
        private AgentFilter profileFilter;

        private MobileViewFilter(Context cx) {
            this.cx = cx;
            if (cx instanceof WebOp) {
                WebOp op = (WebOp)cx;
                BIWebProfile profile = (BIWebProfile)op.getProfileConfig(cx).make();
                BObject target = op.get();
                this.profileFilter = new WebUtil.ProfileFilter(profile, target);
            }
        }

        public boolean include(AgentInfo agent) {
            if (this.profileFilter != null && !this.profileFilter.include(agent)) {
                return false;
            }
            TypeInfo agentType = agent.getAgentType();
            boolean include = false;
            if (agentType.is(BIMobileWebView.TYPE)) {
                if (agentType.is(BIMobileWebOperationalView.TYPE)) {
                    try {
                        BIMobileWebOperationalView opView = (BIMobileWebOperationalView)agentType.getInstance();
                        include = opView.isOperational(this.cx);
                    }
                    catch (Throwable throwable) {}
                } else {
                    include = true;
                }
            }
            return include;
        }
    }

    private static final class MobileFilter
    extends AgentFilter {
        private Context cx;
        private AgentFilter profileFilter;

        private MobileFilter(Context cx) {
            this.cx = cx;
            if (cx instanceof WebOp) {
                WebOp op = (WebOp)cx;
                BIWebProfile profile = (BIWebProfile)op.getProfileConfig(cx).make();
                BObject target = op.get();
                this.profileFilter = new WebUtil.ProfileFilter(profile, target);
            }
        }

        public boolean include(AgentInfo agentInfo) {
            AgentList agentList;
            if (this.profileFilter != null && !this.profileFilter.include(agentInfo)) {
                return false;
            }
            TypeInfo agentType = agentInfo.getAgentType();
            MobileViewFilter viewFilter = new MobileViewFilter(this.cx);
            if (agentType.is(WebEnv.wbView)) {
                agentList = Sys.getRegistry().getAgents(agentType).filter((AgentFilter)viewFilter);
                if (agentList.size() == 0) {
                    return false;
                }
                agentInfo = agentList.getDefault();
            } else {
                if (agentType.is(BFileUploadView.TYPE)) {
                    return false;
                }
                if (!agentType.is(BIMobileWebView.TYPE)) {
                    if (agentType.is(WebEnv.hxView)) {
                        return false;
                    }
                    if (agentType.is(servlet)) {
                        return true;
                    }
                }
            }
            if (agentInfo instanceof BAbstractPxView) {
                agentList = Sys.getRegistry().getAgents(((BAbstractPxView)agentInfo).getType().getTypeInfo());
                if ((agentList = agentList.filter((AgentFilter)viewFilter)).size() == 0) {
                    return false;
                }
                agentInfo = agentList.getDefault();
                return agentInfo.getAgentType().is(BIMobilePxView.TYPE);
            }
            return viewFilter.include(agentInfo);
        }
    }

    private static final class MobileEnv
    implements IWebEnv {
        private MobileEnv() {
        }

        @Override
        public AgentInfo getDefaultView(WebOp op, AgentList views) {
            for (int i = 0; i < views.size(); ++i) {
                AgentInfo agent = views.get(i);
                TypeInfo agentType = agent.getAgentType();
                if (!agentType.is(WebEnv.pxView)) continue;
                return agent;
            }
            return views.getDefault();
        }

        @Override
        public AgentInfo translate(WebOp op, AgentInfo agentInfo) {
            if (agentInfo instanceof BAbstractPxView) {
                AgentList agentList = Sys.getRegistry().getAgents(((BAbstractPxView)agentInfo).getType().getTypeInfo());
                AgentInfo pxInfo = (agentList = agentList.filter((AgentFilter)new MobileViewFilter((Context)op))).getDefault();
                TypeInfo typeInfo = pxInfo.getAgentType();
                if (typeInfo.is(BIMobilePxView.TYPE)) {
                    return new PxUtil.PxMobile((BAbstractPxView)agentInfo, typeInfo);
                }
                return pxInfo;
            }
            if (agentInfo.getAgentType().is(WebEnv.wbView)) {
                AgentList views = Sys.getRegistry().getAgents(agentInfo.getAgentType());
                agentInfo = views.filter((AgentFilter)new MobileViewFilter((Context)op)).getDefault();
            }
            return agentInfo;
        }

        @Override
        public AgentList getViews(WebOp op) {
            return op.get().getAgents((Context)op).filter((AgentFilter)new MobileFilter((Context)op));
        }

        @Override
        public AgentInfo getView(AgentList allViews, String viewId) {
            return allViews.get(viewId);
        }

        @Override
        public BWebProfileConfig makeWebProfileConfig() {
            return new BMobileWebProfileConfig();
        }

        @Override
        public BWebProfileConfig getWebProfileConfig(BUser user) {
            return (BWebProfileConfig)user.getMixIn(BMobileWebProfileConfig.TYPE);
        }

        @Override
        public BIWebProfile getWebProfile(WebOp op) {
            BWebProfileConfig profileConfig = (BWebProfileConfig)((Object)op.getRequest().getSession(true).getAttribute("profileConfig"));
            if (profileConfig == null) {
                profileConfig = this.getWebProfileConfig(op.getUser());
                op.getRequest().getSession(true).setAttribute("profileConfig", (Object)profileConfig);
            }
            BIWebProfile profile = (BIWebProfile)profileConfig.make();
            return profile;
        }

        @Override
        public BWebProfileConfig getHxProfileConfig(BWebProfileConfig config) {
            BIWebProfile webProfile = config.makeWebProfile();
            if (webProfile instanceof IHxConfigProvider) {
                return ((IHxConfigProvider)((Object)webProfile)).getHxProfileConfig(config);
            }
            return WebUtil.getHandheldHxProfileConfig();
        }

        @Override
        public BOrd getHomePage(WebOp op) {
            BOrd navFile;
            BWebProfileConfig profileConfig = op.getProfileConfig();
            if (profileConfig != null && profileConfig instanceof BMobileWebProfileConfig) {
                try {
                    navFile = ((BMobileWebProfileConfig)profileConfig).getMobileNavFile();
                    if (!navFile.isNull()) {
                        BNavFileNode root = NavFileDecoder.load((BOrd)navFile).getRootNode();
                        return root.getOrdInSession();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                try {
                    navFile = op.getUser().getNavFile();
                    if (!navFile.isNull()) {
                        BNavFileNode root = NavFileDecoder.load((BOrd)navFile).getRootNode();
                        return root.getOrdInSession();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            try {
                BComponent comp = Sys.getService((Type)Sys.getType((String)"app:AppContainer"));
                return comp.getNavOrd().relativizeToSession();
            }
            catch (Throwable throwable) {
                return op.getUser().getHomePage();
            }
        }
    }
}

