/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.web.js;

import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.naming.BOrd;
import javax.baja.registry.TypeInfo;
import javax.baja.sys.BSingleton;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.web.WebDev;

public abstract class BJsBuild
extends BSingleton {
    public static final Type TYPE = Sys.loadType(BJsBuild.class);
    private static final String[] EMPTY = new String[0];
    private final String id;
    private final BOrd[] builtFiles;
    private final String[] dependentBuilds;
    private static boolean isAlreadyLogged = false;
    private static final Map<String, Optional<BJsBuild>> BY_ID = new ConcurrentHashMap<String, Optional<BJsBuild>>();

    public Type getType() {
        return TYPE;
    }

    public static Optional<BJsBuild> forId(String id) {
        if (id == null) {
            return Optional.empty();
        }
        return BY_ID.computeIfAbsent(id, BJsBuild::queryRegistryByIdSlow);
    }

    private static Optional<BJsBuild> queryRegistryByIdSlow(String id) {
        BJsBuild instance = null;
        for (TypeInfo typeInfo : Sys.getRegistry().getTypes(TYPE.getTypeInfo())) {
            if (typeInfo.isAbstract()) continue;
            try {
                instance = (BJsBuild)typeInfo.getInstance();
            }
            catch (RuntimeException e) {
                String message = "Unable to load BuildJS type -> " + typeInfo.toString();
                if (!isAlreadyLogged) {
                    Logger.getLogger("web.jsbuild").log(Level.SEVERE, message, e);
                    isAlreadyLogged = true;
                }
                Logger.getLogger("web.jsbuild").log(Level.FINE, message, e);
            }
            if (null == instance || !id.equals(instance.getId())) continue;
            return Optional.of(instance);
        }
        return Optional.empty();
    }

    private static String[] typesToDependencies(Type[] types) {
        if (types == null) {
            throw new IllegalArgumentException("array of BJsBuild types required");
        }
        return (String[])Arrays.stream(types).map(type -> {
            if (type == null || type.isAbstract() || !type.is(TYPE)) {
                throw new IllegalArgumentException("array of BJsBuild types required");
            }
            return ((BJsBuild)type.getInstance()).getId();
        }).toArray(String[]::new);
    }

    protected BJsBuild(String id, BOrd[] builtFiles) {
        this(id, builtFiles, EMPTY);
    }

    protected BJsBuild(String id, BOrd builtFile) {
        this(id, new BOrd[]{builtFile}, EMPTY);
    }

    protected BJsBuild(String id, BOrd builtFile, String ... dependentBuilds) {
        this(id, new BOrd[]{builtFile}, dependentBuilds);
    }

    protected BJsBuild(String id, BOrd builtFile, Type ... dependentBuilds) {
        this(id, new BOrd[]{builtFile}, dependentBuilds);
    }

    protected BJsBuild(String id, BOrd[] builtFiles, String[] dependentBuilds) {
        if (id == null) {
            throw new IllegalArgumentException("id required");
        }
        if (!BJsBuild.isArrayOfOrds(builtFiles)) {
            throw new IllegalArgumentException("built files required");
        }
        this.id = id;
        this.builtFiles = (BOrd[])builtFiles.clone();
        this.dependentBuilds = (String[])dependentBuilds.clone();
    }

    protected BJsBuild(String id, BOrd[] builtFiles, Type[] dependentTypes) {
        this(id, builtFiles, BJsBuild.typesToDependencies(dependentTypes));
    }

    public String getId() {
        return this.id;
    }

    public BOrd[] getBuiltFiles() {
        return (BOrd[])this.builtFiles.clone();
    }

    public BJsBuild[] getDependentBuilds() {
        return (BJsBuild[])Arrays.stream(this.dependentBuilds).map(b -> BJsBuild.forId(b)).filter(Optional::isPresent).map(Optional::get).toArray(BJsBuild[]::new);
    }

    public boolean isWebDevEnabled() {
        return WebDev.get(this.getId()).isEnabled();
    }

    private static boolean isArrayOfOrds(BOrd[] ords) {
        if (ords == null || ords.length == 0) {
            return false;
        }
        for (BOrd ord : ords) {
            if (ord != null) continue;
            return false;
        }
        return true;
    }
}

