/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.web.http;

import javax.baja.data.BIDataValue;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.web.BXFrameOptionsEnum;
import javax.baja.web.http.BIHttpHeaderProvider;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="enabled", type="boolean", defaultValue="true", facets={@Facet(name="BFacets.SECURITY", value="BBoolean.TRUE")}), @NiagaraProperty(name="xFrameOptions", type="BXFrameOptionsEnum", defaultValue="BXFrameOptionsEnum.deny", facets={@Facet(value="BFacets.make(BFacets.SECURITY, BBoolean.TRUE)")})})
public class BXFrameOptionsHeaderProvider
extends BComponent
implements BIHttpHeaderProvider {
    public static final Property enabled = BXFrameOptionsHeaderProvider.newProperty((int)0, (boolean)true, (BFacets)BFacets.make((String)"security", (BIDataValue)BBoolean.TRUE));
    public static final Property xFrameOptions = BXFrameOptionsHeaderProvider.newProperty((int)0, (BValue)BXFrameOptionsEnum.deny, (BFacets)BFacets.make((String)"security", (BIDataValue)BBoolean.TRUE));
    public static final Type TYPE = Sys.loadType(BXFrameOptionsHeaderProvider.class);
    public static final String HEADER_NAME = "X-Frame-Options";

    public boolean getEnabled() {
        return this.getBoolean(enabled);
    }

    public void setEnabled(boolean v) {
        this.setBoolean(enabled, v, null);
    }

    public BXFrameOptionsEnum getXFrameOptions() {
        return (BXFrameOptionsEnum)this.get(xFrameOptions);
    }

    public void setXFrameOptions(BXFrameOptionsEnum v) {
        this.set(xFrameOptions, (BValue)v, null);
    }

    public Type getType() {
        return TYPE;
    }

    @Override
    public void applyHeaders(HttpServletRequest req, HttpServletResponse resp) {
        if (!this.getEnabled()) {
            return;
        }
        String header = this.generateHeader();
        if (!header.isEmpty()) {
            resp.setHeader(HEADER_NAME, header);
        }
    }

    public String generateHeader() {
        BXFrameOptionsEnum xf = this.getXFrameOptions();
        return xf == BXFrameOptionsEnum.any ? "" : xf.getTag().toUpperCase();
    }
}

