/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.web.http;

import java.security.AccessController;
import javax.baja.data.BIDataValue;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.web.http.BIHttpHeaderProvider;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="enabled", type="boolean", defaultValue="true", facets={@Facet(name="BFacets.SECURITY", value="BBoolean.TRUE")}), @NiagaraProperty(name="xContentTypeOptions", type="baja:String", defaultValue="nosniff", facets={@Facet(name="BFacets.SECURITY", value="BBoolean.TRUE")})})
public class BXContentTypeOptionsHeaderProvider
extends BComponent
implements BIHttpHeaderProvider {
    public static final Property enabled = BXContentTypeOptionsHeaderProvider.newProperty((int)0, (boolean)true, (BFacets)BFacets.make((String)"security", (BIDataValue)BBoolean.TRUE));
    public static final Property xContentTypeOptions = BXContentTypeOptionsHeaderProvider.newProperty((int)0, (String)"nosniff", (BFacets)BFacets.make((String)"security", (BIDataValue)BBoolean.TRUE));
    public static final Type TYPE = Sys.loadType(BXContentTypeOptionsHeaderProvider.class);
    public static final String SYSTEM_PROPERTY_KEY = "niagara.web.security.contentTypeOptionsHeader";
    public static final String HEADER_NAME = "X-Content-Type-Options";
    private static String SYSTEM_PROPERTY = AccessController.doPrivileged(() -> System.getProperty(SYSTEM_PROPERTY_KEY));

    public boolean getEnabled() {
        return this.getBoolean(enabled);
    }

    public void setEnabled(boolean v) {
        this.setBoolean(enabled, v, null);
    }

    public String getXContentTypeOptions() {
        return this.getString(xContentTypeOptions);
    }

    public void setXContentTypeOptions(String v) {
        this.setString(xContentTypeOptions, v, null);
    }

    public Type getType() {
        return TYPE;
    }

    @Override
    public void applyHeaders(HttpServletRequest req, HttpServletResponse resp) {
        if (!this.getEnabled()) {
            return;
        }
        String header = this.generateHeader();
        if (!header.isEmpty()) {
            resp.setHeader(HEADER_NAME, header);
        }
    }

    public String generateHeader() {
        String header = SYSTEM_PROPERTY;
        if (header == null || header.isEmpty()) {
            header = this.getXContentTypeOptions();
        }
        if ("default".equals(header)) {
            header = "";
        }
        return header;
    }
}

