/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.web.http;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.baja.data.BIDataValue;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BIStatus;
import javax.baja.status.BStatus;
import javax.baja.sys.Action;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.web.http.BIHttpHeaderProvider;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="enabled", type="boolean", defaultValue="true", facets={@Facet(name="BFacets.SECURITY", value="BBoolean.TRUE")}), @NiagaraProperty(name="status", type="baja:Status", defaultValue="BStatus.ok", flags=3), @NiagaraProperty(name="violationText", type="baja:String", defaultValue="", flags=3), @NiagaraProperty(name="childSrc", type="baja:String", defaultValue="", facets={@Facet(name="BFacets.SECURITY", value="BBoolean.TRUE")}), @NiagaraProperty(name="connectSrc", type="baja:String", defaultValue="'self' workbench ws://%hostname%:%port% wss://%hostname%:%port%", facets={@Facet(name="BFacets.SECURITY", value="BBoolean.TRUE")}), @NiagaraProperty(name="defaultSrc", type="baja:String", defaultValue="'self' workbench", facets={@Facet(name="BFacets.SECURITY", value="BBoolean.TRUE")}), @NiagaraProperty(name="frameSrc", type="baja:String", defaultValue="", facets={@Facet(name="BFacets.SECURITY", value="BBoolean.TRUE")}), @NiagaraProperty(name="fontSrc", type="baja:String", defaultValue="", facets={@Facet(name="BFacets.SECURITY", value="BBoolean.TRUE")}), @NiagaraProperty(name="imgSrc", type="baja:String", defaultValue="'self' workbench data: module:", facets={@Facet(name="BFacets.SECURITY", value="BBoolean.TRUE")}), @NiagaraProperty(name="manifestSrc", type="baja:String", defaultValue="", facets={@Facet(name="BFacets.SECURITY", value="BBoolean.TRUE")}), @NiagaraProperty(name="mediaSrc", type="baja:String", defaultValue="", facets={@Facet(name="BFacets.SECURITY", value="BBoolean.TRUE")}), @NiagaraProperty(name="objectSrc", type="baja:String", defaultValue="", facets={@Facet(name="BFacets.SECURITY", value="BBoolean.TRUE")}), @NiagaraProperty(name="reportUri", type="baja:String", defaultValue="/csp-reports", facets={@Facet(name="BFacets.SECURITY", value="BBoolean.TRUE")}), @NiagaraProperty(name="scriptSrc", type="baja:String", defaultValue="'self' workbench 'unsafe-inline' 'unsafe-eval'", facets={@Facet(name="BFacets.SECURITY", value="BBoolean.TRUE")}), @NiagaraProperty(name="styleSrc", type="baja:String", defaultValue="'self' workbench 'unsafe-inline'", facets={@Facet(name="BFacets.SECURITY", value="BBoolean.TRUE")}), @NiagaraProperty(name="additionalDirectives", type="baja:String", defaultValue="", facets={@Facet(name="BFacets.MULTI_LINE", value="BBoolean.TRUE"), @Facet(name="BFacets.SECURITY", value="BBoolean.TRUE")})})
@NiagaraAction(name="clearFaultStatus")
public class BCspHeaderProvider
extends BComponent
implements BIHttpHeaderProvider,
BIStatus {
    public static final Property enabled = BCspHeaderProvider.newProperty((int)0, (boolean)true, (BFacets)BFacets.make((String)"security", (BIDataValue)BBoolean.TRUE));
    public static final Property status = BCspHeaderProvider.newProperty((int)3, (BValue)BStatus.ok, null);
    public static final Property violationText = BCspHeaderProvider.newProperty((int)3, (String)"", null);
    public static final Property childSrc = BCspHeaderProvider.newProperty((int)0, (String)"", (BFacets)BFacets.make((String)"security", (BIDataValue)BBoolean.TRUE));
    public static final Property connectSrc = BCspHeaderProvider.newProperty((int)0, (String)"'self' workbench ws://%hostname%:%port% wss://%hostname%:%port%", (BFacets)BFacets.make((String)"security", (BIDataValue)BBoolean.TRUE));
    public static final Property defaultSrc = BCspHeaderProvider.newProperty((int)0, (String)"'self' workbench", (BFacets)BFacets.make((String)"security", (BIDataValue)BBoolean.TRUE));
    public static final Property frameSrc = BCspHeaderProvider.newProperty((int)0, (String)"", (BFacets)BFacets.make((String)"security", (BIDataValue)BBoolean.TRUE));
    public static final Property fontSrc = BCspHeaderProvider.newProperty((int)0, (String)"", (BFacets)BFacets.make((String)"security", (BIDataValue)BBoolean.TRUE));
    public static final Property imgSrc = BCspHeaderProvider.newProperty((int)0, (String)"'self' workbench data: module:", (BFacets)BFacets.make((String)"security", (BIDataValue)BBoolean.TRUE));
    public static final Property manifestSrc = BCspHeaderProvider.newProperty((int)0, (String)"", (BFacets)BFacets.make((String)"security", (BIDataValue)BBoolean.TRUE));
    public static final Property mediaSrc = BCspHeaderProvider.newProperty((int)0, (String)"", (BFacets)BFacets.make((String)"security", (BIDataValue)BBoolean.TRUE));
    public static final Property objectSrc = BCspHeaderProvider.newProperty((int)0, (String)"", (BFacets)BFacets.make((String)"security", (BIDataValue)BBoolean.TRUE));
    public static final Property reportUri = BCspHeaderProvider.newProperty((int)0, (String)"/csp-reports", (BFacets)BFacets.make((String)"security", (BIDataValue)BBoolean.TRUE));
    public static final Property scriptSrc = BCspHeaderProvider.newProperty((int)0, (String)"'self' workbench 'unsafe-inline' 'unsafe-eval'", (BFacets)BFacets.make((String)"security", (BIDataValue)BBoolean.TRUE));
    public static final Property styleSrc = BCspHeaderProvider.newProperty((int)0, (String)"'self' workbench 'unsafe-inline'", (BFacets)BFacets.make((String)"security", (BIDataValue)BBoolean.TRUE));
    public static final Property additionalDirectives = BCspHeaderProvider.newProperty((int)0, (String)"", (BFacets)BFacets.make((BFacets)BFacets.make((String)"multiLine", (BIDataValue)BBoolean.TRUE), (BFacets)BFacets.make((String)"security", (BIDataValue)BBoolean.TRUE)));
    public static final Action clearFaultStatus = BCspHeaderProvider.newAction((int)0, null);
    public static final Type TYPE = Sys.loadType(BCspHeaderProvider.class);
    private static final String HEADER_NAME = "Content-Security-Policy";
    private static final Pattern NEWLINE = Pattern.compile("[\n\r]");
    private static final Pattern FORMAT_TOKEN = Pattern.compile("%([^%]+)%");

    public boolean getEnabled() {
        return this.getBoolean(enabled);
    }

    public void setEnabled(boolean v) {
        this.setBoolean(enabled, v, null);
    }

    public BStatus getStatus() {
        return (BStatus)this.get(status);
    }

    public void setStatus(BStatus v) {
        this.set(status, (BValue)v, null);
    }

    public String getViolationText() {
        return this.getString(violationText);
    }

    public void setViolationText(String v) {
        this.setString(violationText, v, null);
    }

    public String getChildSrc() {
        return this.getString(childSrc);
    }

    public void setChildSrc(String v) {
        this.setString(childSrc, v, null);
    }

    public String getConnectSrc() {
        return this.getString(connectSrc);
    }

    public void setConnectSrc(String v) {
        this.setString(connectSrc, v, null);
    }

    public String getDefaultSrc() {
        return this.getString(defaultSrc);
    }

    public void setDefaultSrc(String v) {
        this.setString(defaultSrc, v, null);
    }

    public String getFrameSrc() {
        return this.getString(frameSrc);
    }

    public void setFrameSrc(String v) {
        this.setString(frameSrc, v, null);
    }

    public String getFontSrc() {
        return this.getString(fontSrc);
    }

    public void setFontSrc(String v) {
        this.setString(fontSrc, v, null);
    }

    public String getImgSrc() {
        return this.getString(imgSrc);
    }

    public void setImgSrc(String v) {
        this.setString(imgSrc, v, null);
    }

    public String getManifestSrc() {
        return this.getString(manifestSrc);
    }

    public void setManifestSrc(String v) {
        this.setString(manifestSrc, v, null);
    }

    public String getMediaSrc() {
        return this.getString(mediaSrc);
    }

    public void setMediaSrc(String v) {
        this.setString(mediaSrc, v, null);
    }

    public String getObjectSrc() {
        return this.getString(objectSrc);
    }

    public void setObjectSrc(String v) {
        this.setString(objectSrc, v, null);
    }

    public String getReportUri() {
        return this.getString(reportUri);
    }

    public void setReportUri(String v) {
        this.setString(reportUri, v, null);
    }

    public String getScriptSrc() {
        return this.getString(scriptSrc);
    }

    public void setScriptSrc(String v) {
        this.setString(scriptSrc, v, null);
    }

    public String getStyleSrc() {
        return this.getString(styleSrc);
    }

    public void setStyleSrc(String v) {
        this.setString(styleSrc, v, null);
    }

    public String getAdditionalDirectives() {
        return this.getString(additionalDirectives);
    }

    public void setAdditionalDirectives(String v) {
        this.setString(additionalDirectives, v, null);
    }

    public void clearFaultStatus() {
        this.invoke(clearFaultStatus, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public String generateHeader(Context cx) {
        ArrayList<String> entries = new ArrayList<String>();
        for (Property prop : BCspHeaderProvider.getDirectiveProperties()) {
            String name = prop.getName();
            String value = this.get(prop).toString();
            if (value.isEmpty()) continue;
            String directive = BCspHeaderProvider.getDirective(name);
            entries.add(directive + ' ' + BCspHeaderProvider.template(value, cx));
        }
        String additionalDirectives = this.getAdditionalDirectives();
        if (!additionalDirectives.isEmpty()) {
            entries.add(BCspHeaderProvider.template(additionalDirectives, cx));
        }
        return String.join((CharSequence)"; ", entries);
    }

    private static String template(String value, Context cx) {
        StringBuffer sb = new StringBuffer();
        Matcher m = FORMAT_TOKEN.matcher(value);
        while (m.find()) {
            BObject facet = cx.getFacet(m.group(1));
            m.appendReplacement(sb, facet == null ? m.group() : facet.toString());
        }
        m.appendTail(sb);
        return BCspHeaderProvider.stripNewLines(sb.toString());
    }

    private static String stripNewLines(String s) {
        return NEWLINE.matcher(s).replaceAll("");
    }

    private static String getDirective(String slotName) {
        switch (slotName) {
            case "childSrc": {
                return "child-src";
            }
            case "connectSrc": {
                return "connect-src";
            }
            case "defaultSrc": {
                return "default-src";
            }
            case "fontSrc": {
                return "font-src";
            }
            case "frameSrc": {
                return "frame-src";
            }
            case "imgSrc": {
                return "img-src";
            }
            case "manifestSrc": {
                return "manifest-src";
            }
            case "mediaSrc": {
                return "media-src";
            }
            case "objectSrc": {
                return "object-src";
            }
            case "reportUri": {
                return "report-uri";
            }
            case "scriptSrc": {
                return "script-src";
            }
            case "styleSrc": {
                return "style-src";
            }
        }
        return "";
    }

    public static Context createContext(HttpServletRequest req) {
        return BFacets.make((String[])new String[]{"scheme", "hostname", "port"}, (BIDataValue[])new BIDataValue[]{BString.make((String)req.getScheme()), BString.make((String)req.getServerName()), BInteger.make((int)req.getServerPort())});
    }

    public static Property[] getDirectiveProperties() {
        return new Property[]{childSrc, connectSrc, defaultSrc, fontSrc, frameSrc, imgSrc, manifestSrc, mediaSrc, objectSrc, reportUri, scriptSrc, styleSrc};
    }

    @Override
    public void applyHeaders(HttpServletRequest req, HttpServletResponse resp) {
        if (!this.getEnabled()) {
            return;
        }
        Context cx = BCspHeaderProvider.createContext(req);
        String header = this.generateHeader(cx);
        if (!header.isEmpty()) {
            resp.setHeader(HEADER_NAME, header);
        }
    }

    public void changed(Property prop, Context cx) {
        if (prop.equals(violationText) && !this.getViolationText().isEmpty()) {
            this.setStatus(BStatus.fault);
        }
    }

    public void doClearFaultStatus() {
        this.setStatus(BStatus.ok);
        this.setViolationText("");
    }
}

