/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.web.servlets;

import com.tridium.file.types.gzip.BIGzipFile;
import com.tridium.session.NiagaraSession;
import com.tridium.util.StreamUtil;
import com.tridium.web.WebSnoopHtmlWriter;
import com.tridium.web.WebUtil;
import com.tridium.web.session.NiagaraWebSession;
import com.tridium.web.session.WebSessionUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.baja.file.BFileSpace;
import javax.baja.file.BIFile;
import javax.baja.file.BajaFileUtil;
import javax.baja.file.types.text.BITextFile;
import javax.baja.file.zip.BZipSpace;
import javax.baja.naming.BLocalHost;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdTarget;
import javax.baja.nre.util.FileUtil;
import javax.baja.space.BISpace;
import javax.baja.sys.BModule;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.web.BIDynamicFile;
import javax.baja.web.BWebService;
import javax.baja.web.WebDev;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.http.Part;
import org.eclipse.jetty.io.EofException;

public final class FileServlet
extends HttpServlet {
    private final BajaFileUtil.BajaFileWriter fileWriter = BajaFileUtil.getDefaultFileWriter();
    private static boolean cacheAllFiles;
    private static Pattern cachePattern;
    private static final Pattern themeImagePattern;
    private static final Pattern forbiddenFilePattern;
    private static final boolean addExpires;
    private static final boolean useSnoop;
    public static final WebDev webDev;
    public static final String cacheControlHeaderName = "Cache-Control";
    public static final String cacheControlHeaderValue = "private, must-revalidate, max-age=2592000";
    public static final String cacheControlHeaderRevalidate = "private, must-revalidate, max-age=0";
    public static final String noCacheControlHeaderValue = "no-cache, no-store";
    public static final String acceptEncodingHeaderName = "Accept-Encoding";
    public static final String contentEncodingHeaderName = "Content-Encoding";
    private static final Logger LOGGER;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        try {
            Optional service = Sys.findService((Type)BWebService.TYPE);
            if (service.isPresent() && ((BWebService)((Object)service.get())).getCacheConfig().getEnabled()) {
                String fileExtensions;
                switch (fileExtensions = ((BWebService)((Object)service.get())).getCacheConfig().getCachedFileExtensions()) {
                    case "*": {
                        cacheAllFiles = true;
                        break;
                    }
                    case "": {
                        cachePattern = null;
                        cacheAllFiles = false;
                        break;
                    }
                    default: {
                        fileExtensions = fileExtensions.replace(",", "|").toLowerCase(Locale.ENGLISH);
                        cachePattern = Pattern.compile("\\.(" + fileExtensions + ")$", 2);
                        cacheAllFiles = false;
                        break;
                    }
                }
            } else {
                cachePattern = null;
                cacheAllFiles = false;
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Cannot initialize FileServlet", e);
        }
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        OrdTarget target = this.getReadableTarget(req, resp);
        if (target == null) {
            return;
        }
        BIFile file = (BIFile)target.get();
        if (!FileServlet.applyLastModified(req, resp, file)) {
            return;
        }
        String mimeType = FileServlet.getMimeType(file);
        FileServlet.applyContentType(resp, mimeType);
        FileServlet.applyCacheControl(resp, target, file);
        FileServlet.applyContentEncoding(req, resp, file);
        FileServlet.withSessionTimeoutPaused(req.getSession(), () -> this.sendFileContentToClient(req, resp, target, file, mimeType));
    }

    protected void doHead(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        OrdTarget target = this.getReadableTarget(req, resp);
        if (target == null) {
            return;
        }
        BIFile file = (BIFile)target.get();
        if (!FileServlet.applyLastModified(req, resp, file)) {
            return;
        }
        FileServlet.applyContentType(resp, FileServlet.getMimeType(file));
        FileServlet.applyCacheControl(resp, target, file);
        FileServlet.applyContentEncoding(req, resp, file);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        Context cx = (Context)req.getAttribute("niagara.context");
        Part contentPart = req.getPart("content");
        String ord = FileServlet.readFileOrd(req);
        if ("file:^".equals(ord)) {
            resp.sendError(400);
            throw new IOException("Path length is 0");
        }
        if (FileServlet.isForbiddenFileOrd(ord)) {
            resp.sendError(403);
            return;
        }
        try (InputStream content = contentPart.getInputStream();){
            AccessController.doPrivileged(() -> {
                this.writeFile(BOrd.make((String)ord), content, resp, cx);
                return null;
            });
        }
        catch (PrivilegedActionException e) {
            WebUtil.handleServletPrivilegedException(e);
        }
    }

    protected void doPut(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        OrdTarget target = this.getWritableTarget(req, resp);
        if (target == null) {
            return;
        }
        BIFile file = (BIFile)target.get();
        try {
            AccessController.doPrivileged(() -> {
                this.overwriteFileContents(req, resp, file);
                return null;
            });
        }
        catch (PrivilegedActionException e) {
            WebUtil.handleServletPrivilegedException(e);
        }
    }

    private OrdTarget getReadableTarget(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        OrdTarget target = this.getTarget(req, resp);
        if (target == null) {
            return null;
        }
        if (!FileServlet.canRead(target)) {
            this.log("Cannot read file");
            resp.sendError(403);
            return null;
        }
        return target;
    }

    private OrdTarget getWritableTarget(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        OrdTarget target = this.getTarget(req, resp);
        if (!FileServlet.canWrite(target)) {
            this.log("Cannot write to file");
            resp.sendError(403);
            return null;
        }
        return target;
    }

    private OrdTarget getTarget(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        OrdTarget target = (OrdTarget)req.getAttribute("niagara.target");
        if (target == null) {
            this.log("Target unavailable");
            resp.sendError(404);
            return null;
        }
        return target;
    }

    private static void applyContentEncoding(HttpServletRequest req, HttpServletResponse resp, BIFile file) {
        String accept;
        if (FileServlet.isGzipFile(file) && (accept = req.getHeader(acceptEncodingHeaderName)) != null && accept.contains("gzip")) {
            resp.setHeader(contentEncodingHeaderName, "gzip");
        }
    }

    private static boolean applyLastModified(HttpServletRequest req, HttpServletResponse resp, BIFile file) {
        Long lastModified = FileServlet.getLastModifiedTimestamp(req, file);
        if (lastModified == null) {
            resp.setStatus(304);
            return false;
        }
        resp.setDateHeader("Last-Modified", lastModified.longValue());
        return true;
    }

    private static Long getLastModifiedTimestamp(HttpServletRequest req, BIFile file) {
        long ifModified;
        long lastModified = AccessController.doPrivileged(() -> file.getLastModified().getMillis());
        if ((lastModified = lastModified / 1000L * 1000L) > 0L && (ifModified = req.getDateHeader("If-Modified-Since")) > 0L && lastModified / 1000L <= ifModified / 1000L) {
            return null;
        }
        return lastModified;
    }

    private static void applyContentType(HttpServletResponse resp, String mimeType) {
        resp.setContentType(mimeType);
    }

    private static void applyCacheControl(HttpServletResponse resp, OrdTarget target, BIFile file) {
        resp.setHeader(cacheControlHeaderName, FileServlet.getCacheControlHeader(target, file));
    }

    private static String getCacheControlHeader(OrdTarget target, BIFile file) {
        if (FileServlet.isCachingDisabled(file)) {
            return noCacheControlHeaderValue;
        }
        if (FileServlet.isLongTermCacheable(file) || FileServlet.isLongTermCacheable(target.getOrd())) {
            return cacheControlHeaderValue;
        }
        return cacheControlHeaderRevalidate;
    }

    private static boolean isCachingDisabled(BIFile file) {
        return webDev.isEnabled() || !addExpires || FileServlet.isDynamicFile(file);
    }

    private static boolean isDynamicFile(BIFile file) {
        return file instanceof BIDynamicFile;
    }

    private static boolean isGzipFile(BIFile file) {
        return file instanceof BIGzipFile;
    }

    private static String getMimeType(BIFile file) {
        if (FileServlet.isGzipFile(file)) {
            return ((BIGzipFile)file).getGzippedMimeType();
        }
        if (FileServlet.isDynamicFile(file)) {
            return ((BIDynamicFile)file).getDynamicMimeType();
        }
        return Objects.toString(file.getMimeType(), "text/plain; charset=UTF-8");
    }

    private static boolean isLongTermCacheable(BIFile file) {
        BFileSpace space = file.getFileSpace();
        return space == null || space instanceof BZipSpace || space instanceof BModule;
    }

    private static boolean isLongTermCacheable(BOrd ord) {
        return cacheAllFiles || cachePattern != null && cachePattern.matcher(ord.toString()).find();
    }

    private static boolean isSnoopingEnabled(HttpServletRequest req, String mimeType) {
        if (!useSnoop || !FileServlet.isSnoopableMimeType(mimeType)) {
            return false;
        }
        String snoop = (String)req.getAttribute("snoop");
        if (snoop == null) {
            snoop = req.getParameter("snoop");
        }
        return snoop == null || "true".equals(snoop);
    }

    private static boolean isSnoopableMimeType(String mimeType) {
        return "text/html".equals(mimeType) || "text/css".equals(mimeType);
    }

    private void sendFileContentToClient(HttpServletRequest req, HttpServletResponse resp, OrdTarget target, BIFile file, String mimeType) {
        if (FileServlet.isDynamicFile(file)) {
            this.sendDynamicFile(resp, target, (BIDynamicFile)file);
        } else if (FileServlet.isSnoopingEnabled(req, mimeType)) {
            this.sendSnoopedFile(req, resp, target, file);
        } else {
            this.sendStaticFile(req, resp, target, file);
        }
    }

    private void sendDynamicFile(HttpServletResponse resp, OrdTarget target, BIDynamicFile file) {
        try {
            file.write(null, target, resp.getWriter());
            resp.setStatus(200);
        }
        catch (Exception e) {
            this.handleResponseError("Dynamic Web File Writing", e, resp);
        }
    }

    private void sendSnoopedFile(HttpServletRequest req, HttpServletResponse resp, OrdTarget target, BIFile file) {
        resp.setCharacterEncoding("UTF-8");
        AccessController.doPrivileged(() -> {
            try (InputStream in = file.getInputStream();
                 PrintWriter out = resp.getWriter();){
                WebSnoopHtmlWriter.pipe(target, req, in, out);
                resp.setStatus(200);
            }
            catch (Exception e) {
                this.handleResponseError("Snoop Web File Writing", e, resp);
            }
            return null;
        });
    }

    private void sendStaticFile(HttpServletRequest req, HttpServletResponse resp, OrdTarget target, BIFile file) {
        BIFile f = FileServlet.handleThemeIcon(file, target, req);
        resp.setCharacterEncoding("UTF-8");
        AccessController.doPrivileged(() -> {
            try (InputStream in = f.getInputStream();
                 ServletOutputStream out = resp.getOutputStream();){
                FileUtil.pipe((InputStream)in, (OutputStream)out);
                resp.setStatus(200);
            }
            catch (Exception e) {
                this.handleResponseError("Web File Writing", e, resp);
            }
            return null;
        });
    }

    private static String readFileOrd(HttpServletRequest req) throws IOException, ServletException {
        return FileServlet.readFully(req.getPart("ord"));
    }

    private static String readFully(Part part) throws IOException {
        try (InputStream in = part.getInputStream();){
            String string = StreamUtil.readFully((InputStream)in);
            return string;
        }
    }

    private static boolean isForbiddenFileOrd(String fileOrd) {
        return forbiddenFilePattern.matcher(fileOrd).find();
    }

    private void writeFile(BOrd fileOrd, InputStream content, HttpServletResponse resp, Context cx) throws IOException {
        if (!this.fileWriter.isWritable(fileOrd, cx)) {
            resp.sendError(403);
            throw new IOException();
        }
        this.fileWriter.replaceFile(fileOrd, content, cx);
    }

    private void overwriteFileContents(HttpServletRequest req, HttpServletResponse resp, BIFile file) {
        try (ServletInputStream in = req.getInputStream();
             OutputStream out = file.getOutputStream();){
            FileUtil.pipe((InputStream)in, (OutputStream)out);
        }
        catch (Exception e) {
            this.handleResponseError("Web File Writing", e, resp);
        }
    }

    private static void withSessionTimeoutPaused(HttpSession session, Runnable r) {
        Object pauseToken = null;
        try {
            if (session instanceof NiagaraSession) {
                pauseToken = ((NiagaraSession)session).pauseSessionTimeout();
            }
            r.run();
        }
        finally {
            if (session instanceof NiagaraSession) {
                ((NiagaraSession)session).resumeSessionTimeout(pauseToken);
            }
        }
    }

    private void handleResponseError(String msg, Exception e, HttpServletResponse resp) {
        if (e instanceof EofException) {
            LOGGER.log(Level.FINE, msg, e);
        } else {
            this.log(msg, e);
        }
        try {
            if (!resp.isCommitted()) {
                resp.sendError(400);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static boolean canRead(OrdTarget target) {
        BObject obj = target.get();
        if (!(obj instanceof BIFile)) {
            return false;
        }
        BIFile file = (BIFile)obj;
        String fileName = file.getFileName().toLowerCase(Locale.ENGLISH);
        return target.canRead() && !file.isDirectory() && !fileName.endsWith(".bog") && !fileName.endsWith(".bog.gz");
    }

    public static boolean canWrite(OrdTarget target) {
        BObject obj = target.get();
        if (!(obj instanceof BIFile)) {
            return false;
        }
        BIFile file = (BIFile)obj;
        String fileName = file.getFileName().toLowerCase(Locale.ENGLISH);
        return target.canWrite() && !file.isDirectory() && !file.isReadonly() && file instanceof BITextFile && !(file instanceof BIDynamicFile) && !fileName.endsWith(".bog") && !fileName.endsWith(".bog.gz");
    }

    private static BIFile handleThemeIcon(BIFile file, OrdTarget target, HttpServletRequest req) {
        Object themeName;
        NiagaraWebSession session;
        String ordStr;
        BFileSpace space = file.getFileSpace();
        if (BModule.isModuleFileSpace((BISpace)space) && themeImagePattern.matcher(ordStr = target.getOrd().toString()).find() && (session = WebSessionUtil.getSession(req, false)) != null && (themeName = session.getAttribute("themeName")) != null) {
            try {
                BOrd newOrd = BOrd.make((String)("module://theme" + themeName.toString() + "/imageOverrides/" + ordStr.substring(9)));
                file = (BIFile)newOrd.get((BObject)BLocalHost.INSTANCE, (Context)target);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return file;
    }

    static {
        themeImagePattern = Pattern.compile("\\.(png|svg|gif|jpg|jpeg)$", 2);
        forbiddenFilePattern = Pattern.compile("[|]|([.][.])");
        addExpires = AccessController.doPrivileged(() -> "true".equals(System.getProperty("niagara.web.addExpires", "true")));
        useSnoop = AccessController.doPrivileged(() -> "true".equals(System.getProperty("niagara.web.snoop", "true")));
        webDev = WebDev.get("fileServlet");
        LOGGER = Logger.getLogger("web");
    }
}

