/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.web.servlets;

import com.tridium.json.JSONObject;
import com.tridium.json.JSONTokener;
import com.tridium.web.RestUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.security.AccessController;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;
import javax.baja.web.BWebService;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class CspReportServlet
extends HttpServlet {
    private static final long serialVersionUID = -5629164106063566237L;
    private static final Logger LOG = Logger.getLogger("web.reporting.csp");
    private static final String MAX_CSP_REPORT_SIZE_KEY = "niagara.web.security.csp.maxReportSize";
    private static final int MAX_CSP_REPORT_SIZE = AccessController.doPrivileged(() -> Integer.getInteger(MAX_CSP_REPORT_SIZE_KEY, 8096));
    private static final AtomicBoolean logged = new AtomicBoolean(false);

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String violationText;
        if (req.getContentLength() > MAX_CSP_REPORT_SIZE) {
            return;
        }
        RestUtil util = new RestUtil(req, resp);
        if (!util.acceptJson()) {
            resp.sendError(406);
            return;
        }
        try (BufferedReader reader = req.getReader();){
            JSONObject json = new JSONObject(new JSONTokener((Reader)reader));
            violationText = json.toString();
        }
        catch (Throwable e) {
            LOG.log(Level.FINE, "Could not parse CSP violation text", e);
            resp.sendError(403);
            return;
        }
        if (violationText.isEmpty()) {
            return;
        }
        try {
            CspReportServlet.setViolationText(violationText);
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, "Could not set CSP violation text", e);
        }
        if (LOG.isLoggable(Level.SEVERE)) {
            if (logged.getAndSet(true)) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("CSP violation: " + violationText);
                }
            } else {
                LOG.severe("CSP violation: " + violationText);
                LOG.severe(Lexicon.make((String)"web").get("cspServlet.switchingToFineLog", "Additional CSP violations will be logged to the 'web.reporting.csp' log with severity FINE."));
            }
        }
    }

    private static void setViolationText(String violationText) {
        BWebService service = (BWebService)Sys.getService((Type)BWebService.TYPE);
        service.getHttpHeaderProviders().getContentSecurityPolicy().setViolationText(violationText);
    }
}

