/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.web.servlets;

import com.tridium.nre.util.IPAddressUtil;
import com.tridium.util.SpyUtil;
import com.tridium.web.WebSnoopHtmlWriter;
import com.tridium.web.WebUtil;
import java.io.ByteArrayInputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.InetAddress;
import java.nio.charset.StandardCharsets;
import javax.baja.file.FilePath;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.OrdTarget;
import javax.baja.spy.BSpy;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.web.BServletView;
import javax.baja.web.CsrfUtil;
import javax.baja.web.WebOp;
import javax.servlet.http.HttpServletRequest;

public class BSpyServlet
extends BServletView {
    public static final BSpyServlet INSTANCE = new BSpyServlet();
    public static final Type TYPE = Sys.loadType(BSpyServlet.class);

    @Override
    public Type getType() {
        return TYPE;
    }

    protected BSpyServlet() {
    }

    @Override
    public void doPost(WebOp op) throws Exception {
        HttpServletRequest req = op.getRequest();
        if (!CsrfUtil.verifyCsrfToken(req)) {
            op.getResponse().sendError(403);
            return;
        }
        BOrd spyOrd = SpyUtil.restoreRadioactivity((BOrd)op.getOrd());
        String csrfToken = WebUtil.getCsrfTokenFromRequest(req);
        this.writeSpyPage(spyOrd, csrfToken, op);
    }

    @Override
    public void doGet(WebOp op) throws Exception {
        BOrd spyOrd = SpyUtil.stripAuthorization((BOrd)SpyUtil.restoreRadioactivity((BOrd)op.getOrd()));
        this.writeSpyPage(spyOrd, null, op);
    }

    private void writeSpyPage(BOrd spyOrd, String csrfToken, WebOp c) throws Exception {
        FilePath path = null;
        OrdQuery[] q = spyOrd.parse();
        for (int i = q.length - 1; i >= 0; --i) {
            if (!(q[i] instanceof FilePath)) continue;
            path = (FilePath)q[i];
            break;
        }
        c.setContentType("text/html");
        if (csrfToken != null) {
            spyOrd = SpyUtil.injectCsrfToken((BOrd)spyOrd, (String)csrfToken);
        }
        OrdTarget realSpyTarget = spyOrd.resolve();
        try (StringWriter sw = new StringWriter();
             SpyWriter out = new SpyWriter((Writer)sw, path, (Context)c);){
            this.writeSpyContents(out, path, realSpyTarget, c);
            WebSnoopHtmlWriter.pipe(realSpyTarget, c.getRequest(), new ByteArrayInputStream(sw.toString().getBytes(StandardCharsets.UTF_8)), c.getResponse().getWriter());
        }
    }

    private void writeSpyContents(SpyWriter out, FilePath path, OrdTarget realSpyTarget, WebOp c) throws Exception {
        out.w((Object)"<!DOCTYPE html>");
        out.w((Object)"<html><head>");
        out.w((Object)"<script type='text/javascript' src='module://web/rc/util/activityMonitor.js'></script>");
        out.w((Object)"<script>");
        out.w((Object)"function startMonitor(){");
        out.w((Object)"window.activityMonitor.start();");
        out.w((Object)"}");
        out.w((Object)"</script>");
        out.w((Object)"<link rel='stylesheet' href='module://web/rc/spy/spy.css' type='text/css'/>");
        out.w((Object)"</head><body onload='startMonitor()'><div class='spy-container'>");
        out.w((Object)"<div class='spy-nav-container'>");
        out.w((Object)"<table width='100%' class='spy-nav'><tr><td class='spy-nav-index'>");
        out.a("/", (Object)"Index");
        String x = "";
        for (int i = 0; i < path.depth(); ++i) {
            x = x + "/" + path.nameAt(i);
            out.w((Object)" | ").a(x, (Object)path.nameAt(i));
        }
        out.w((Object)"</td><td class='spy-nav-station'>");
        try {
            String localHostString;
            String stationName = Sys.getStation().getStationName();
            try {
                InetAddress remoteAddress = IPAddressUtil.numericStringToInetAddress((String)c.getRequest().getRemoteAddr());
                InetAddress localhost = Sys.getLocalHost((InetAddress)remoteAddress);
                localHostString = localhost.toString();
            }
            catch (Exception ignored) {
                localHostString = Sys.getLocalHost(null).toString();
            }
            out.w((Object)(stationName + " [" + localHostString + "]"));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        out.w((Object)"</tr></table></div><hr>");
        ((BSpy)realSpyTarget.get()).get().write(out);
        out.w((Object)"</div></body></html>");
    }
}

