/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.web.rpc;

import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.rpc.NiagaraRpc;
import javax.baja.rpc.Transport;
import javax.baja.rpc.TransportType;
import javax.baja.security.BPassword;
import javax.baja.sys.BComplex;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.LocalizableException;
import javax.baja.sys.Property;
import javax.baja.sys.ServiceNotFoundException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.web.BWebService;

@NiagaraType
public class BPasswordRpc
extends BObject {
    public static final Type TYPE = Sys.loadType(BPasswordRpc.class);

    public Type getType() {
        return TYPE;
    }

    @NiagaraRpc(permissions="unrestricted", transports={@Transport(type=TransportType.box)})
    public static void setPassword(String pwd, String slotName, String baseOrd, Context cx) throws Exception {
        BComplex target;
        Property pwdProp;
        BPasswordRpc.securityCheck(cx);
        if (baseOrd != null && !baseOrd.isEmpty() && (pwdProp = (target = BOrd.make((String)baseOrd).resolve(null, cx).get().asComplex()).getProperty(slotName)) != null) {
            target.set(pwdProp, (BValue)BPassword.make((String)pwd, (Context)cx), cx);
        }
    }

    public static void securityCheck(Context cx) throws LocalizableException {
        if (!cx.getFacets().getb("isSecure", false) && !BPasswordRpc.canChangeInsecurely()) {
            throw new LocalizableException("web", "web.server.httpsRequiredForPassword");
        }
    }

    private static boolean canChangeInsecurely() {
        BWebService webService;
        try {
            webService = (BWebService)Sys.getService((Type)BWebService.TYPE);
        }
        catch (ServiceNotFoundException e) {
            return true;
        }
        return !webService.getRequireHttpsForPasswords();
    }
}

