/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.web.http;

import com.tridium.web.stub.StubHttpServletRequest;
import com.tridium.web.stub.StubHttpServletResponse;
import java.util.ArrayList;
import java.util.List;
import javax.baja.agent.BIAgent;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.dashboard.BISecurityDashboardItemProvider;
import javax.baja.security.dashboard.BSecurityItemStatus;
import javax.baja.security.dashboard.SecurityDashboardItem;
import javax.baja.security.dashboard.SecurityDashboardItemBuilder;
import javax.baja.sys.BIObject;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.web.BWebService;
import javax.baja.web.BXFrameOptionsEnum;
import javax.baja.web.http.BCspHeaderProvider;
import javax.baja.web.http.BGenericHttpHeaderProvider;
import javax.baja.web.http.BHttpHeaderProviders;
import javax.baja.web.http.BXContentTypeOptionsHeaderProvider;
import javax.baja.web.http.BXFrameOptionsHeaderProvider;
import javax.baja.web.http.BXXssProtectionHeaderProvider;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@NiagaraType(agent={@AgentOn(types={"web:WebService"})})
public class BHttpHeaderSecurityDashboardItemProvider
extends BObject
implements BISecurityDashboardItemProvider,
BIAgent {
    public static final Type TYPE = Sys.loadType(BHttpHeaderSecurityDashboardItemProvider.class);
    private BWebService service;
    private SecurityDashboardItemBuilder builder;
    private static final String ALL_ENABLED_HEADER_SUMMARY = "securityDashboard.httpHeaders.enabled.summary";
    private static final String SOME_DISABLED_HEADER_SUMMARY = "securityDashboard.httpHeaders.someDisabled.summary";
    private static final String ALL_DISABLED_HEADER_SUMMARY = "securityDashboard.httpHeaders.allDisabled.summary";
    private static final String HEADER_DESCRIPTION = "securityDashboard.httpHeaders.description";
    private static final String CSP_HEADER_SUMMARY = "securityDashboard.httpHeaders.csp.summary";
    private static final String CSP_HEADER_DESCRIPTION = "securityDashboard.httpHeaders.csp.description";
    private static final String CSP_HEADER_DIRECTIVE_SUMMARY = "securityDashboard.httpHeaders.cspDirective.summary";
    private static final String CSP_HEADER_DIRECTIVE_DESCRIPTION = "securityDashboard.httpHeaders.cspDirective.description";
    private static final String X_CONTENT_TYPE_OPTIONS_SUMMARY = "securityDashboard.httpHeaders.xContentTypeOptions.summary";
    private static final String X_CONTENT_TYPE_OPTIONS_DESCRIPTION = "securityDashboard.httpHeaders.xContentTypeOptions.description";
    private static final String X_FRAME_OPTIONS_SUMMARY = "securityDashboard.xFrameOptions.summary";
    private static final String X_FRAME_OPTIONS_DESCRIPTION = "securityDashboard.xFrameOptions.description";
    private static final String X_XSS_PROTECTION_SUMMARY = "securityDashboard.httpHeaders.xXssProtection.summary";
    private static final String X_XSS_PROTECTION_DESCRIPTION = "securityDashboard.httpHeaders.xXssProtection.description";
    private static final String GENERIC_SUMMARY = "securityDashboard.httpHeaders.generic.summary";
    private static final String GENERIC_DESCRIPTION = "securityDashboard.httpHeaders.generic.description";

    public Type getType() {
        return TYPE;
    }

    public void setSecurityDashboardItemsSource(BIObject object) {
        this.service = (BWebService)object;
        this.builder = new SecurityDashboardItemBuilder((BIObject)this);
    }

    public int getSecurityDashboardItemsVersion() {
        return 1;
    }

    public List<SecurityDashboardItem> getSecurityDashboardItems(Context cx) {
        ArrayList<SecurityDashboardItem> items = new ArrayList<SecurityDashboardItem>();
        BHttpHeaderProviders providers = this.service.getHttpHeaderProviders();
        if (!providers.getEnabled()) {
            items.add(this.builder.makeWarning(ALL_DISABLED_HEADER_SUMMARY, HEADER_DESCRIPTION));
        } else {
            items.addAll(this.getHeadersEnabledItems(providers));
            items.addAll(this.getHeaderContentsItems(providers));
        }
        return items;
    }

    private List<SecurityDashboardItem> getHeadersEnabledItems(BHttpHeaderProviders headers) {
        ArrayList<SecurityDashboardItem> items = new ArrayList<SecurityDashboardItem>();
        ArrayList<String> disabledHeaders = new ArrayList<String>();
        if (!headers.getContentSecurityPolicy().getEnabled()) {
            disabledHeaders.add("Content-Security-Policy");
        }
        if (!headers.getXContentTypeOptions().getEnabled()) {
            disabledHeaders.add("X-Content-Type-Options");
        }
        if (!headers.getXFrameOptions().getEnabled()) {
            disabledHeaders.add("X-Frame-Options");
        }
        if (!headers.getXXssProtection().getEnabled()) {
            disabledHeaders.add("X-XSS-Protection");
        }
        if (disabledHeaders.isEmpty()) {
            items.add(this.builder.makeOk(ALL_ENABLED_HEADER_SUMMARY, HEADER_DESCRIPTION));
        } else {
            items.add(this.builder.makeWarning().withSummary(SOME_DISABLED_HEADER_SUMMARY, new Object[]{String.join((CharSequence)", ", disabledHeaders)}).withDescription(HEADER_DESCRIPTION, new Object[0]));
        }
        return items;
    }

    private List<SecurityDashboardItem> getHeaderContentsItems(BHttpHeaderProviders headers) {
        ArrayList<SecurityDashboardItem> items = new ArrayList<SecurityDashboardItem>();
        StubHttpServletRequest req = new StubHttpServletRequest();
        StubHttpServletResponse resp = new StubHttpServletResponse();
        this.addCspItem(items, req, resp, headers.getContentSecurityPolicy());
        this.addXContentTypeOptionsItem(items, req, resp, headers.getXContentTypeOptions());
        this.addXFrameOptionsItem(items, headers.getXFrameOptions());
        this.addXXssProtectionItem(items, req, resp, headers.getXXssProtection());
        this.addGenericItems(items, headers);
        return items;
    }

    private void addCspItem(List<SecurityDashboardItem> items, HttpServletRequest req, HttpServletResponse resp, BCspHeaderProvider provider) {
        if (provider.getEnabled()) {
            provider.applyHeaders(req, resp);
            items.add(this.builder.makeInfo().withSummary(CSP_HEADER_SUMMARY, new Object[]{resp.getHeader("Content-Security-Policy")}).withDescription(CSP_HEADER_DESCRIPTION, new Object[0]));
            for (Property prop : BCspHeaderProvider.getDirectiveProperties()) {
                String directive = provider.get(prop).toString();
                if (!BHttpHeaderSecurityDashboardItemProvider.isInsecureDirective(prop, directive)) continue;
                items.add(this.builder.makeWarning().withSummary(CSP_HEADER_DIRECTIVE_SUMMARY, new Object[]{directive}).withDescription(CSP_HEADER_DIRECTIVE_DESCRIPTION, new Object[0]));
            }
        }
    }

    private void addXContentTypeOptionsItem(List<SecurityDashboardItem> items, HttpServletRequest req, HttpServletResponse resp, BXContentTypeOptionsHeaderProvider provider) {
        if (provider.getEnabled()) {
            provider.applyHeaders(req, resp);
            String header = resp.getHeader("X-Content-Type-Options");
            items.add(this.builder.make(BHttpHeaderSecurityDashboardItemProvider.okIfSecure("nosniff".equalsIgnoreCase(header))).withSummary(X_CONTENT_TYPE_OPTIONS_SUMMARY, new Object[]{header}).withDescription(X_CONTENT_TYPE_OPTIONS_DESCRIPTION, new Object[0]));
        }
    }

    private void addXFrameOptionsItem(List<SecurityDashboardItem> items, BXFrameOptionsHeaderProvider provider) {
        if (provider.getEnabled()) {
            BXFrameOptionsEnum options = provider.getXFrameOptions();
            items.add(this.builder.make(BHttpHeaderSecurityDashboardItemProvider.okIfSecure(!options.equals((Object)BXFrameOptionsEnum.any))).withSummary(X_FRAME_OPTIONS_SUMMARY, new Object[]{options}).withDescription(X_FRAME_OPTIONS_DESCRIPTION, new Object[0]));
        }
    }

    private void addXXssProtectionItem(List<SecurityDashboardItem> items, HttpServletRequest req, HttpServletResponse resp, BXXssProtectionHeaderProvider provider) {
        if (provider.getEnabled()) {
            provider.applyHeaders(req, resp);
            String header = resp.getHeader("X-XSS-Protection");
            items.add(this.builder.make(BHttpHeaderSecurityDashboardItemProvider.okIfSecure("1; mode=block".equalsIgnoreCase(header))).withSummary(X_XSS_PROTECTION_SUMMARY, new Object[]{header}).withDescription(X_XSS_PROTECTION_DESCRIPTION, new Object[0]));
        }
    }

    private void addGenericItems(List<SecurityDashboardItem> items, BHttpHeaderProviders headers) {
        for (Property prop : headers.getDynamicPropertiesArray()) {
            BValue kid = headers.get(prop);
            if (!(kid instanceof BGenericHttpHeaderProvider)) continue;
            BGenericHttpHeaderProvider genericProvider = (BGenericHttpHeaderProvider)kid;
            items.add(this.builder.makeInfo().withSummary(GENERIC_SUMMARY, new Object[]{genericProvider.getHeaderName(), genericProvider.getHeaderValue()}).withDescription(GENERIC_DESCRIPTION, new Object[0]));
        }
    }

    private static BSecurityItemStatus okIfSecure(boolean secure) {
        return secure ? BSecurityItemStatus.securityStatusOK : BSecurityItemStatus.securityStatusWarning;
    }

    private static boolean isInsecureDirective(Property prop, String value) {
        return "*".equals(value);
    }
}

