/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.web.filters.cache;

import com.tridium.web.filters.cache.FileCache;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import javax.baja.file.BDirectory;
import javax.baja.file.BIFile;
import javax.baja.file.FilePath;
import javax.baja.spy.SpyWriter;
import javax.servlet.ServletException;
import org.owasp.encoder.Encode;

public final class FileSystemCache
implements FileCache {
    private BIFile cacheDir;
    public static final String CACHE_TYPE = "fileSystem";
    public static final String ROOT_DIRECTORY_NAME = "webFileCache";

    public FileSystemCache(String cacheName, BIFile dir) throws ServletException {
        try {
            AccessController.doPrivileged(() -> {
                BDirectory rootDir = dir.getFileSpace().makeDir(dir.getFilePath().merge(ROOT_DIRECTORY_NAME));
                Optional<BIFile> cacheDirOpt = Stream.of(rootDir.listFiles()).filter(file -> file.isDirectory() && file.getFileName().equals(cacheName)).findAny();
                if (cacheDirOpt.isPresent()) {
                    cacheDirOpt.get().delete();
                }
                this.cacheDir = rootDir.getFileSpace().makeDir(rootDir.getFilePath().merge(cacheName));
                return null;
            });
        }
        catch (PrivilegedActionException err) {
            Exception inner = err.getException();
            if (inner instanceof RuntimeException) {
                throw (RuntimeException)inner;
            }
            throw new ServletException((Throwable)inner);
        }
    }

    @Override
    public boolean has(String path) {
        return this.cacheDir.getFileSpace().findFile(this.makeFilePath(path)) != null;
    }

    @Override
    public OutputStream create(String path) throws IOException {
        try {
            return AccessController.doPrivileged(() -> {
                FilePath cachedFilePath = this.makeFilePath(path);
                this.cacheDir.getFileSpace().makeDir(cachedFilePath.getParent());
                BIFile cacheFile = this.cacheDir.getFileSpace().makeFile(cachedFilePath);
                return cacheFile.getOutputStream();
            });
        }
        catch (PrivilegedActionException err) {
            FileSystemCache.throwInnerPrivilegedActionException(err);
            return null;
        }
    }

    @Override
    public void delete(String path) throws IOException {
        try {
            AccessController.doPrivileged(() -> {
                FilePath cachedFilePath = this.makeFilePath(path);
                this.cacheDir.getFileSpace().delete(cachedFilePath);
                return null;
            });
        }
        catch (PrivilegedActionException err) {
            FileSystemCache.throwInnerPrivilegedActionException(err);
        }
    }

    @Override
    public InputStream getInputStream(String path) throws IOException {
        try {
            return AccessController.doPrivileged(() -> {
                FilePath filePath = this.makeFilePath(path);
                BIFile file = this.cacheDir.getFileSpace().findFile(filePath);
                return file.getInputStream();
            });
        }
        catch (PrivilegedActionException err) {
            FileSystemCache.throwInnerPrivilegedActionException(err);
            return null;
        }
    }

    @Override
    public void clear() throws IOException {
        try {
            AccessController.doPrivileged(() -> {
                this.cacheDir.delete();
                return null;
            });
        }
        catch (PrivilegedActionException err) {
            FileSystemCache.throwInnerPrivilegedActionException(err);
        }
    }

    public String toString() {
        return CACHE_TYPE;
    }

    @Override
    public void spy(SpyWriter out) {
        out.startProps("File System Cache").prop((Object)"Cache Directory", (Object)Encode.forHtml((String)Objects.toString(this.cacheDir, ""))).endProps();
    }

    public FilePath makeFilePath(String path) {
        if (path.startsWith("/")) {
            path = path.substring(1, path.length());
        }
        return this.cacheDir.getFilePath().merge(path);
    }

    private static void throwInnerPrivilegedActionException(PrivilegedActionException err) throws IOException {
        Exception inner = err.getException();
        if (inner instanceof RuntimeException) {
            throw (RuntimeException)inner;
        }
        if (inner instanceof IOException) {
            throw (IOException)inner;
        }
        throw new IOException(err);
    }
}

