/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.web.filters.cache;

import com.tridium.file.types.gzip.BIGzipFile;
import com.tridium.file.util.BInputStreamFileStore;
import com.tridium.web.filters.cache.FileCache;
import com.tridium.web.filters.cache.GzipServletOutputStream;
import com.tridium.web.filters.cache.HeapMemoryFileCache;
import com.tridium.web.filters.cache.ServletOutputStreamWrapper;
import java.io.IOException;
import java.security.AccessController;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.baja.file.BIFile;
import javax.baja.file.BIFileStore;
import javax.baja.file.FilePath;
import javax.baja.naming.OrdTarget;
import javax.baja.spy.Spy;
import javax.baja.spy.SpyDir;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.web.BIDynamicFile;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.owasp.encoder.Encode;

public final class FileCacheFilter
implements Filter {
    private Map<String, Object> monitorMap = new ConcurrentHashMap<String, Object>();
    private FileCache cache;
    public static final String CACHE_PATTERN_PARAM_NAME = "pattern";
    private Pattern cachePattern;
    private String cacheName = "";
    public static final String CACHE_TYPE_PARAM_NAME = "cacheType";
    private boolean disableCache;
    private boolean disableGzip;
    private Logger log;
    private Throwable lastFilterException;
    private BAbsTime lastFilterExceptionTime;
    private String lastFilterExceptionPath;
    private static final Pattern FILE_PATTERN = Pattern.compile(".*/(.+)\\.(.+)$");
    private static final String WEB_FILE_CACHE_SPY_NAME = "webFileCache";

    public void init(FilterConfig config) throws ServletException {
        SpyDir spy;
        this.cacheName = config.getFilterName();
        this.log = Logger.getLogger("web.filecache." + this.cacheName);
        this.disableGzip = AccessController.doPrivileged(() -> Boolean.getBoolean("web.filecache." + this.cacheName + ".gzip.disable"));
        String pattern = config.getInitParameter(CACHE_PATTERN_PARAM_NAME);
        this.cachePattern = pattern != null ? Pattern.compile(pattern) : null;
        String cacheType = Objects.toString(config.getInitParameter(CACHE_TYPE_PARAM_NAME), "");
        this.disableCache = FileCacheFilter.isWebCacheDisabled(this.cacheName);
        if (!this.disableCache) {
            switch (cacheType) {
                case "heapMemory": {
                    this.cache = new HeapMemoryFileCache();
                    break;
                }
                default: {
                    this.cache = null;
                    throw new ServletException("Invalid cache type: " + cacheType);
                }
            }
        }
        if ((spy = (SpyDir)Spy.ROOT.find(WEB_FILE_CACHE_SPY_NAME)) == null) {
            spy = new SpyDir();
            Spy.ROOT.add(WEB_FILE_CACHE_SPY_NAME, (Spy)spy);
        }
        spy.add(this.cacheName, (Spy)new WebFileCacheSpy());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        boolean written = false;
        if (!this.disableCache && "GET".equals(request.getMethod())) {
            BObject object;
            OrdTarget target = (OrdTarget)request.getAttribute("niagara.target");
            BObject bObject = object = target != null ? target.get() : null;
            if (object != null && object instanceof BIFile && !(object instanceof BIDynamicFile)) {
                BIFile originalFile = (BIFile)object;
                String pathInfo = Objects.toString(request.getPathInfo(), "");
                if (this.cachePattern == null || this.cachePattern.matcher(pathInfo).find()) {
                    final boolean doGzip = this.isGzipEnabled(object, request, response);
                    final String path = Objects.toString(request.getRequestURI(), "") + (doGzip ? ".gz" : "");
                    try {
                        Object monitor = this.monitorMap.computeIfAbsent(path, p -> this.cache.has(path) ? null : new Object());
                        if (monitor != null) {
                            Object object2 = monitor;
                            synchronized (object2) {
                                if (!this.cache.has(path)) {
                                    if (this.log.isLoggable(Level.FINE)) {
                                        this.log.fine("Cached file creation start: " + path);
                                    }
                                    if (doGzip) {
                                        response.setHeader("Content-Encoding", "gzip");
                                    }
                                    try {
                                        chain.doFilter((ServletRequest)request, (ServletResponse)new HttpServletResponseWrapper(response){

                                            public ServletOutputStream getOutputStream() throws IOException {
                                                ServletOutputStreamWrapper out = new ServletOutputStreamWrapper(super.getOutputStream(), FileCacheFilter.this.cache.create(path), error -> {
                                                    FileCacheFilter.this.lastFilterException = error;
                                                    FileCacheFilter.this.lastFilterExceptionTime = BAbsTime.now();
                                                    FileCacheFilter.this.lastFilterExceptionPath = path;
                                                    if (FileCacheFilter.this.log.isLoggable(Level.FINE)) {
                                                        FileCacheFilter.this.log.log(Level.FINE, "Cached file problem: " + path, (Throwable)error);
                                                    }
                                                    try {
                                                        FileCacheFilter.this.cache.delete(path);
                                                    }
                                                    catch (IOException e) {
                                                        FileCacheFilter.this.log.log(Level.WARNING, "Cached file could not be removed: " + path, (Throwable)error);
                                                    }
                                                });
                                                return doGzip ? new GzipServletOutputStream(out) : out;
                                            }
                                        });
                                        if (response.getStatus() != 200) {
                                            if (this.log.isLoggable(Level.FINE)) {
                                                this.log.log(Level.FINE, "Cached file problem: " + path + ":" + response.getStatus());
                                            }
                                            this.cache.delete(path);
                                        }
                                    }
                                    catch (IOException | RuntimeException | ServletException err) {
                                        if (this.log.isLoggable(Level.FINE)) {
                                            this.log.log(Level.FINE, "Cached file problem: " + path, err);
                                        }
                                        this.cache.delete(path);
                                        throw err;
                                    }
                                    written = true;
                                    this.monitorMap.remove(path);
                                    if (this.log.isLoggable(Level.FINE)) {
                                        this.log.fine("Cached file creation complete: " + path);
                                    }
                                }
                            }
                        }
                        if (this.cache.has(path) && !written) {
                            Matcher matcher;
                            if (this.log.isLoggable(Level.FINE)) {
                                this.log.fine("Cached file already created: " + path);
                            }
                            if ((matcher = FILE_PATTERN.matcher(path)).find()) {
                                String extension = matcher.group(2);
                                String fileName = matcher.group(1) + "." + extension;
                                BIFile file = (BIFile)Sys.getRegistry().getFileTypeForExtension(extension).getInstance();
                                Context cx = (Context)request.getAttribute("niagara.context");
                                file.setStore((BIFileStore)new BInputStreamFileStore(new FilePath(fileName), originalFile.getLastModified(), originalFile.getPermissions(cx), () -> {
                                    try {
                                        return this.cache.getInputStream(path);
                                    }
                                    catch (IOException err) {
                                        throw new RuntimeException(err);
                                    }
                                }));
                                request.setAttribute("niagara.target", (Object)OrdTarget.unmounted((BObject)file.asObject()));
                            }
                        }
                    }
                    catch (IOException | RuntimeException | ServletException err) {
                        throw err;
                    }
                    catch (Throwable err) {
                        this.lastFilterException = err;
                        this.lastFilterExceptionTime = BAbsTime.now();
                        this.lastFilterExceptionPath = path;
                        if (err instanceof Exception) {
                            throw new ServletException(err);
                        }
                        throw err;
                    }
                }
            }
        }
        if (!written) {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
    }

    public void destroy() {
        try {
            if (this.cache != null) {
                this.cache.clear();
            }
        }
        catch (IOException err) {
            this.log.log(Level.WARNING, "Error clearing cache", err);
        }
        SpyDir spy = (SpyDir)Spy.ROOT.find(WEB_FILE_CACHE_SPY_NAME);
        if (spy != null) {
            spy.remove(this.cacheName);
        }
    }

    public static boolean isWebCacheDisabled(String cacheName) {
        String disabledSysProp = AccessController.doPrivileged(() -> System.getProperty("web.filecache." + cacheName + ".disable"));
        boolean disabled = disabledSysProp == null ? AccessController.doPrivileged(() -> Boolean.getBoolean("web.filecache.disable")).booleanValue() : Boolean.valueOf(disabledSysProp).booleanValue();
        return disabled;
    }

    private boolean isGzipEnabled(BObject object, HttpServletRequest request, HttpServletResponse response) {
        return !this.disableGzip && !(object instanceof BIGzipFile) && Objects.toString(response.getHeader("Content-Encoding"), "").isEmpty() && Objects.toString(request.getHeader("Accept-Encoding"), "").contains("gzip");
    }

    private void clear() throws IOException {
        this.log.info("Web File Cache cleared");
        this.getCache().clear();
        this.lastFilterException = null;
        this.lastFilterExceptionTime = null;
        this.lastFilterExceptionPath = null;
    }

    private String getSpyPath() {
        return "/" + WEB_FILE_CACHE_SPY_NAME + "/" + this.getCacheName();
    }

    public String getCacheName() {
        return this.cacheName;
    }

    public FileCache getCache() {
        return this.cache;
    }

    public void setCache(FileCache cache) {
        this.cache = cache;
    }

    public Logger getLog() {
        return this.log;
    }

    public boolean isCacheDisabled() {
        return this.disableCache;
    }

    public boolean isGzipDisabled() {
        return this.disableGzip;
    }

    public Pattern getCachePattern() {
        return this.cachePattern;
    }

    final class ClearCacheSpy
    extends SpyDir {
        ClearCacheSpy() {
        }

        public void write(SpyWriter out) {
            try {
                FileCacheFilter.this.clear();
                out.w((Object)"<b>Web File Cache Clear Complete</b>");
                out.w((Object)"<br/>");
                out.w((Object)"<br/>");
                out.w((Object)"<b>").a(FileCacheFilter.this.getSpyPath(), (Object)"return to Web File Cache").w((Object)"</b>");
            }
            catch (IOException ioe) {
                out.w((Object)"<b>Web File Cache Clear Failed</b>");
                out.w((Object)"<br/>");
                out.w((Object)"<p>").w((Object)ioe.getMessage()).w((Object)"</p>");
                out.w((Object)"<br/>");
                out.w((Object)"<b>").a(FileCacheFilter.this.getSpyPath(), (Object)"return to Web File Cache").w((Object)"</b>");
                if (FileCacheFilter.this.log.isLoggable(Level.FINE)) {
                    FileCacheFilter.this.log.log(Level.WARNING, "Web File Cache Clear failed", ioe);
                }
                FileCacheFilter.this.log.log(Level.WARNING, "Web File Cache Clear failed");
            }
        }
    }

    private final class WebFileCacheSpy
    extends SpyDir {
        WebFileCacheSpy() {
            this.add("clear", (Spy)new ClearCacheSpy());
        }

        public void write(SpyWriter out) throws Exception {
            out.startProps().prop((Object)"Cache name", (Object)Encode.forHtml((String)FileCacheFilter.this.cacheName)).prop((Object)"Cache disabled", FileCacheFilter.this.disableCache).prop((Object)"Gzip disbled", FileCacheFilter.this.disableGzip).prop((Object)"Cache pattern", (Object)(FileCacheFilter.this.cachePattern != null ? Encode.forHtml((String)FileCacheFilter.this.cachePattern.pattern()) : "--match everything--")).endProps();
            if (FileCacheFilter.this.cache != null) {
                FileCacheFilter.this.cache.spy(out);
                out.w((Object)"<b>").mutatorButton(FileCacheFilter.this.getSpyPath() + "/clear", "Clear").w((Object)"</b><br/><br/>");
            }
            if (FileCacheFilter.this.lastFilterException != null) {
                StringBuilder stackTrace = new StringBuilder();
                String message = FileCacheFilter.this.lastFilterException.getMessage();
                if (message != null) {
                    stackTrace.append(message);
                }
                for (StackTraceElement line : FileCacheFilter.this.lastFilterException.getStackTrace()) {
                    stackTrace.append("&nbsp;&nbsp;").append(line.toString()).append("<br />");
                }
                out.startProps("Last Exception from doFilter()");
                out.prop((Object)"Timestamp", (Object)FileCacheFilter.this.lastFilterExceptionTime);
                out.prop((Object)"Path", (Object)FileCacheFilter.this.lastFilterExceptionPath);
                out.prop((Object)"Exception", (Object)stackTrace.toString());
                out.endProps();
            }
        }

        public Spy find(String name) {
            if (SpyWriter.verifyNameAndCsrfToken((String)name, (String)"clear")) {
                return super.find("clear");
            }
            return super.find(name);
        }
    }
}

