/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.web.filters;

import java.io.IOException;
import java.security.AccessController;
import javax.baja.naming.BLocalHost;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdTarget;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.ModuleNotFoundException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public final class FileOrdTargetFilter
implements Filter {
    private String prefix = "file:^";
    private String filterName = "";

    public void init(FilterConfig filterConfig) throws ServletException {
        if (filterConfig != null) {
            String n;
            String p = filterConfig.getInitParameter("prefix");
            if (p != null) {
                this.prefix = p;
            }
            if ((n = filterConfig.getFilterName()) != null) {
                this.filterName = n;
            }
        }
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse resp = (HttpServletResponse)response;
        String pathInfo = req.getPathInfo();
        if (pathInfo == null) {
            pathInfo = "";
        }
        if (pathInfo.contains("|") || pathInfo.contains("../")) {
            this.log(req, "Invalid path info: " + pathInfo);
            resp.sendError(400);
            return;
        }
        if (pathInfo.startsWith("/")) {
            pathInfo = pathInfo.substring(1, pathInfo.length());
        }
        try {
            Context cx = (Context)req.getAttribute("niagara.context");
            if (cx == null || cx.getUser() == null) {
                this.log(req, "No valid Context");
                resp.sendError(400);
                return;
            }
            String pi = pathInfo;
            AccessController.doPrivileged(() -> {
                OrdTarget target = BOrd.make((String)(this.prefix + pi)).resolve((BObject)BLocalHost.INSTANCE, cx);
                req.setAttribute("niagara.target", (Object)target);
                return null;
            });
        }
        catch (Throwable e) {
            if (!(e instanceof ModuleNotFoundException) || !((ModuleNotFoundException)e).getModuleName().startsWith("theme")) {
                this.log(req, "Could not resolve ORD", e);
            }
            resp.sendError(404);
            return;
        }
        chain.doFilter((ServletRequest)req, (ServletResponse)resp);
    }

    private void log(HttpServletRequest req, String msg) {
        req.getServletContext().log(this.filterName + ": " + msg);
    }

    private void log(HttpServletRequest req, String message, Throwable e) {
        req.getServletContext().log(this.filterName + ": " + message, e);
    }
}

