/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.web.authn;

import com.tridium.authn.BAuthenticationSchemeFolder;
import com.tridium.authn.BAuthenticationService;
import com.tridium.web.CookieUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.authn.BAuthenticationScheme;
import javax.baja.nre.util.KeyValueTuple;
import javax.baja.space.BComponentSpace;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.TypeSubscriber;
import javax.baja.web.authn.BILoginHTMLForm;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class FormsAndSchemesHandler {
    private static FormsAndSchemesHandler instance;
    private static final Logger log;
    private static final ReentrantReadWriteLock lock;
    private static List<KeyValueTuple<BILoginHTMLForm, List<BAuthenticationScheme>>> formsAndSchemesList;
    TypeSubscriber authSchemesSubscriber;

    private FormsAndSchemesHandler() {
        BAuthenticationSchemeFolder authenticationSchemes = BAuthenticationService.getService().getAuthenticationSchemes();
        this.authSchemesSubscriber = new AuthenticationSchemesSubscriber(authenticationSchemes.getComponentSpace());
        this.authSchemesSubscriber.subscribe(BAuthenticationScheme.TYPE, null);
    }

    public static FormsAndSchemesHandler getInstance() {
        if (instance == null) {
            instance = new FormsAndSchemesHandler();
            instance.updateList();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateList() {
        lock.writeLock().lock();
        try {
            BAuthenticationService authnService = BAuthenticationService.getService();
            List remoteSchemes = authnService.getRemoteSchemes();
            formsAndSchemesList = new ArrayList<KeyValueTuple<BILoginHTMLForm, List<BAuthenticationScheme>>>();
            for (BAuthenticationScheme bAuthenticationScheme : remoteSchemes) {
                BILoginHTMLForm form = (BILoginHTMLForm)bAuthenticationScheme.getAgentOn(BILoginHTMLForm.class);
                if (form == null) continue;
                for (KeyValueTuple<BILoginHTMLForm, List<BAuthenticationScheme>> formAndScheme : formsAndSchemesList) {
                    if (!((BILoginHTMLForm)formAndScheme.key).getType().equals(form.getType())) continue;
                    ((List)formAndScheme.value).add(bAuthenticationScheme);
                    form = null;
                    break;
                }
                if (form == null) continue;
                ArrayList<BAuthenticationScheme> schemeList = new ArrayList<BAuthenticationScheme>();
                schemeList.add(bAuthenticationScheme);
                formsAndSchemesList.add((KeyValueTuple<BILoginHTMLForm, List<BAuthenticationScheme>>)new KeyValueTuple((Object)form, schemeList));
            }
            if (log.isLoggable(Level.FINEST)) {
                log.finest("Build new forms and schemes list with:");
                for (KeyValueTuple keyValueTuple : formsAndSchemesList) {
                    log.finest("Form type: " + ((BILoginHTMLForm)keyValueTuple.key).getType());
                    for (BAuthenticationScheme scheme : (List)keyValueTuple.value) {
                        log.finest("Scheme: " + scheme.getName() + ":" + scheme.getType());
                    }
                }
            }
        }
        finally {
            lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<BILoginHTMLForm> getLoginFormFromRequest(HttpServletRequest request) {
        lock.readLock().lock();
        try {
            if (formsAndSchemesList == null || formsAndSchemesList.isEmpty()) {
                log.finest("No forms and schemes list - returning empty login form");
                Optional<BILoginHTMLForm> optional = Optional.empty();
                return optional;
            }
            int currentFormId = this.getCurrentFormId(request);
            if (currentFormId == -1) {
                log.finer("Could not get current form id - returning empty login form");
                Optional<BILoginHTMLForm> optional = Optional.empty();
                return optional;
            }
            BILoginHTMLForm form = (BILoginHTMLForm)FormsAndSchemesHandler.formsAndSchemesList.get((int)currentFormId).key;
            if (form == null) {
                log.fine("Null value found in form list - returning empty login form");
                Optional<BILoginHTMLForm> optional = Optional.empty();
                return optional;
            }
            Optional<Object> optional = Optional.of(FormsAndSchemesHandler.formsAndSchemesList.get((int)currentFormId).key);
            return optional;
        }
        catch (NumberFormatException e) {
            log.log(Level.FINER, "Form id cookie contains invalid value - returning empty login form.", e);
            Optional<BILoginHTMLForm> optional = Optional.empty();
            return optional;
        }
        finally {
            lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<BAuthenticationScheme> getSchemesFromRequest(HttpServletRequest request) {
        lock.readLock().lock();
        try {
            int currentSchemeId;
            if (formsAndSchemesList == null || formsAndSchemesList.isEmpty()) {
                List<BAuthenticationScheme> list = Collections.emptyList();
                return list;
            }
            int currentFormId = this.getCurrentFormId(request);
            if (currentFormId == -1) {
                log.finer("Could not get form id cookie - setting form id to 0");
                currentFormId = 0;
            }
            if ((currentSchemeId = this.getCurrentSchemeId(request, currentFormId)) == -1) {
                log.finer("Could not get scheme id cookie - setting scheme id to 0");
                currentSchemeId = 0;
            }
            List allSchemesForForm = (List)FormsAndSchemesHandler.formsAndSchemesList.get((int)currentFormId).value;
            ArrayList<BAuthenticationScheme> arrayList = new ArrayList<BAuthenticationScheme>(allSchemesForForm.subList(currentSchemeId, allSchemesForForm.size()));
            return arrayList;
        }
        finally {
            lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incrementFormAndSchemeCookies(HttpServletRequest request, HttpServletResponse response) {
        lock.readLock().lock();
        try {
            List allSchemesForForm;
            int currentSchemeId;
            if (formsAndSchemesList == null || formsAndSchemesList.isEmpty()) {
                return;
            }
            int currentFormId = this.getCurrentFormId(request);
            if (currentFormId == -1) {
                log.finer("Could not get form id cookie - setting form id to 0");
                currentFormId = 0;
            }
            if ((currentSchemeId = this.getCurrentSchemeId(request, currentFormId)) == -1) {
                log.finer("Could not get scheme id cookie - setting scheme id to 0");
                currentSchemeId = 0;
            }
            if (currentSchemeId == (allSchemesForForm = (List)FormsAndSchemesHandler.formsAndSchemesList.get((int)currentFormId).value).size() - 1 && currentFormId == formsAndSchemesList.size() - 1) {
                this.clearFormAndSchemeCookies(request, response);
            } else if (currentSchemeId == allSchemesForForm.size() - 1) {
                response.addCookie(CookieUtil.createCookie("niagara_cfid", String.valueOf(currentFormId + 1), -1, true, request.isSecure()));
                response.addCookie(CookieUtil.createCookie("niagara_csid", "0", -1, true, request.isSecure()));
            } else {
                response.addCookie(CookieUtil.createCookie("niagara_csid", String.valueOf(currentSchemeId + 1), -1, true, request.isSecure()));
            }
        }
        finally {
            lock.readLock().unlock();
        }
    }

    public void clearFormAndSchemeCookies(HttpServletRequest request, HttpServletResponse response) {
        response.addCookie(CookieUtil.createCookie("niagara_cfid", "", 0, true, request.isSecure()));
        response.addCookie(CookieUtil.createCookie("niagara_csid", "", 0, true, request.isSecure()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getCurrentFormId(HttpServletRequest request) {
        lock.readLock().lock();
        try {
            int currentFormId = -1;
            Cookie formIdCookie = CookieUtil.getCookieFromName(request, "niagara_cfid");
            if (formIdCookie == null) {
                log.finer("No form id cookie found");
            } else {
                try {
                    int cookieFormId = Integer.parseInt(formIdCookie.getValue());
                    if (cookieFormId < 0 || cookieFormId >= formsAndSchemesList.size()) {
                        if (log.isLoggable(Level.FINER)) {
                            log.finer("Form id cookie contains out of range value '" + cookieFormId);
                        }
                    } else {
                        currentFormId = cookieFormId;
                    }
                }
                catch (NumberFormatException e) {
                    log.log(Level.FINER, "Form id cookie contains invalid value", e);
                }
            }
            int n = currentFormId;
            return n;
        }
        finally {
            lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getCurrentSchemeId(HttpServletRequest request, int currentFormId) {
        lock.readLock().lock();
        try {
            int currentSchemeId = -1;
            Cookie schemeIdCookie = CookieUtil.getCookieFromName(request, "niagara_csid");
            if (schemeIdCookie == null) {
                log.finer("No scheme id cookie found");
            } else {
                try {
                    int cookieSchemeId = Integer.parseInt(schemeIdCookie.getValue());
                    if (cookieSchemeId < 0 || cookieSchemeId >= ((List)FormsAndSchemesHandler.formsAndSchemesList.get((int)currentFormId).value).size()) {
                        if (log.isLoggable(Level.FINER)) {
                            log.finer("Scheme id cookie contains out of range value '" + cookieSchemeId);
                        }
                    } else {
                        currentSchemeId = cookieSchemeId;
                    }
                }
                catch (NumberFormatException e) {
                    log.log(Level.FINER, "Scheme id cookie contains invalid value", e);
                }
            }
            int n = currentSchemeId;
            return n;
        }
        finally {
            lock.readLock().unlock();
        }
    }

    static {
        log = Logger.getLogger("web");
        lock = new ReentrantReadWriteLock(true);
        formsAndSchemesList = null;
    }

    private class AuthenticationSchemesSubscriber
    extends TypeSubscriber {
        AuthenticationSchemesSubscriber(BComponentSpace space) {
            super(space);
        }

        public void event(BComponentEvent event) {
            int id = event.getId();
            switch (id) {
                case 11: 
                case 12: 
                case 14: {
                    FormsAndSchemesHandler.this.updateList();
                    break;
                }
            }
        }
    }
}

