/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.web.authn;

import java.io.IOException;
import java.util.Base64;
import javax.baja.nre.annotations.NiagaraSlots;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.web.authn.BWebCallbackHandler;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@NiagaraSlots
public class BWebHTTPBasicCallbackHandler
extends BWebCallbackHandler {
    public static final Type TYPE = Sys.loadType(BWebHTTPBasicCallbackHandler.class);
    private String username = null;
    private char[] password = null;
    private boolean readyForCallback = false;

    @Override
    public Type getType() {
        return TYPE;
    }

    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        if (!this.readyForCallback) {
            throw new IllegalStateException("Not ready for callback");
        }
        for (Callback callback : callbacks) {
            if (callback instanceof NameCallback) {
                ((NameCallback)callback).setName(this.username);
                continue;
            }
            if (callback instanceof PasswordCallback) {
                ((PasswordCallback)callback).setPassword(this.password);
                continue;
            }
            throw new UnsupportedCallbackException(callback, "Callback: " + callback + " is not supported.");
        }
    }

    @Override
    public int handleRequest(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String header = req.getHeader("Authorization");
        String creds = new String(Base64.getDecoder().decode(header.substring(header.indexOf(" ") + 1)));
        this.username = creds.substring(0, creds.indexOf(":"));
        this.password = creds.substring(creds.indexOf(":") + 1).toCharArray();
        this.readyForCallback = true;
        return 0;
    }

    @Override
    public String getUsername() {
        return this.username;
    }
}

