/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.web.authn;

import com.tridium.web.Template;
import java.io.IOException;
import java.util.HashMap;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.NiagaraSlots;
import javax.baja.sys.BString;
import javax.baja.sys.BStruct;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;
import javax.baja.web.authn.BILoginHTMLForm;

@NiagaraSlots
public class BDigestLoginHTMLForm
extends BStruct
implements BILoginHTMLForm {
    public static final Type TYPE = Sys.loadType(BDigestLoginHTMLForm.class);
    private Lexicon lex = null;
    private static final BOrd TEMPLATE_ORD = BOrd.make((String)"module://web/com/tridium/web/rc/digestLoginFormN4.vm");
    private static final BOrd RESET_TEMPLATE_ORD = BOrd.make((String)"module://web/com/tridium/web/rc/passwordResetFormN4.vm");

    public Type getType() {
        return TYPE;
    }

    @Override
    public String getLoginFormHTML(Context context, boolean passwordReset) throws IOException {
        if (context == null) {
            context = new BasicContext();
        }
        this.lex = Lexicon.make((String)"web", (Context)context);
        String username = this.getLabel(context, "login.username");
        String password = this.getLabel(context, "login.password");
        String login = this.getLabel(context, "login");
        String newPass = this.getLabel(context, "login.password.new");
        String confirm = this.getLabel(context, "login.password.new.retype");
        String changeuser = this.getLabel(context, "login.changeuser");
        BString initUsername = (BString)context.getFacet("initUsername");
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("login", login);
        map.put("userName", username);
        map.put("password", password);
        map.put("new", newPass);
        map.put("confirm", confirm);
        map.put("changeUser", changeuser);
        if (initUsername != null) {
            map.put("initUsername", initUsername.getString());
        } else {
            map.put("initUsername", "");
        }
        String form = passwordReset ? Template.process(RESET_TEMPLATE_ORD, true) : Template.process(TEMPLATE_ORD, true);
        String processedForm = Template.process(map, form);
        return processedForm;
    }

    private String getLabel(Context context, String key) {
        BString bString = (BString)context.getFacet(key);
        if (bString != null) {
            return bString.getString();
        }
        return this.lex.getHtmlSafe(key);
    }
}

