/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.web;

import com.tridium.net.BHttpScheme;
import com.tridium.net.BHttpsScheme;
import com.tridium.util.Href2Ord;
import com.tridium.web.SnoopHtmlWriter;
import com.tridium.web.WebUtil;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Writer;
import java.util.HashSet;
import java.util.Optional;
import javax.baja.file.BFileScheme;
import javax.baja.file.BIFile;
import javax.baja.naming.BModuleScheme;
import javax.baja.naming.BOrd;
import javax.baja.naming.BViewScheme;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.OrdTarget;
import javax.baja.sys.BObject;
import javax.baja.sys.ServiceNotFoundException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.web.BWebServer;
import javax.baja.web.BWebService;
import javax.baja.web.BWebServlet;
import javax.baja.web.WebOp;
import javax.servlet.http.HttpServletRequest;

public class WebSnoopHtmlWriter
extends SnoopHtmlWriter {
    private static final HashSet<String> fileDownloadTags = new HashSet();
    private static final HashSet<String> fileViewTags;
    private static final HashSet<String> fileDownloadMimeTypes;
    private final OrdTarget target;
    private final HttpServletRequest req;
    private BWebServlet[] servlets;

    private WebSnoopHtmlWriter(OrdTarget target, HttpServletRequest req, Writer out) {
        super(out);
        this.target = target;
        this.req = req;
    }

    public WebSnoopHtmlWriter(WebOp op, Writer out) {
        super(out);
        this.target = op;
        this.req = op.getRequest();
    }

    public static void pipe(WebOp op, InputStream in, Writer out) throws IOException {
        WebSnoopHtmlWriter.pipe((OrdTarget)op, op.getRequest(), in, out);
    }

    public static void pipe(OrdTarget target, HttpServletRequest req, InputStream in, Writer out) throws IOException {
        InputStreamReader reader = new InputStreamReader(new BufferedInputStream(in));
        WebSnoopHtmlWriter snoop = new WebSnoopHtmlWriter(target, req, out);
        snoop.pipe(reader);
    }

    @Override
    protected String hrefToUri(String href, Optional<String> tag) {
        try {
            if (href.startsWith("#")) {
                return href;
            }
            if (href.startsWith("http:") || href.startsWith("https:")) {
                return href;
            }
            if (href.startsWith("ftp:")) {
                return href;
            }
            if (href.startsWith("javascript:")) {
                return href;
            }
            if (href.startsWith("mailto:")) {
                return href;
            }
            if (href.equals("/login") || href.equals("/logout")) {
                return href;
            }
            if (this.isServlet(href)) {
                return href;
            }
            if (this.href2Ord == null) {
                this.href2Ord = new Href2Ord(this.target.getOrd());
            }
            return this.makeUriForOrd(this.href2Ord.hrefToOrd(href), tag);
        }
        catch (Exception e) {
            e.printStackTrace();
            return href;
        }
    }

    private String makeUriForOrd(BOrd ord, Optional<String> tag) {
        boolean hasViewQuery = false;
        boolean hasModuleQuery = false;
        boolean hasFileQuery = false;
        String schemeBody = null;
        for (OrdQuery query : ord.parse()) {
            String scheme = query.getScheme();
            if (scheme.equals(BModuleScheme.INSTANCE.getId())) {
                hasModuleQuery = true;
                schemeBody = query.getBody();
                continue;
            }
            if (scheme.equals(BFileScheme.INSTANCE.getId())) {
                hasFileQuery = true;
                schemeBody = query.getBody();
                continue;
            }
            if (scheme.equals(BHttpScheme.INSTANCE.getId()) || scheme.equals(BHttpsScheme.INSTANCE.getId())) {
                return ord.toString();
            }
            if (!scheme.equals(BViewScheme.INSTANCE.getId())) continue;
            hasViewQuery = true;
        }
        if (hasModuleQuery || hasFileQuery) {
            if (WebSnoopHtmlWriter.requiresFileViewUri(tag)) {
                return WebUtil.toUri(this.target, "/ord/", ord);
            }
            if (WebSnoopHtmlWriter.requiresFileDownloadUri(this.target, tag) && !hasViewQuery) {
                if (hasFileQuery && schemeBody.startsWith("^")) {
                    return "/file/" + schemeBody.substring(1);
                }
                if (hasModuleQuery) {
                    return "/module" + schemeBody.substring(1);
                }
                ord = BOrd.make((BOrd)ord, (String)"view:web:FileDownloadView");
            }
        }
        return WebUtil.toUri(this.target, this.req, ord);
    }

    private static boolean requiresFileViewUri(Optional<String> tag) {
        return tag.isPresent() && fileViewTags.contains(tag.get());
    }

    private static boolean requiresFileDownloadUri(OrdTarget target, Optional<String> tag) {
        if (tag.isPresent()) {
            return fileDownloadTags.contains(tag.get());
        }
        BObject obj = target.get();
        if (obj instanceof BIFile) {
            BIFile file = (BIFile)obj;
            return fileDownloadMimeTypes.contains(file.getMimeType());
        }
        return false;
    }

    public boolean isServlet(String href) {
        try {
            BWebService web;
            BWebServer server;
            if (this.servlets == null && (server = (web = (BWebService)Sys.getService((Type)BWebService.TYPE)).getWebServer()) != null) {
                this.servlets = server.getServlets();
            }
            if (this.servlets != null) {
                for (int i = 0; i < this.servlets.length; ++i) {
                    String name = "/" + this.servlets[i].getServletName();
                    if (!href.startsWith(name)) continue;
                    int nameLen = name.length();
                    if (href.length() == nameLen) {
                        return true;
                    }
                    switch (href.charAt(nameLen)) {
                        case '#': 
                        case '/': 
                        case ';': 
                        case '?': {
                            return true;
                        }
                    }
                }
            }
        }
        catch (ServiceNotFoundException serviceNotFoundException) {
            // empty catch block
        }
        return false;
    }

    static {
        fileDownloadTags.add("link");
        fileDownloadTags.add("img");
        fileDownloadTags.add("script");
        fileDownloadTags.add("source");
        fileDownloadTags.add("embed");
        fileDownloadTags.add("object");
        fileDownloadMimeTypes = new HashSet();
        fileDownloadMimeTypes.add("text/css");
        fileViewTags = new HashSet();
        fileViewTags.add("a");
    }
}

