/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.web;

import com.tridium.json.JSONObject;
import com.tridium.logging.BLoggingService;
import java.io.IOException;
import java.io.Writer;
import java.security.AccessController;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.baja.naming.BOrd;
import javax.baja.nre.util.TextUtil;
import javax.baja.registry.TypeInfo;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.web.WebDev;
import javax.baja.web.js.BIRequireJsConfig;
import javax.baja.web.js.JsInfo;

public final class RequireJsUtil {
    private final boolean useLocalWbRc;
    private final String modulePrefix;
    private final Context cx;
    public static final String initialModulePrefix = "module://";
    public static final String remoteModulePrefix = "/module/";
    public static final String wbModulePrefix = "https://workbench/module/";
    public static final String wbHostName = "workbench";
    private static final boolean NO_PROMISE_WARNINGS = AccessController.doPrivileged(() -> Boolean.getBoolean("niagara.noPromiseWarnings"));
    public static final boolean USE_NATIVE_PROMISES = AccessController.doPrivileged(() -> Boolean.getBoolean("niagara.useNativePromises"));
    private static final String[] EXPOSED_SYSTEM_PROPERTIES = new String[]{"bajaux.binder.disableOrdSubstitution", "niagara.export.preventCSVInjection", "niagara.nav.touch.scanRate", "niagara.uxMedia.onError", "niagara.webChart.autoSamplingSize", "niagara.webChart.maxSamplingSize", "niagara.webChart.maxSeriesCapacity", "niagara.webTableMaxLength"};
    private static final boolean DEBUG_ARGS = AccessController.doPrivileged(() -> Boolean.getBoolean("niagara.requirejs.debugArgs"));
    private static final boolean USE_JQUERY_STRICT_HTML_PREFILTER = AccessController.doPrivileged(() -> Boolean.getBoolean("niagara.requirejs.useJQueryStrictHtmlPrefilter"));

    private RequireJsUtil(boolean useLocalWbRc, Context cx) {
        this.useLocalWbRc = useLocalWbRc;
        this.modulePrefix = RequireJsUtil.getModulePrefix(useLocalWbRc);
        this.cx = cx;
    }

    public static RequireJsUtil make(boolean useLocalWbRc, Context cx) {
        return new RequireJsUtil(useLocalWbRc, cx);
    }

    public void requirejs(Writer writer) throws IOException {
        this.requirejs(BOrd.NULL, writer);
    }

    public void requirejsNoHtml(Writer writer) throws IOException {
        writer.write("var require = typeof require === 'undefined' ? {} : require;\n");
        this.createRequireJs(BOrd.NULL, writer, false);
    }

    public void requirejs(BOrd mainOrd, Writer writer) throws IOException {
        writer.write("<script type='text/javascript'>var require = typeof require === 'undefined' ? {} : require;</script>\n");
        this.createRequireJs(mainOrd, writer, true);
    }

    public void requirejs(BOrd mainOrd, String requireJs, Writer writer) throws IOException {
        writer.write("<script type='text/javascript'>");
        writer.write(requireJs);
        writer.write("</script>\n");
        this.createRequireJs(mainOrd, writer, true);
    }

    public void requirejs(BOrd mainOrd, BOrd configFileOrd, Writer writer) throws IOException {
        writer.write("<script type='text/javascript' src='");
        writer.write(TextUtil.replace((String)configFileOrd.toString(), (String)initialModulePrefix, (String)RequireJsUtil.getModulePrefix(this.useLocalWbRc)));
        writer.write("?version=");
        writer.write(RequireJsUtil.getUrlVersion());
        writer.write("'></script>\n");
        this.createRequireJs(mainOrd, writer, true);
    }

    private void createRequireJs(BOrd main, Writer writer, boolean html) throws IOException {
        boolean isWebDevBajaScript = RequireJsUtil.isWebDevBajaScript();
        boolean isWebDevJs = RequireJsUtil.isWebDevJs();
        String urlVersion = RequireJsUtil.getUrlVersion();
        ConfigBuilder out = new ConfigBuilder(writer);
        if (html) {
            out.w("<script type='text/javascript'>", new Object[0]);
        }
        out.w("require.urlArgs=require.urlArgs ||  'version=%s';", new Object[]{urlVersion});
        out.w("require.waitSeconds=0;", new Object[0]);
        out.w("require.config=require.config || {};", new Object[0]);
        out.w("require.config.ord=require.config.ord || {};", new Object[0]);
        out.w("require.config.ord.useLocalWbRc=%s;", new Object[]{this.useLocalWbRc});
        out.w("require.config.baja=require.config.baja || {};", new Object[0]);
        out.w("require.config.baja.webdev=%s;", new Object[]{isWebDevBajaScript});
        out.w("require.config.baja.offline=%s;", new Object[]{!Sys.isStation()});
        out.w("require.config.lex=require.config.lex || {};", new Object[0]);
        out.w("require.config.lex.webdev=%s;", new Object[]{isWebDevJs});
        out.w("require.hbs=require.hbs || {};", new Object[0]);
        out.w("require.hbs.i18n=require.hbs.i18n===undefined?false:require.hbs.i18n;", new Object[0]);
        out.w("require.hbs.helpers=require.hbs.helpers===undefined?false:require.hbs.helpers;", new Object[0]);
        out.w("require.hbs.fetchText = function (uri, callback) {\n  function unmodularize(href) {\n    var res;\n    if (href) {\n      res = /^module:\\/\\/(.+)$/.exec(href);\n      if (res && res[1]) {\n        href = '/module/' + res[1];\n      }\n    }\n    return href;\n  }\n  \n  require(['baja!', 'jquery'], function (baja, $) {\n    if (baja.isOffline()) {\n      uri = /([^?]*)\\??.*/.exec(uri)[1];\n      uri = uri.replace('https://workbench/module/', 'module://');\n      baja.rpc('type:web:FileRpc', 'readTextFile', uri)\n        .then(function (text) {\n          callback(text, uri);\n        });\n    }\n    else {\n      $.ajax(unmodularize(uri)).then(function (text) {\n        callback(text, uri);\n      });\n    }\n  });\n};", new Object[0]);
        out.w("require.config['nmodule/js/rc/lex/lex']={storageId:'%s, lex: %s'};", new Object[]{urlVersion, this.cx != null ? this.cx.getLanguage() : "en"});
        JSONObject logLevels = RequireJsUtil.getLogLevelsConfig(this.cx);
        if (logLevels != null) {
            out.w("require.config['nmodule/js/rc/log/Log']={", new Object[0]).w("logLevels:" + logLevels + ',', new Object[0]).w("logHandlers: ['nmodule/js/rc/log/handlers/rpcHandler']", new Object[0]).w("};", new Object[0]);
        }
        out.w("require.map=require.map || {};", new Object[0]);
        out.w("require.map['*']=require.map['*'] || {};", new Object[0]);
        out.w("require.paths=require.paths || {};", new Object[0]);
        out.w("require.paths.nmodule=require.paths.nmodule || '%s';", new Object[]{this.modulePrefix.substring(0, this.modulePrefix.length() - 1)});
        if (USE_NATIVE_PROMISES) {
            out.path("Promise", "js/rc/shims/Promise");
        } else {
            out.path("Promise", "js/rc/bluebird/bluebird", isWebDevJs ? "" : ".min");
        }
        if (!USE_JQUERY_STRICT_HTML_PREFILTER) {
            out.map("jquery", "nmodule/js/rc/shims/jquery/jquery" + (isWebDevJs ? "" : ".min"));
        }
        out.path("bajaScript", "bajaScript/rc").path("bajaPromises", "bajaScript/rc/env/Promises").path("bajaBrowserEnvUtil", "bajaScript/rc/env/jQueryBrowserEnvUtil").path("bajaux", "bajaux/rc").path("jquery", "js/rc/jquery/jquery", isWebDevJs ? "" : ".min").path("dialogs", "js/rc/dialogs/dialogs").plugin("lex", "js/rc/lex/lexplugin").plugin("log", "js/rc/log/logPlugin").path("css", "js/com/tridium/js/ext/require/css").path("text", "js/com/tridium/js/ext/require/text").path("baja", "bajaScript/rc/plugin/baja").path("Handlebars", "js/rc/handlebars/handlebars", isWebDevJs ? "" : ".min").path("underscore", "js/rc/underscore/underscore", isWebDevJs ? "" : ".min").path("hbs", "js/rc/require-handlebars-plugin/hbs", isWebDevJs ? "" : ".built.min").path("moment", "js/rc/shims/moment/moment").path("d3", "js/rc/d3/d3", isWebDevJs ? "" : ".min").path("hx", "hx/javax/baja/hx/hx").path("jqueryContextMenu", "js/rc/jquery/contextMenu/jquery.contextMenu").path("ace", "js/rc/ace");
        out.w("require.shim=require.shim || {};", new Object[0]).w("require.shim.d3=require.shim.d3 || {};", new Object[0]).w("require.shim.d3.exports=require.shim.d3.exports || 'd3';", new Object[0]).w("require.shim.jqueryContextMenu=require.shim.jqueryContextMenu || {deps:['jquery'],exports:'jQuery'};", new Object[0]);
        for (TypeInfo type : Sys.getRegistry().getConcreteTypes(BIRequireJsConfig.TYPE.getTypeInfo())) {
            BIRequireJsConfig config = (BIRequireJsConfig)type.getInstance();
            config.write(writer, this.modulePrefix, isWebDevJs, this.cx);
        }
        if (html) {
            out.w("</script>", new Object[0]);
            out.w("<script type='text/javascript' %s src='%sjs/com/tridium/js/ext/require/%s?version=%s'></script>", new Object[]{!main.isNull() ? String.format("data-main='%s'", this.useLocalWbRc ? JsInfo.toRequireJsId(main) : TextUtil.replace((String)main.toString(), (String)initialModulePrefix, (String)this.modulePrefix)) : "", this.modulePrefix, isWebDevJs ? "require.js" : "require.min.js", urlVersion});
            if (isWebDevJs) {
                out.w("<script type='text/javascript' src='%sjs/com/tridium/js/ext/require/xrayquire/xrayquire.js'></script>", new Object[]{this.modulePrefix});
            }
            if (!isWebDevJs) {
                out.w("<script type='text/javascript' src='%sjs/rc/js.built.min.js?version=%s'></script>", new Object[]{this.modulePrefix, urlVersion});
            }
            boolean debugPromises = isWebDevJs && !NO_PROMISE_WARNINGS;
            RequireJsUtil.writePromiseConfig(out, debugPromises, debugPromises);
            if (isWebDevBajaScript) {
                RequireJsUtil.exposeGlobalBajaScript(out);
            }
            out.w("<script type='text/javascript'>%s</script>", new Object[]{this.defineSystemProperties()});
        }
    }

    private static void writePromiseConfig(ConfigBuilder out, boolean warnings, boolean longStackTraces) throws IOException {
        out.w("<script type='text/javascript'>require(['Promise'], function (Promise) {if (!Promise.config) { return; }Promise.config({warnings: " + warnings + ", longStackTraces: " + longStackTraces + ", cancellation: false, monitoring: false});});</script>", new Object[0]);
    }

    private static void exposeGlobalBajaScript(ConfigBuilder out) throws IOException {
        out.w("<script type='text/javascript'>require(['baja!'], function (baja) { window.baja = baja; });</script>", new Object[0]);
    }

    private static JSONObject getLogLevelsConfig(Context cx) {
        return Sys.findService((Type)BLoggingService.TYPE).map(service -> {
            BLoggingService loggingService = (BLoggingService)service;
            return loggingService.getEnableRemoteLogging() ? new JSONObject(loggingService.getLevels(cx)) : null;
        }).orElse(null);
    }

    public static String getUrlVersion() {
        if (DEBUG_ARGS) {
            return String.valueOf(BAbsTime.now().getMillis());
        }
        return String.valueOf(Sys.getRegistry().getLastBuildTime().getMillis());
    }

    public String defineSystemProperties() {
        StringBuilder sb = new StringBuilder();
        sb.append("define('niagaraSystemProperties', function () {\n");
        sb.append("  return {\n");
        sb.append("    ");
        String jsonPairs = AccessController.doPrivileged(() -> RequireJsUtil.getExposedSystemProperties().stream().map(RequireJsUtil::toJsonPair).filter(Objects::nonNull).collect(Collectors.joining(",\n    ")));
        sb.append(jsonPairs);
        sb.append("\n  };\n");
        sb.append("});\n");
        return sb.toString();
    }

    private static String toJsonPair(String propKey) {
        String propValue = System.getProperty(propKey);
        if (propValue != null) {
            propValue = propValue.replace("\\", "\\\\").replace("\"", "\\\"");
            return String.join((CharSequence)"", "\"", propKey, "\": \"", propValue, "\"");
        }
        return null;
    }

    private static List<String> getExposedSystemProperties() {
        return Arrays.asList(EXPOSED_SYSTEM_PROPERTIES);
    }

    public static String getModulePrefix(boolean useLocalWbRc) {
        return useLocalWbRc ? wbModulePrefix : remoteModulePrefix;
    }

    private static boolean isWebDevJs() {
        return WebDev.get("js").isEnabled();
    }

    private static boolean isWebDevBajaScript() {
        return WebDev.get("bajaScript").isEnabled();
    }

    private class ConfigBuilder {
        private final Writer writer;

        private ConfigBuilder(Writer writer) {
            this.writer = writer;
        }

        private ConfigBuilder w(String s, Object ... objs) throws IOException {
            this.writer.write(String.format(s, objs));
            this.writer.write("\n");
            return this;
        }

        private ConfigBuilder plugin(String pluginName, String value) throws IOException {
            this.w("require.map['*']['" + pluginName + "']='nmodule/" + value + "';", new Object[0]);
            if (RequireJsUtil.isWebDevJs()) {
                return this.w("require.paths['nmodule/%s']=require.paths['nmodule/%s'] || '%s%s';", value, value, RequireJsUtil.this.modulePrefix, value);
            }
            return this;
        }

        private ConfigBuilder map(String moduleName, String replacement) throws IOException {
            this.w("require.map['*']=require.map['*'] || {};", new Object[0]);
            this.w("require.map['*']['" + moduleName + "']=require.map['*']['" + moduleName + "'] || '" + replacement + "';", new Object[0]);
            this.w("require.map['" + replacement + "']=require.map['" + replacement + "'] || {};", new Object[0]);
            this.w("require.map['" + replacement + "']['" + moduleName + "']='" + moduleName + "';", new Object[0]);
            return this;
        }

        private ConfigBuilder path(String key, String value) throws IOException {
            return this.path(key, value, "");
        }

        private ConfigBuilder path(String key, String value, String optional) throws IOException {
            return this.w("require.paths.%s=require.paths.%s || '%s%s%s';", key, key, RequireJsUtil.this.modulePrefix, value, optional);
        }
    }
}

