/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.web;

import com.tridium.nre.security.Aes256PasswordManager;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import java.util.concurrent.TimeUnit;
import javax.baja.nre.util.ByteArrayUtil;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;

public class CookieUtil {
    public static final String CNAME_USERID = "niagara_userid";
    public static final String CNAME_ENCRYPTED_USERID = "niagara_essential_session_support";
    public static final String CNAME_AUTH_SCHEME = "niagara_auth_scheme";
    public static final String CNAME_SESSIONID = "jsessionid";
    public static final String CNAME_SUPER_SESSION_ID = "super_session_id";
    public static final String CNAME_SSO_SCHEME = "niagara_sso_scheme";
    public static final String CNAME_CURRENT_SSO_SCHEME = "niagara_current_sso_scheme";
    public static final String CNAME_CURRENT_FORM_ID = "niagara_cfid";
    public static final String CNAME_CURRENT_SCHEME_ID = "niagara_csid";
    public static final String CNAME_ORIGIN_URI = "niagara_origin_uri";
    public static final String CNAME_FAILURE_CAUSE = "niagara_failure_cause";
    public static final String CNAME_FAILURE_INFO = "niagara_failure_info";
    public static final int COOKIE_AGE = (int)TimeUnit.DAYS.toSeconds(365L);
    private static final SecureRandom SECURE_RANDOM = new SecureRandom();
    private static byte[] encryptionKey = null;

    public static Cookie getCookieFromName(HttpServletRequest request, String name) {
        return CookieUtil.getCookieFromName(request, name, true);
    }

    public static Cookie getCookieFromName(HttpServletRequest request, String name, boolean decode) {
        Cookie[] cookies = request.getCookies();
        if (cookies == null) {
            return null;
        }
        for (Cookie cookie : cookies) {
            String safeName = cookie.getName();
            try {
                if (decode) {
                    safeName = URLDecoder.decode(safeName, "UTF-8");
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!name.equals(safeName)) continue;
            if (decode) {
                try {
                    String value = cookie.getValue();
                    String safeValue = URLDecoder.decode(value, "UTF-8");
                    Cookie c = new Cookie(safeName, safeValue);
                    c.setMaxAge(cookie.getMaxAge());
                    c.setSecure(cookie.getSecure());
                    c.setHttpOnly(cookie.isHttpOnly());
                    if (cookie.getDomain() != null) {
                        c.setDomain(cookie.getDomain());
                    }
                    if (cookie.getComment() != null) {
                        c.setComment(cookie.getComment());
                    }
                    if (cookie.getPath() != null) {
                        c.setPath(cookie.getPath());
                    }
                    return c;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return cookie;
        }
        return null;
    }

    public static Cookie createCookie(String cookieName, String cookieValue, int age) {
        return CookieUtil.createCookie(cookieName, cookieValue, age, true, false);
    }

    public static Cookie createCookie(String cookieName, String cookieValue, int age, boolean encode) {
        return CookieUtil.createCookie(cookieName, cookieValue, age, encode, false);
    }

    public static Cookie createCookie(String cookieName, String cookieValue, int age, boolean encode, boolean secure) {
        Cookie cookie = null;
        if (encode) {
            try {
                cookie = new Cookie(URLEncoder.encode(cookieName, "UTF-8"), URLEncoder.encode(cookieValue, "UTF-8"));
            }
            catch (Exception e) {
                cookie = new Cookie(cookieName, cookieValue);
            }
        } else {
            cookie = new Cookie(cookieName, cookieValue);
        }
        cookie.setHttpOnly(true);
        cookie.setMaxAge(age);
        cookie.setPath("/");
        cookie.setSecure(secure);
        return cookie;
    }

    public static Cookie createEncryptedCookie(String cookieName, String cookieValue, int age) throws IOException {
        try {
            byte[] ivBytes = new byte[16];
            SECURE_RANDOM.nextBytes(ivBytes);
            byte[] encryptedCookieBytes = Aes256PasswordManager.encrypt((byte[])cookieValue.getBytes(StandardCharsets.UTF_8), (byte[])ivBytes, (byte[])CookieUtil.getEncryptionKey());
            return CookieUtil.createCookie(cookieName, ByteArrayUtil.toHexString((byte[])ivBytes) + ":" + ByteArrayUtil.toHexString((byte[])encryptedCookieBytes), age, false);
        }
        catch (Exception e) {
            throw new IOException("Failed to encrypt cookie value");
        }
    }

    public static String getDecryptedCookieValue(Cookie cookie) throws IOException {
        try {
            String cookieValue = cookie.getValue();
            String[] splitCookie = cookieValue.split(":");
            byte[] ivBytes = ByteArrayUtil.hexStringToBytes((String)splitCookie[0]);
            byte[] cipher = ByteArrayUtil.hexStringToBytes((String)splitCookie[1]);
            return new String(Aes256PasswordManager.decrypt((byte[])CookieUtil.getEncryptionKey(), (byte[])cipher, (byte[])ivBytes), StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            throw new IOException("Failed to decrypt cookie value");
        }
    }

    private static byte[] getEncryptionKey() {
        if (encryptionKey == null) {
            encryptionKey = new byte[32];
            SECURE_RANDOM.nextBytes(encryptionKey);
        }
        return encryptionKey;
    }

    public static Cookie encodeCookie(Cookie cookie) {
        try {
            Cookie newCookie = new Cookie(URLEncoder.encode(cookie.getName(), "UTF-8"), URLEncoder.encode(cookie.getValue(), "UTF-8"));
            newCookie.setComment(cookie.getComment());
            if (cookie.getDomain() != null) {
                newCookie.setDomain(cookie.getDomain());
            }
            newCookie.setHttpOnly(cookie.isHttpOnly());
            newCookie.setMaxAge(cookie.getMaxAge());
            if (cookie.getPath() != null) {
                newCookie.setPath(cookie.getPath());
            }
            newCookie.setSecure(cookie.getSecure());
            newCookie.setVersion(cookie.getVersion());
            return newCookie;
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
    }
}

