/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.web;

import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.web.BClientEnvironment;
import javax.baja.web.BDefaultClientEnvironment;
import javax.baja.web.BWebService;
import javax.baja.web.BWebServlet;
import javax.baja.web.IWebEnv;
import javax.baja.web.WebOp;

public class BClientEnvServlet
extends BWebServlet {
    public static final Property servletName = BClientEnvServlet.newProperty((int)1, (String)"webenv", null);
    public static final Type TYPE = Sys.loadType(BClientEnvServlet.class);

    @Override
    public String getServletName() {
        return this.getString(servletName);
    }

    @Override
    public void setServletName(String v) {
        this.setString(servletName, v, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    @Override
    public void doGet(WebOp op) throws Exception {
        String envId = op.getPathInfo();
        if (envId.length() <= 1) {
            op.getResponse().sendError(404);
            return;
        }
        envId = envId.substring(1);
        IWebEnv webenv = null;
        if (envId.equals("default") || envId.equals("desktop")) {
            op.getRequest().getSession(true).removeAttribute("profileConfig");
            webenv = new BDefaultClientEnvironment().getWebEnv(op);
        } else {
            BWebService web = (BWebService)Sys.getService((Type)BWebService.TYPE);
            BClientEnvironment env = (BClientEnvironment)web.getClientEnvironments().get(envId);
            if (env == null || env.getStatus().isDisabled()) {
                op.getResponse().sendError(404);
                return;
            }
            op.getRequest().getSession(true).removeAttribute("profileConfig");
            webenv = env.getWebEnv(op);
            if (webenv == null) {
                op.getResponse().sendError(404);
                return;
            }
        }
        op.getRequest().getSession(true).setAttribute("webenv", (Object)webenv);
        op.redirectToHome();
    }
}

