/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.email.ui;

import com.tridium.workbench.fieldeditors.BStringFE;
import com.tridium.workbench.fieldeditors.BStringMgrColFE;
import javax.baja.email.BEmailAccount;
import javax.baja.email.BIncomingAccount;
import javax.baja.email.BOutgoingAccount;
import javax.baja.email.BStore;
import javax.baja.email.BTransport;
import javax.baja.registry.TypeInfo;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;
import javax.baja.workbench.BWbEditor;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;
import javax.baja.workbench.mgr.BAbstractManager;
import javax.baja.workbench.mgr.MgrColumn;
import javax.baja.workbench.mgr.MgrEditRow;
import javax.baja.workbench.mgr.MgrModel;
import javax.baja.workbench.mgr.MgrTypeInfo;

public class BEmailAccountManager
extends BAbstractManager {
    public static final Type TYPE = Sys.loadType(BEmailAccountManager.class);
    static Lexicon lex = Lexicon.make((String)"email");
    MgrColumn colName = new MgrColumn.Name(1);
    MgrColumn colEnabled = new MgrColumn.Prop(BEmailAccount.enabled.getDefaultDisplayName(null), BEmailAccount.enabled, 3);
    MgrColumn colProtocol = new EmailProtocol(BOutgoingAccount.transport.getDefaultDisplayName(null), 1);
    MgrColumn colAuth = new EmailAuth(BOutgoingAccount.useAuthentication.getDefaultDisplayName(null), 1);
    MgrColumn colHostName = new MgrColumn.Prop(BEmailAccount.hostname.getDefaultDisplayName(null), BEmailAccount.hostname, 1);
    MgrColumn colPort = new MgrColumn.Prop(BEmailAccount.port.getDefaultDisplayName(null), BEmailAccount.port, 3);
    MgrColumn colAccount = new MgrColumn.Prop(BEmailAccount.account.getDefaultDisplayName(null), BEmailAccount.account, 1);
    MgrColumn colPassword = new MgrColumn.Prop(BEmailAccount.password.getDefaultDisplayName(null), BEmailAccount.password, 3);
    MgrColumn colPollrate = new MgrColumn.Prop(BEmailAccount.pollrate.getDefaultDisplayName(null), BEmailAccount.pollrate, 1);
    MgrColumn colStatus = new MgrColumn.Prop(BEmailAccount.status.getDefaultDisplayName(null), BEmailAccount.status, 4);
    MgrColumn colSsl = new MgrColumn.Prop(BEmailAccount.useSsl.getDefaultDisplayName(null), BEmailAccount.useSsl, 3);
    protected MgrColumn[] cols = new MgrColumn[]{this.colName, this.colEnabled, this.colProtocol, this.colHostName, this.colPort, this.colAuth, this.colAccount, this.colPassword, this.colPollrate, this.colStatus, this.colSsl};

    public Type getType() {
        return TYPE;
    }

    protected MgrModel makeModel() {
        return new Model(this);
    }

    private class EmailAuth
    extends MgrColumn {
        protected EmailAuth(String displayName, int flags) {
            super(displayName, flags);
        }

        public Object get(Object row) {
            if ((BEmailAccount)row instanceof BOutgoingAccount) {
                return BBoolean.make((boolean)((BOutgoingAccount)row).getUseAuthentication());
            }
            if ((BEmailAccount)row instanceof BIncomingAccount) {
                return BBoolean.TRUE;
            }
            return null;
        }

        public BValue load(MgrEditRow row) {
            if ((BEmailAccount)row.getTarget() instanceof BOutgoingAccount) {
                return BBoolean.make((boolean)((BOutgoingAccount)row.getTarget()).getUseAuthentication());
            }
            if ((BEmailAccount)row.getTarget() instanceof BIncomingAccount) {
                return BBoolean.TRUE;
            }
            return null;
        }

        public void save(MgrEditRow row, BValue value, Context cx) {
            if ((BEmailAccount)row.getTarget() instanceof BOutgoingAccount) {
                ((BOutgoingAccount)row.getTarget()).setUseAuthentication(((BBoolean)value).getBoolean());
            }
        }

        public BWbEditor toEditor(MgrEditRow[] rows, int colIndex, BWbEditor currentEditor) throws Exception {
            Context cx;
            boolean editable = false;
            for (int i = 0; i < rows.length; ++i) {
                if (!(rows[i].getTarget() instanceof BOutgoingAccount)) continue;
                editable = true;
                break;
            }
            if (!editable) {
                return null;
            }
            BValue val = rows[0].getCell(colIndex);
            BWbFieldEditor editor = BWbFieldEditor.makeFor((BObject)val, (Context)(cx = rows[0].getManager().getCurrentContext()));
            if (editor instanceof BStringFE) {
                editor = new BStringMgrColFE(colIndex);
            }
            if (currentEditor != null && currentEditor.getClass() == editor.getClass()) {
                editor = (BWbFieldEditor)currentEditor;
            }
            editor.loadValue((BObject)val, cx);
            return editor;
        }

        public void fromEditor(MgrEditRow[] rows, int colIndex, BWbEditor editor) throws Exception {
            BValue val = (BValue)editor.saveValue();
            for (int i = 0; i < rows.length; ++i) {
                if (!(rows[i].getTarget() instanceof BOutgoingAccount)) continue;
                rows[i].setCell(colIndex, val);
            }
        }
    }

    private class EmailProtocol
    extends MgrColumn {
        protected EmailProtocol(String displayName, int flags) {
            super(displayName, flags);
        }

        public Object get(Object row) {
            if ((BEmailAccount)row instanceof BOutgoingAccount) {
                return ((BOutgoingAccount)row).getTransport();
            }
            if ((BEmailAccount)row instanceof BIncomingAccount) {
                return ((BIncomingAccount)row).getStore();
            }
            return null;
        }

        public BValue load(MgrEditRow row) {
            if ((BEmailAccount)row.getTarget() instanceof BOutgoingAccount) {
                return ((BOutgoingAccount)row.getTarget()).getTransport().newCopy();
            }
            if ((BEmailAccount)row.getTarget() instanceof BIncomingAccount) {
                return ((BIncomingAccount)row.getTarget()).getStore().newCopy();
            }
            return null;
        }

        public void save(MgrEditRow row, BValue value, Context cx) {
            if ((BEmailAccount)row.getTarget() instanceof BOutgoingAccount) {
                ((BOutgoingAccount)row.getTarget()).setTransport((BTransport)value);
            } else if ((BEmailAccount)row.getTarget() instanceof BIncomingAccount) {
                ((BIncomingAccount)row.getTarget()).setStore((BStore)value);
            }
        }

        public BWbEditor toEditor(MgrEditRow[] rows, int colIndex, BWbEditor currentEditor) throws Exception {
            Context cx;
            boolean outgoing = false;
            boolean incoming = false;
            for (int i = 0; i < rows.length; ++i) {
                if (rows[i].getTarget() instanceof BOutgoingAccount) {
                    outgoing = true;
                }
                if (!(rows[i].getTarget() instanceof BIncomingAccount)) continue;
                incoming = true;
            }
            if (outgoing && incoming) {
                return null;
            }
            BValue val = rows[0].getCell(colIndex);
            BWbFieldEditor editor = BWbFieldEditor.makeFor((BObject)val, (Context)(cx = rows[0].getManager().getCurrentContext()));
            if (editor instanceof BStringFE) {
                editor = new BStringMgrColFE(colIndex);
            }
            if (currentEditor != null && currentEditor.getClass() == editor.getClass()) {
                editor = (BWbFieldEditor)currentEditor;
            }
            editor.loadValue((BObject)val, cx);
            return editor;
        }

        public void fromEditor(MgrEditRow[] rows, int colIndex, BWbEditor editor) throws Exception {
            BValue val = (BValue)editor.saveValue();
            for (int i = 0; i < rows.length; ++i) {
                rows[i].setCell(colIndex, val);
            }
        }
    }

    class Model
    extends MgrModel {
        Model(BAbstractManager mgr) {
            super(mgr);
        }

        protected String makeTableTitle() {
            return TYPE.getDisplayName(null);
        }

        protected MgrColumn[] makeColumns() {
            return this.appendMixInColumns(BEmailAccountManager.this.cols, BEmailAccount.TYPE);
        }

        public int getSubscribeDepth() {
            return 2;
        }

        public Type[] getIncludeTypes() {
            return new Type[]{BEmailAccount.TYPE};
        }

        public MgrTypeInfo[] getNewTypes() {
            return MgrTypeInfo.makeArray((TypeInfo[])new TypeInfo[]{BOutgoingAccount.TYPE.getTypeInfo(), BIncomingAccount.TYPE.getTypeInfo()});
        }
    }
}

