/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.bacnet.util.worker;

import java.util.ArrayList;
import java.util.List;
import javax.baja.bacnet.util.worker.BBacnetWorkerPool;
import javax.baja.bacnet.util.worker.IBacnetAddress;
import javax.baja.bacnet.util.worker.IWorkerPool;
import javax.baja.bacnet.util.worker.IWorkerPoolAware;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.Context;
import javax.baja.sys.NotRunningException;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.CoalesceQueue;
import javax.baja.util.IFuture;
import javax.baja.util.Queue;
import javax.baja.util.ThreadPoolWorker;
import javax.baja.util.Worker;

public class BBacnetAddressWorkerPool
extends BComponent
implements IWorkerPool {
    private static final int DEFAULT_POOLS = 4;
    private static final int DEFAULT_WORKERS_PER_POOL = 2;
    public static final Property addressPools = BBacnetAddressWorkerPool.newProperty((int)0, (int)4, null);
    public static final Property workersPerAddressPool = BBacnetAddressWorkerPool.newProperty((int)0, (int)2, null);
    public static final Type TYPE = Sys.loadType(BBacnetAddressWorkerPool.class);
    private static final BIcon icon = BIcon.std((String)"gears.png");
    private List<AddressWorker> addressWorkers;
    private Object lock = new Object();

    public int getAddressPools() {
        return this.getInt(addressPools);
    }

    public void setAddressPools(int v) {
        this.setInt(addressPools, v, null);
    }

    public int getWorkersPerAddressPool() {
        return this.getInt(workersPerAddressPool);
    }

    public void setWorkersPerAddressPool(int v) {
        this.setInt(workersPerAddressPool, v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public boolean isParentLegal(BComponent parent) {
        return BBacnetWorkerPool.isLegalParent(parent);
    }

    public void started() {
        this.startPools();
    }

    public void stopped() {
        this.stopPools();
    }

    public void changed(Property p, Context cx) {
        if (!this.isRunning()) {
            return;
        }
        if (p.equals(addressPools) || p.equals(workersPerAddressPool)) {
            this.restartPools();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restartPools() {
        Object object = this.lock;
        synchronized (object) {
            this.stopPools();
            this.startPools();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startPools() {
        Object object = this.lock;
        synchronized (object) {
            int numberOfPools = this.getAddressPools();
            this.addressWorkers = new ArrayList<AddressWorker>(numberOfPools);
            IWorkerPoolAware parent = (IWorkerPoolAware)this.getParent();
            int maxQueueSize = parent.getQueue().maxSize();
            String threadName = parent.getWorkerThreadName();
            for (int i = 0; i < numberOfPools; ++i) {
                CoalesceQueue queue = new CoalesceQueue(maxQueueSize);
                ThreadPoolWorker worker = new ThreadPoolWorker((Worker.ITodo)queue);
                worker.setMaxThreads(this.getWorkersPerAddressPool());
                worker.start(threadName + i);
                this.addressWorkers.add(new AddressWorker(worker, (Queue)queue));
            }
            parent.stopWorker();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopPools() {
        Object object = this.lock;
        synchronized (object) {
            if (this.addressWorkers != null) {
                int numberOfPools = this.addressWorkers.size();
                for (int i = 0; i < numberOfPools; ++i) {
                    AddressWorker aw = this.addressWorkers.get(i);
                    aw.stop();
                }
                this.addressWorkers.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IFuture post(Runnable r) {
        if (!this.isRunning()) {
            throw new NotRunningException();
        }
        Object object = this.lock;
        synchronized (object) {
            if (r instanceof IBacnetAddress) {
                IBacnetAddress request = (IBacnetAddress)((Object)r);
                int workerIdx = request.getAddress().hash() % this.addressWorkers.size();
                AddressWorker aw = this.addressWorkers.get(workerIdx);
                aw.enqueue(r);
            } else if (this.addressWorkers.size() > 0) {
                AddressWorker defaultWorker = this.addressWorkers.get(0);
                defaultWorker.enqueue(r);
            }
        }
        return null;
    }

    public BIcon getIcon() {
        return icon;
    }

    private static class AddressWorker {
        private ThreadPoolWorker worker;
        private Queue queue;

        public AddressWorker(ThreadPoolWorker worker, Queue queue) {
            this.worker = worker;
            this.queue = queue;
        }

        public void stop() {
            if (this.worker != null) {
                this.worker.stop();
            }
        }

        public void enqueue(Runnable r) {
            this.queue.enqueue((Object)r);
        }
    }
}

