/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.bacnet.export;

import com.tridium.bacnet.asn.AsnUtil;
import com.tridium.bacnet.asn.NReadPropertyResult;
import javax.baja.bacnet.BacnetConst;
import javax.baja.bacnet.export.BacnetPropertyList;
import javax.baja.bacnet.io.PropertyValue;

public interface BacnetPropertyListProvider
extends BacnetConst {
    public int[] getPropertyList();

    default public PropertyValue readPropertyList(int ndx) {
        if (ndx == -1) {
            return new NReadPropertyResult(371, ndx, BacnetPropertyList.readAll(this.getPropertyList()));
        }
        if (ndx == 0) {
            byte[] length = AsnUtil.toAsnUnsigned(BacnetPropertyList.size(this.getPropertyList()));
            return new NReadPropertyResult(371, ndx, length);
        }
        if (ndx > BacnetPropertyList.size(this.getPropertyList())) {
            return BacnetPropertyList.getInvalidIdx(371, ndx);
        }
        try {
            int propId = BacnetPropertyList.read(ndx, this.getPropertyList());
            return new NReadPropertyResult(371, ndx, AsnUtil.toAsnEnumerated(propId));
        }
        catch (Exception e) {
            return BacnetPropertyList.getInvalidIdx(371, ndx);
        }
    }
}

