/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.bacnet.export;

import com.tridium.bacnet.ObjectTypeList;
import com.tridium.bacnet.asn.AsnInputStream;
import com.tridium.bacnet.asn.NBacnetPropertyReference;
import com.tridium.bacnet.asn.NBacnetPropertyValue;
import com.tridium.bacnet.asn.NErrorType;
import com.tridium.bacnet.history.BBacnetBitStringTrendLogExt;
import com.tridium.bacnet.history.BBacnetBitStringTrendLogRemoteExt;
import com.tridium.bacnet.history.BBacnetBooleanTrendLogExt;
import com.tridium.bacnet.history.BBacnetBooleanTrendLogRemoteExt;
import com.tridium.bacnet.history.BBacnetEnumTrendLogExt;
import com.tridium.bacnet.history.BBacnetEnumTrendLogRemoteExt;
import com.tridium.bacnet.history.BBacnetNumericTrendLogExt;
import com.tridium.bacnet.history.BBacnetNumericTrendLogRemoteExt;
import com.tridium.bacnet.history.BBacnetStringTrendLogExt;
import com.tridium.bacnet.history.BBacnetStringTrendLogRemoteExt;
import com.tridium.bacnet.history.BBacnetTrendLogAlarmSourceExt;
import com.tridium.bacnet.history.BBacnetTrendLogRemoteExt;
import com.tridium.bacnet.history.BIBacnetTrendLogExt;
import com.tridium.bacnet.stack.server.BBacnetExportTable;
import java.util.ArrayList;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.baja.bacnet.BBacnetDevice;
import javax.baja.bacnet.BBacnetNetwork;
import javax.baja.bacnet.BacnetException;
import javax.baja.bacnet.datatypes.BBacnetDeviceObjectPropertyReference;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.datatypes.BBacnetObjectPropertyReference;
import javax.baja.bacnet.enums.BBacnetObjectType;
import javax.baja.bacnet.enums.BBacnetPropertyIdentifier;
import javax.baja.bacnet.export.BBacnetTrendLogDescriptor;
import javax.baja.bacnet.export.BIBacnetExportObject;
import javax.baja.bacnet.export.BLocalBacnetDevice;
import javax.baja.bacnet.export.extensions.BBacnetRemoteUnsignedPropertyExt;
import javax.baja.bacnet.export.extensions.BBacnetUnsignedPropertyExt;
import javax.baja.bacnet.io.PropertyValue;
import javax.baja.bacnet.io.RejectException;
import javax.baja.bacnet.point.BBacnetBooleanProxyExt;
import javax.baja.bacnet.point.BBacnetEnumProxyExt;
import javax.baja.bacnet.point.BBacnetNumericProxyExt;
import javax.baja.bacnet.point.BBacnetProxyExt;
import javax.baja.bacnet.point.BBacnetStringProxyExt;
import javax.baja.bacnet.util.PropertyInfo;
import javax.baja.control.BBooleanPoint;
import javax.baja.control.BBooleanWritable;
import javax.baja.control.BControlPoint;
import javax.baja.control.BEnumPoint;
import javax.baja.control.BEnumWritable;
import javax.baja.control.BNumericPoint;
import javax.baja.control.BNumericWritable;
import javax.baja.control.BStringPoint;
import javax.baja.control.BStringWritable;
import javax.baja.control.ext.BAbstractProxyExt;
import javax.baja.control.ext.BDiscreteTotalizerExt;
import javax.baja.history.BHistoryConfig;
import javax.baja.history.BHistoryId;
import javax.baja.history.BHistoryService;
import javax.baja.history.HistorySpaceConnection;
import javax.baja.history.ext.BHistoryExt;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.status.BStatusNumeric;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnum;
import javax.baja.sys.BFacets;
import javax.baja.sys.BLink;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Knob;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BFolder;

public class BacnetDescriptorUtil {
    private static final Pattern FORWARD_SLASH_PATTERN = Pattern.compile("/");
    private static final Logger logger = Logger.getLogger("bacnet.export.object.util");
    private static final BComponent[] EMPTY_COMPONENT_ARRAY = new BComponent[0];
    private static String DISCRETE_TOTALIZER_EXT = "DiscreteTotalizerExtension";

    static BComponent parseLogDeviceObjectProperty(PropertyValue pv, BBacnetDeviceObjectPropertyReference dopr) throws Exception {
        BBacnetDeviceObjectPropertyReference deviceObjectPropertyReference;
        BComponent point = null;
        if (pv != null) {
            deviceObjectPropertyReference = new BBacnetDeviceObjectPropertyReference();
            deviceObjectPropertyReference.setDeviceId(BBacnetObjectIdentifier.make(8, -1));
            deviceObjectPropertyReference.readAsn(new AsnInputStream(pv.getPropertyValue()));
        } else {
            deviceObjectPropertyReference = dopr;
        }
        if (BacnetDescriptorUtil.isValidDeviceObjectPropertyReference(deviceObjectPropertyReference)) {
            point = BacnetDescriptorUtil.findLocalOrRemotePoint(deviceObjectPropertyReference);
        }
        return point;
    }

    static boolean isValidDeviceObjectPropertyReference(BBacnetDeviceObjectPropertyReference dopr) {
        return dopr != null && dopr.getPropertyId() >= 0 && dopr.getObjectId().getInstanceNumber() >= 0 && dopr.getDeviceId().getInstanceNumber() >= -1;
    }

    static boolean isLocalDeviceID(int deviceNum) {
        if (deviceNum == -1) {
            return true;
        }
        BLocalBacnetDevice localDevice = BBacnetNetwork.localDevice();
        int localDeviceNum = localDevice.getObjectId().getInstanceNumber();
        return localDeviceNum == deviceNum;
    }

    static BComponent findLocalOrRemotePoint(BBacnetDeviceObjectPropertyReference objectPropRef) throws Exception {
        int deviceNum = objectPropRef.getDeviceId().getInstanceNumber();
        if (BacnetDescriptorUtil.isLocalDeviceID(deviceNum)) {
            return BacnetDescriptorUtil.findLocalPoint(objectPropRef);
        }
        return BacnetDescriptorUtil.findRemotePoint(objectPropRef);
    }

    private static BComponent findLocalPoint(BBacnetDeviceObjectPropertyReference objPropRef) throws Exception {
        return BacnetDescriptorUtil.findLocalPoint(objPropRef.getObjectId(), objPropRef.getPropertyId(), objPropRef.getPropertyArrayIndex());
    }

    static BComponent findLocalPoint(BBacnetObjectPropertyReference objPropRef) throws Exception {
        return BacnetDescriptorUtil.findLocalPoint(objPropRef.getObjectId(), objPropRef.getPropertyId(), objPropRef.getPropertyArrayIndex());
    }

    private static BComponent findLocalPoint(BBacnetObjectIdentifier objectId, int propertyId, int propertyArrayIndex) throws Exception {
        BIBacnetExportObject exportObject = BBacnetNetwork.localDevice().lookupBacnetObject(objectId);
        if (exportObject == null) {
            throw new Exception("Could not find a local BACnet export object with ID " + (Object)((Object)objectId));
        }
        BOrd exportObjectOrd = exportObject.getObjectOrd();
        if (exportObjectOrd.isNull()) {
            throw new Exception("ObjectOrd is null for local BACnet object with ID " + (Object)((Object)objectId));
        }
        BComponent point = (BComponent)exportObjectOrd.resolve((BObject)Sys.getStation()).get();
        if (propertyId == 33) {
            point = BacnetDescriptorUtil.getPointForElapsedActiveTime(objectId, propertyArrayIndex, point);
        }
        return point;
    }

    private static BComponent getPointForElapsedActiveTime(BBacnetObjectIdentifier objectId, int propertyIndex, BComponent point) {
        BDiscreteTotalizerExt extension;
        BDiscreteTotalizerExt[] extensions = (BDiscreteTotalizerExt[])point.getChildren(BDiscreteTotalizerExt.class);
        BControlPoint linkedPoint = null;
        if (extensions.length > 0) {
            extension = extensions[0];
            extension.setEaTimeUpdateInterval(BRelTime.make((long)1000L));
            linkedPoint = BacnetDescriptorUtil.getNumericPointLinkedToDiscreteTotExt(objectId, extension);
        } else {
            extension = BacnetDescriptorUtil.addDiscreteTotalizerExtToPoint(point);
        }
        if (linkedPoint == null) {
            linkedPoint = BacnetDescriptorUtil.addPropertyPoint(null, objectId, 33, propertyIndex);
            BacnetDescriptorUtil.linkToNumericPoint(extension, linkedPoint);
        }
        return linkedPoint;
    }

    private static void linkToNumericPoint(BDiscreteTotalizerExt extension, BControlPoint linkedPoint) {
        try {
            BControlPoint divide;
            BValue divideCheckVar = linkedPoint.get("divide");
            if (divideCheckVar == null) {
                Class divideClass = Sys.loadClass((String)"kitControl", (String)"com.tridium.kitControl.math.BDivide");
                divide = (BControlPoint)divideClass.newInstance();
                divide.set("inB", (BValue)new BStatusNumeric(1000.0));
                linkedPoint.add("divide", (BValue)divide);
            } else {
                divide = (BControlPoint)divideCheckVar;
            }
            BLink linkToDivide = new BLink(extension.getHandleOrd(), BDiscreteTotalizerExt.elapsedActiveTimeNumeric.getName(), "inA", true);
            divide.add(null, (BValue)linkToDivide, BLocalBacnetDevice.getBacnetContext());
            BLink link = new BLink(divide.getHandleOrd(), "out", BNumericWritable.in16.getName(), true);
            linkedPoint.add(null, (BValue)link, BLocalBacnetDevice.getBacnetContext());
        }
        catch (ClassNotFoundException e) {
            BacnetDescriptorUtil.removePoint(linkedPoint);
            logger.severe("Class BDivide is not found or kitControl module is not found " + e.getMessage());
        }
        catch (IllegalAccessException | InstantiationException e) {
            BacnetDescriptorUtil.removePoint(linkedPoint);
            logger.severe("Exception while creating instance of divide" + e.getMessage());
        }
    }

    private static BDiscreteTotalizerExt addDiscreteTotalizerExtToPoint(BComponent point) {
        BDiscreteTotalizerExt discreteTotalizerExt = new BDiscreteTotalizerExt();
        discreteTotalizerExt.setEaTimeUpdateInterval(BRelTime.make((long)1000L));
        point.add(DISCRETE_TOTALIZER_EXT + "?", (BValue)discreteTotalizerExt);
        return discreteTotalizerExt;
    }

    private static BControlPoint getNumericPointLinkedToDiscreteTotExt(BBacnetObjectIdentifier objectId, BDiscreteTotalizerExt extension) {
        BControlPoint existingPoint = null;
        Knob[] knobs = extension.getKnobs((Slot)BDiscreteTotalizerExt.elapsedActiveTimeNumeric);
        ArrayList<BComponent> components = new ArrayList<BComponent>();
        for (int j = 0; j < knobs.length; ++j) {
            components.add(knobs[j].getTargetComponent().getParent().getParentComponent());
        }
        if (components.size() > 0) {
            existingPoint = (BControlPoint)BacnetDescriptorUtil.findPoint(components.toArray(EMPTY_COMPONENT_ARRAY), objectId);
        }
        return existingPoint;
    }

    private static BControlPoint findRemotePoint(BBacnetDeviceObjectPropertyReference objPropRef) {
        int propertyIndex;
        int propertyId;
        BBacnetDevice device = BacnetDescriptorUtil.retrieveRemoteDevice(objPropRef.getDeviceId());
        if (device == null) {
            return null;
        }
        BBacnetObjectIdentifier objectId = objPropRef.getObjectId();
        BObject object = BacnetDescriptorUtil.findRemotePoint(device, objectId, propertyId = objPropRef.getPropertyId(), propertyIndex = objPropRef.getPropertyArrayIndex(), "point");
        if (object == null) {
            object = BacnetDescriptorUtil.addPropertyPoint(device, objectId, propertyId, propertyIndex);
        }
        return object instanceof BControlPoint ? (BControlPoint)object : null;
    }

    private static BObject findRemotePoint(BBacnetDevice device, BBacnetObjectIdentifier objectId, int propertyId, int propertyArrayIndex, String objectContainer) {
        BComponent[] remotePoints;
        BObject object;
        if (propertyId == 33 && (object = BacnetDescriptorUtil.findPoint(remotePoints = device.getPoints().getChildComponents(), objectId)) != null) {
            return object;
        }
        return device.lookupBacnetObject(objectId, propertyId, propertyArrayIndex, objectContainer);
    }

    private static BObject findPoint(BComponent[] points, BBacnetObjectIdentifier objectId) {
        if (points == null) {
            return null;
        }
        for (BComponent point : points) {
            BBacnetUnsignedPropertyExt[] extensions;
            for (BBacnetUnsignedPropertyExt ext : extensions = (BBacnetUnsignedPropertyExt[])point.getChildren(BBacnetUnsignedPropertyExt.class)) {
                if (ext.getPropertyId() != 33 || !ext.getObjectId().equivalent((Object)objectId)) continue;
                return point;
            }
        }
        return null;
    }

    private static BControlPoint addPropertyPoint(BBacnetDevice device, BBacnetObjectIdentifier objectId, int propertyId, int propertyArrayIndex) {
        try {
            BControlPoint point = BacnetDescriptorUtil.makePropertyPoint(device, objectId, propertyId, propertyArrayIndex);
            String name = BacnetDescriptorUtil.makePointName(objectId, propertyId, propertyArrayIndex);
            if (device == null) {
                BComponent dynamicPointsFolder = (BComponent)BBacnetNetwork.bacnet().get("dynamicPoints");
                if (dynamicPointsFolder == null) {
                    dynamicPointsFolder = new BFolder();
                    BBacnetNetwork.bacnet().add("dynamicPoints", (BValue)dynamicPointsFolder, 5);
                }
                dynamicPointsFolder.add(SlotPath.escape((String)name), (BValue)point);
            } else {
                device.getPoints().add(SlotPath.escape((String)name), (BValue)point);
            }
            return point;
        }
        catch (Exception e) {
            logger.severe("Could not add point for property " + propertyId + " on device " + device + "; " + e.getMessage());
            return null;
        }
    }

    private static String makePointName(BBacnetObjectIdentifier objectId, int propertyId, int propertyArrayIndex) {
        StringBuilder pointName = new StringBuilder(objectId.toString());
        if (propertyId != 85) {
            pointName.append('-').append(BBacnetPropertyIdentifier.tag(propertyId));
        }
        if (propertyArrayIndex > 0) {
            pointName.append('_').append(propertyArrayIndex);
        }
        return FORWARD_SLASH_PATTERN.matcher(pointName.toString()).replaceAll(".");
    }

    private static void removePoint(BControlPoint point) {
        if (null == BBacnetNetwork.bacnet().get("dynamicPoints")) {
            BBacnetNetwork.bacnet().get("dynamicPoints").asComponent().remove(point.getName());
        }
    }

    private static BBacnetDevice retrieveRemoteDevice(BBacnetObjectIdentifier deviceId) {
        BBacnetNetwork network = BBacnetNetwork.bacnet();
        BBacnetDevice device = network.lookupDeviceById(deviceId);
        if (device == null) {
            device = BacnetDescriptorUtil.addDevice(deviceId.getInstanceNumber());
        }
        return device;
    }

    private static BBacnetDevice addDevice(int instanceNum) {
        BBacnetObjectIdentifier id = BBacnetObjectIdentifier.make(8, instanceNum);
        BBacnetDevice device = new BBacnetDevice();
        device.setObjectId(id, null);
        BBacnetNetwork.bacnet().add(null, (BValue)device);
        return device;
    }

    private static BControlPoint addPointForElapsedActiveTime(BBacnetObjectIdentifier bOid, boolean isLocal) {
        BNumericWritable point = new BNumericWritable();
        BBacnetUnsignedPropertyExt extension = null;
        extension = isLocal ? new BBacnetUnsignedPropertyExt(bOid, 33) : new BBacnetRemoteUnsignedPropertyExt(bOid, 33);
        point.add("ElapsedActiveTimeExtension?", (BValue)extension);
        return point;
    }

    private static BControlPoint makePropertyPoint(BBacnetDevice device, BBacnetObjectIdentifier objectId, int propertyId, int propertyArrayIndex) throws BacnetException {
        if (propertyId == 33) {
            return BacnetDescriptorUtil.addPointForElapsedActiveTime(objectId, device == null);
        }
        int objectType = objectId.getObjectType();
        PropertyInfo propInfo = device.getPropertyInfo(objectType, propertyId);
        if (propInfo == null) {
            throw new BacnetException("BACnet property information not found when making a property point; object type: " + BBacnetObjectType.tag(objectType) + ", property ID: " + BBacnetPropertyIdentifier.tag(propertyId));
        }
        BControlPoint point = BacnetDescriptorUtil.makePointForPropertyInfo(objectType, propInfo);
        BBacnetProxyExt ext = (BBacnetProxyExt)point.getProxyExt();
        ext.setDeviceFacets((BFacets)point.getFacets().newCopy());
        ext.setDataType(propInfo.getDataType());
        ext.setObjectId(objectId);
        ext.setPropertyId(BDynamicEnum.make((BEnum)BBacnetPropertyIdentifier.make(propertyId)));
        ext.setPropertyArrayIndex(propertyArrayIndex);
        ext.setEnabled(true);
        return point;
    }

    private static BControlPoint makePointForPropertyInfo(int objectType, PropertyInfo propInfo) throws BacnetException {
        switch (propInfo.getAsnType()) {
            case 0: {
                return BacnetDescriptorUtil.makeBacnetStringWritable();
            }
            case 1: {
                return BacnetDescriptorUtil.makeBacnetBooleanWritable();
            }
            case 2: {
                return BacnetDescriptorUtil.isMultiStatePresentValue(propInfo.getId(), objectType) ? BacnetDescriptorUtil.makeBacnetEnumWritable() : BacnetDescriptorUtil.makeBacnetNumericWritable();
            }
            case 3: 
            case 4: 
            case 5: {
                return BacnetDescriptorUtil.makeBacnetNumericWritable();
            }
            case 6: 
            case 7: 
            case 8: {
                return BacnetDescriptorUtil.makeBacnetStringWritable();
            }
            case 9: {
                return propInfo.getType().equals("bacnet:BacnetBinaryPv") ? BacnetDescriptorUtil.makeBacnetBooleanWritable() : BacnetDescriptorUtil.makeBacnetEnumWritable();
            }
            case -6: 
            case -5: 
            case -4: 
            case -3: 
            case -2: 
            case -1: 
            case 10: 
            case 11: 
            case 12: {
                return BacnetDescriptorUtil.makeBacnetStringWritable();
            }
        }
        throw new BacnetException("BACnet property type " + BBacnetPropertyIdentifier.tag(objectType) + " is not supported when making a property point");
    }

    private static BBooleanWritable makeBacnetBooleanWritable() {
        BBooleanWritable booleanWritable = new BBooleanWritable();
        booleanWritable.setProxyExt((BAbstractProxyExt)new BBacnetBooleanProxyExt());
        return booleanWritable;
    }

    private static BNumericWritable makeBacnetNumericWritable() {
        BNumericWritable numericWritable = new BNumericWritable();
        numericWritable.setProxyExt((BAbstractProxyExt)new BBacnetNumericProxyExt());
        return numericWritable;
    }

    private static BEnumWritable makeBacnetEnumWritable() {
        BEnumWritable enumWritable = new BEnumWritable();
        enumWritable.setProxyExt((BAbstractProxyExt)new BBacnetEnumProxyExt());
        return enumWritable;
    }

    private static BStringWritable makeBacnetStringWritable() {
        BStringWritable stringWritable = new BStringWritable();
        stringWritable.setProxyExt((BAbstractProxyExt)new BBacnetStringProxyExt());
        return stringWritable;
    }

    private static boolean isMultiStatePresentValue(int propertyId, int objectType) {
        return propertyId == 85 && (objectType == 13 || objectType == 14 || objectType == 19);
    }

    static boolean isEqual(BBacnetDeviceObjectPropertyReference dopr1, BBacnetDeviceObjectPropertyReference dopr2) {
        if (dopr1 == null && dopr2 == null) {
            return true;
        }
        if (dopr1 == null || dopr2 == null) {
            return false;
        }
        if (dopr1.isNull() && dopr2.isNull()) {
            return true;
        }
        return dopr1.getDeviceId().getInstanceNumber() == dopr2.getDeviceId().getInstanceNumber() && dopr1.getObjectId().getObjectType() == dopr2.getObjectId().getObjectType() && dopr1.getObjectId().getInstanceNumber() == dopr2.getObjectId().getInstanceNumber() && dopr1.getPropertyId() == dopr2.getPropertyId() && dopr1.getPropertyArrayIndex() == dopr2.getPropertyArrayIndex();
    }

    static boolean areTrendLogAndPointCompatible(BControlPoint point, BIBacnetTrendLogExt trendLogExt, BBacnetDeviceObjectPropertyReference objPropRef) {
        PropertyInfo propInfo = ObjectTypeList.getInstance().getPropertyInfo(objPropRef.getObjectId().getObjectType(), objPropRef.getPropertyId());
        if (propInfo != null && propInfo.isBitString()) {
            return trendLogExt instanceof BBacnetBitStringTrendLogExt || trendLogExt instanceof BBacnetBitStringTrendLogRemoteExt;
        }
        if (point instanceof BNumericPoint) {
            return trendLogExt instanceof BBacnetNumericTrendLogExt || trendLogExt instanceof BBacnetNumericTrendLogRemoteExt;
        }
        if (point instanceof BStringPoint) {
            return trendLogExt instanceof BBacnetStringTrendLogExt || trendLogExt instanceof BBacnetStringTrendLogRemoteExt;
        }
        if (point instanceof BBooleanPoint) {
            return trendLogExt instanceof BBacnetBooleanTrendLogExt || trendLogExt instanceof BBacnetBooleanTrendLogRemoteExt;
        }
        if (point instanceof BEnumPoint) {
            return trendLogExt instanceof BBacnetEnumTrendLogExt || trendLogExt instanceof BBacnetEnumTrendLogRemoteExt;
        }
        return false;
    }

    static BIBacnetTrendLogExt copy(BIBacnetExportObject descriptor, BBacnetDeviceObjectPropertyReference dopr, PropertyValue[] initialPVs) throws BacnetException {
        try {
            int objectType = descriptor.getObjectId().getObjectType();
            switch (objectType) {
                case 20: {
                    return BacnetDescriptorUtil.copyTrendLogProperties(descriptor, dopr, initialPVs);
                }
            }
        }
        catch (BacnetException e) {
            throw e;
        }
        catch (Exception e) {
            logger.severe("Could not copy the trend log ext");
        }
        return null;
    }

    private static BIBacnetTrendLogExt copyTrendLogProperties(BIBacnetExportObject descriptor, BBacnetDeviceObjectPropertyReference dopr, PropertyValue[] initialPVs) throws Exception {
        BControlPoint point;
        BIBacnetTrendLogExt trendLogExt = BacnetDescriptorUtil.decideTrendLogExtension(dopr);
        BComponent component = BacnetDescriptorUtil.parseLogDeviceObjectProperty(null, dopr);
        BControlPoint bControlPoint = point = component instanceof BControlPoint ? (BControlPoint)component : null;
        if (point != null && trendLogExt != null) {
            BHistoryExt historyExt = (BHistoryExt)trendLogExt;
            BacnetDescriptorUtil.deleteOrd(descriptor);
            point.add("TrendLog" + descriptor.getObjectId().getInstanceNumber(), (BValue)((BComponent)trendLogExt));
            BOrd newOrd = ((BComponent)trendLogExt).getHandleOrd();
            descriptor.setObjectOrd(newOrd, null);
            ((BBacnetTrendLogDescriptor)descriptor).getLog(true);
            for (PropertyValue pv : initialPVs) {
                if (pv instanceof NErrorType) continue;
                byte[] value = pv.getPropertyValue();
                int propertyId = pv.getPropertyId();
                NBacnetPropertyValue bpv = new NBacnetPropertyValue(propertyId, value);
                descriptor.writeProperty(bpv);
            }
        }
        return trendLogExt;
    }

    private static void deleteOrd(BIBacnetExportObject descriptor) {
        BOrd ord = descriptor.getObjectOrd();
        if (!ord.isNull()) {
            BComponent tle = ord.resolve((BObject)Sys.getStation()).get().asComponent();
            BComponent parent = tle.getParent().asComponent();
            parent.remove(tle.getName());
        }
    }

    static void removeHistory(BIBacnetExportObject descriptor, boolean rename) {
        BOrd ord = descriptor.getObjectOrd();
        if (!ord.isNull()) {
            BComponent tle = ord.resolve((BObject)Sys.getStation()).get().asComponent();
            BHistoryExt historyExt = (BHistoryExt)tle;
            BHistoryConfig config = historyExt.getHistoryConfig();
            BHistoryService historyService = (BHistoryService)Sys.getService((Type)BHistoryService.TYPE);
            HistorySpaceConnection conn = historyService.getDatabase().getConnection(BLocalBacnetDevice.getBacnetContext());
            BHistoryId historyId = config.getId();
            if (rename) {
                BacnetDescriptorUtil.removeHistory(descriptor, false);
            } else if (conn.exists(historyId)) {
                conn.clearAllRecords(config.getId());
            }
        }
    }

    static PropertyValue[] getValuesWrittenToTrendExtension(BIBacnetExportObject descriptor) throws RejectException {
        return descriptor.readPropertyMultiple(new NBacnetPropertyReference[]{new NBacnetPropertyReference(142), new NBacnetPropertyReference(143), new NBacnetPropertyReference(127), new NBacnetPropertyReference(128), new NBacnetPropertyReference(134), new NBacnetPropertyReference(144), new NBacnetPropertyReference(141), new NBacnetPropertyReference(72), new NBacnetPropertyReference(17), new NBacnetPropertyReference(137), new NBacnetPropertyReference(35)});
    }

    static BIBacnetTrendLogExt decideTrendLogExtension(BBacnetDeviceObjectPropertyReference dopr) throws BacnetException {
        int propertyId = dopr.getPropertyId();
        BIBacnetTrendLogExt trendLog = null;
        trendLog = propertyId == 85 ? BacnetDescriptorUtil.decideTrendLogExtensionOnPresentValue(dopr) : BacnetDescriptorUtil.decideTrendLogExtensionOnOtherProperties(dopr);
        if (trendLog == null) {
            throw new BacnetException("Could not copy the trend log ext.");
        }
        BBacnetTrendLogAlarmSourceExt almExt = new BBacnetTrendLogAlarmSourceExt();
        ((BComponent)trendLog).add(almExt.getName(), (BValue)almExt);
        return trendLog;
    }

    private static BIBacnetTrendLogExt decideTrendLogExtensionOnOtherProperties(BBacnetDeviceObjectPropertyReference dopr) {
        BBacnetNetwork network = BBacnetNetwork.bacnet();
        BBacnetObjectIdentifier deviceId = dopr.getDeviceId();
        BBacnetDevice device = network.lookupDeviceById(deviceId);
        int deviceInstanceNumber = deviceId.getInstanceNumber();
        BBacnetObjectIdentifier objectId = dopr.getObjectId();
        int objectType = dopr.getObjectId().getObjectType();
        int arrayIndex = dopr.getPropertyArrayIndex();
        int propertyId = dopr.getPropertyId();
        boolean isLocal = BacnetDescriptorUtil.isLocalDeviceID(deviceInstanceNumber);
        switch (propertyId) {
            case 81: {
                return !isLocal ? new BBacnetBooleanTrendLogRemoteExt(device, objectId, propertyId, -1) : null;
            }
            case 87: {
                switch (objectType) {
                    case 1: {
                        return !isLocal ? new BBacnetNumericTrendLogRemoteExt(device, objectId, propertyId, arrayIndex) : null;
                    }
                    case 4: {
                        return !isLocal ? new BBacnetBooleanTrendLogRemoteExt(device, objectId, propertyId, arrayIndex) : null;
                    }
                    case 40: {
                        return !isLocal ? new BBacnetStringTrendLogRemoteExt(device, objectId, propertyId, arrayIndex) : null;
                    }
                    case 14: {
                        return !isLocal ? new BBacnetEnumTrendLogRemoteExt(device, objectId, propertyId, arrayIndex) : null;
                    }
                }
                break;
            }
            case 111: {
                return !isLocal ? new BBacnetBitStringTrendLogRemoteExt(device, objectId, propertyId, arrayIndex) : new BBacnetBitStringTrendLogExt();
            }
        }
        return null;
    }

    private static BIBacnetTrendLogExt decideTrendLogExtensionOnPresentValue(BBacnetDeviceObjectPropertyReference dopr) {
        BBacnetObjectIdentifier objectId = dopr.getObjectId();
        int objectType = objectId.getObjectType();
        int propertyId = dopr.getPropertyId();
        int arrayIndex = dopr.getPropertyArrayIndex();
        BBacnetObjectIdentifier deviceId = dopr.getDeviceId();
        int deviceInstanceNumber = deviceId.getInstanceNumber();
        boolean isLocal = BacnetDescriptorUtil.isLocalDeviceID(deviceInstanceNumber);
        BIBacnetTrendLogExt trendLog = null;
        if (isLocal) {
            switch (objectType) {
                case 0: 
                case 1: 
                case 2: 
                case 45: 
                case 48: {
                    trendLog = new BBacnetNumericTrendLogExt();
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    trendLog = new BBacnetBooleanTrendLogExt();
                    break;
                }
                case 40: {
                    trendLog = new BBacnetStringTrendLogExt();
                    break;
                }
                case 13: 
                case 14: 
                case 19: {
                    trendLog = new BBacnetEnumTrendLogExt();
                }
            }
        } else {
            BBacnetNetwork network = BBacnetNetwork.bacnet();
            BBacnetDevice device = network.lookupDeviceById(deviceId);
            switch (objectType) {
                case 0: 
                case 1: 
                case 2: 
                case 45: 
                case 48: {
                    trendLog = new BBacnetNumericTrendLogRemoteExt(device, objectId, propertyId, arrayIndex);
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    trendLog = new BBacnetBooleanTrendLogRemoteExt(device, objectId, propertyId, arrayIndex);
                    break;
                }
                case 40: {
                    trendLog = new BBacnetStringTrendLogRemoteExt(device, objectId, propertyId, arrayIndex);
                    break;
                }
                case 13: 
                case 14: 
                case 19: {
                    trendLog = new BBacnetEnumTrendLogRemoteExt(device, objectId, propertyId, arrayIndex);
                }
            }
        }
        return trendLog;
    }

    public static boolean isGenericTrendLogExtension(BIBacnetTrendLogExt ext) {
        return ext instanceof BBacnetNumericTrendLogExt || ext instanceof BBacnetStringTrendLogExt || ext instanceof BBacnetEnumTrendLogExt || ext instanceof BBacnetBooleanTrendLogExt || ext instanceof BBacnetTrendLogRemoteExt;
    }

    public static BBacnetObjectIdentifier nextObjectIdentifier(int objectType) {
        BBacnetExportTable et = BacnetDescriptorUtil.exportTable();
        for (int i = 0; i < 0x3FFFFE; ++i) {
            BBacnetObjectIdentifier oid = BBacnetObjectIdentifier.make(objectType, i);
            if (et.byObjectId(oid) != null) continue;
            return oid;
        }
        return null;
    }

    public static BBacnetExportTable exportTable() {
        return (BBacnetExportTable)BBacnetNetwork.localDevice().getExportTable();
    }
}

