/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.bacnet.export;

import com.tridium.bacnet.asn.AsnInputStream;
import com.tridium.bacnet.asn.AsnOutputStream;
import com.tridium.bacnet.asn.AsnUtil;
import java.util.Vector;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.enums.BBacnetObjectType;
import javax.baja.bacnet.enums.BBacnetPropertyIdentifier;
import javax.baja.bacnet.enums.BBacnetReliability;
import javax.baja.bacnet.export.BBacnetAnalogWritableDescriptor;
import javax.baja.bacnet.io.AsnException;
import javax.baja.status.BStatus;
import javax.baja.sys.BEnum;
import javax.baja.sys.BFacets;
import javax.baja.sys.BNumber;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BBacnetPositiveIntegerValuePrioritizedDescriptor
extends BBacnetAnalogWritableDescriptor {
    public static final Property objectId = BBacnetPositiveIntegerValuePrioritizedDescriptor.newProperty((int)64, (BValue)BBacnetObjectIdentifier.make(48));
    public static final Type TYPE = Sys.loadType(BBacnetPositiveIntegerValuePrioritizedDescriptor.class);

    @Override
    public Type getType() {
        return TYPE;
    }

    @Override
    protected final void validate() {
        super.validate();
        BNumber min = (BNumber)this.getPoint().getFacets().getFacet("min");
        if (min != null && this.setFaultOnOutOfRangeValue(min)) {
            this.setFaultCause(lex.getText("export.configurationFault.postiveIntergerValue.minValue", new Object[]{0L, 0xFFFFFFFFL}));
            return;
        }
        BNumber max = (BNumber)this.getPoint().getFacets().getFacet("max");
        if (max != null && this.setFaultOnOutOfRangeValue(max)) {
            this.setFaultCause(lex.getText("export.configurationFault.postiveIntergerValue.maxValue", new Object[]{0L, 0xFFFFFFFFL}));
            return;
        }
    }

    private boolean setFaultOnOutOfRangeValue(BNumber min) {
        if (min.getLong() < 0L || min.getLong() > 0xFFFFFFFFL) {
            this.setReliability((BEnum)BBacnetReliability.unreliableOther);
            this.setStatus(BStatus.makeFault((BStatus)this.getStatus(), (boolean)true));
            return true;
        }
        return false;
    }

    @Override
    public int asnType() {
        return 2;
    }

    @Override
    public byte[] convertToAsn(double value) {
        return AsnUtil.toAsnUnsigned((long)value);
    }

    @Override
    public double convertFromAsn(byte[] value) throws AsnException {
        return AsnUtil.fromAsnUnsignedInteger(value);
    }

    @Override
    public void appendToAsn(AsnOutputStream out, double value) {
        out.writeUnsignedInteger((long)value);
    }

    @Override
    public double readFromAsn(AsnInputStream in) throws AsnException {
        return in.readUnsignedInteger();
    }

    @Override
    protected void addRequiredProps(Vector v) {
        super.addRequiredProps(v);
        v.remove(BBacnetPropertyIdentifier.outOfService);
        v.remove(BBacnetPropertyIdentifier.priorityArray);
        v.remove(BBacnetPropertyIdentifier.relinquishDefault);
        v.remove(BBacnetPropertyIdentifier.eventState);
    }

    @Override
    protected void addOptionalProps(Vector v) {
        super.addOptionalProps(v);
        v.add(BBacnetPropertyIdentifier.outOfService);
        v.add(BBacnetPropertyIdentifier.priorityArray);
        v.add(BBacnetPropertyIdentifier.relinquishDefault);
        v.add(BBacnetPropertyIdentifier.eventState);
    }

    public final BFacets getSlotFacets(Slot s) {
        if (s == objectId) {
            return BBacnetObjectType.getObjectIdFacets(48);
        }
        return super.getSlotFacets(s);
    }
}

