/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.bacnet.export;

import com.tridium.bacnet.asn.AsnUtil;
import com.tridium.bacnet.asn.NErrorType;
import com.tridium.bacnet.asn.NReadPropertyResult;
import com.tridium.bacnet.services.confirmed.ReadRangeAck;
import java.util.Vector;
import javax.baja.alarm.BIAlarmSource;
import javax.baja.alarm.ext.BAlarmSourceExt;
import javax.baja.alarm.ext.offnormal.BEnumCommandFailureAlgorithm;
import javax.baja.bacnet.BacnetException;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.enums.BBacnetEventType;
import javax.baja.bacnet.enums.BBacnetObjectType;
import javax.baja.bacnet.enums.BBacnetPropertyIdentifier;
import javax.baja.bacnet.export.BBacnetMultiStateWritableDescriptor;
import javax.baja.bacnet.export.BLocalBacnetDevice;
import javax.baja.bacnet.io.ErrorType;
import javax.baja.bacnet.io.PropertyValue;
import javax.baja.bacnet.io.RangeData;
import javax.baja.bacnet.io.RangeReference;
import javax.baja.bacnet.io.RejectException;
import javax.baja.bacnet.util.BacnetBitStringUtil;
import javax.baja.sys.BEnum;
import javax.baja.sys.BFacets;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BBacnetMultiStateOutputDescriptor
extends BBacnetMultiStateWritableDescriptor {
    public static final Property objectId = BBacnetMultiStateOutputDescriptor.newProperty((int)64, (BValue)BBacnetObjectIdentifier.make(14));
    public static final Property deviceType = BBacnetMultiStateOutputDescriptor.newProperty((int)0, (String)"", null);
    public static final Type TYPE = Sys.loadType(BBacnetMultiStateOutputDescriptor.class);

    public String getDeviceType() {
        return this.getString(deviceType);
    }

    public void setDeviceType(String v) {
        this.setString(deviceType, v, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    public final BFacets getSlotFacets(Slot s) {
        if (s == objectId) {
            return BBacnetObjectType.getObjectIdFacets(14);
        }
        return super.getSlotFacets(s);
    }

    @Override
    public BEnum getEventType() {
        return BBacnetEventType.commandFailure;
    }

    @Override
    public boolean isValidAlarmExt(BIAlarmSource ext) {
        if (ext instanceof BAlarmSourceExt) {
            return ((BAlarmSourceExt)ext).getOffnormalAlgorithm() instanceof BEnumCommandFailureAlgorithm;
        }
        return false;
    }

    @Override
    protected void addRequiredProps(Vector v) {
        super.addRequiredProps(v);
        v.add(BBacnetPropertyIdentifier.priorityArray);
        v.add(BBacnetPropertyIdentifier.relinquishDefault);
    }

    @Override
    protected void addOptionalProps(Vector v) {
        super.addOptionalProps(v);
        BAlarmSourceExt almExt = this.getAlarmExt();
        if (almExt != null) {
            v.add(BBacnetPropertyIdentifier.feedbackValue);
        }
        v.add(BBacnetPropertyIdentifier.deviceType);
    }

    @Override
    public RangeData readRange(RangeReference rangeReference) throws RejectException {
        int i;
        int pId = rangeReference.getPropertyId();
        int[] props = this.getRequiredProps();
        for (i = 0; i < props.length; ++i) {
            if (pId != props[i]) continue;
            return new ReadRangeAck(5, 22);
        }
        props = this.getOptionalProps();
        for (i = 0; i < props.length; ++i) {
            if (pId != props[i]) continue;
            return new ReadRangeAck(5, 22);
        }
        return new ReadRangeAck(2, 32);
    }

    @Override
    protected PropertyValue readOptionalProperty(int pId, int ndx) {
        BAlarmSourceExt almExt = this.getAlarmExt();
        if (almExt != null) {
            BEnumCommandFailureAlgorithm alg = (BEnumCommandFailureAlgorithm)almExt.getOffnormalAlgorithm();
            if (pId == 40) {
                return new NReadPropertyResult(pId, ndx, AsnUtil.toAsnUnsigned(alg.getFeedbackValue().getValue().getOrdinal()));
            }
        }
        switch (pId) {
            case 31: {
                return new NReadPropertyResult(pId, ndx, AsnUtil.toAsnCharacterString(this.getDeviceType()));
            }
        }
        return super.readOptionalProperty(pId, ndx);
    }

    @Override
    protected ErrorType writeOptionalProperty(int pId, int ndx, byte[] val, int pri) throws BacnetException {
        switch (pId) {
            case 31: {
                return new NErrorType(2, 40);
            }
        }
        BAlarmSourceExt almExt = this.getAlarmExt();
        if (almExt != null) {
            if (pId == 40) {
                return new NErrorType(2, 40);
            }
            if (pId == 35) {
                almExt.set(BAlarmSourceExt.alarmEnable, (BValue)BacnetBitStringUtil.getBAlarmTransitionBits(AsnUtil.fromAsnBitString(val)), BLocalBacnetDevice.getBacnetContext());
                return null;
            }
        }
        return super.writeOptionalProperty(pId, ndx, val, pri);
    }
}

