/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.bacnet.export;

import com.tridium.bacnet.asn.AsnInputStream;
import com.tridium.bacnet.asn.AsnOutputStream;
import com.tridium.bacnet.asn.AsnUtil;
import java.util.Vector;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.enums.BBacnetObjectType;
import javax.baja.bacnet.enums.BBacnetPropertyIdentifier;
import javax.baja.bacnet.export.BBacnetAnalogWritableDescriptor;
import javax.baja.bacnet.io.AsnException;
import javax.baja.sys.BFacets;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BBacnetLargeAnalogValuePrioritizedDescriptor
extends BBacnetAnalogWritableDescriptor {
    public static final Property objectId = BBacnetLargeAnalogValuePrioritizedDescriptor.newProperty((int)64, (BValue)BBacnetObjectIdentifier.make(46));
    public static final Type TYPE = Sys.loadType(BBacnetLargeAnalogValuePrioritizedDescriptor.class);

    @Override
    public Type getType() {
        return TYPE;
    }

    @Override
    public int asnType() {
        return 5;
    }

    @Override
    public byte[] convertToAsn(double value) {
        return AsnUtil.toAsnDouble(value);
    }

    @Override
    public double convertFromAsn(byte[] value) throws AsnException {
        return AsnUtil.fromAsnDouble(value);
    }

    @Override
    public void appendToAsn(AsnOutputStream out, double value) {
        out.writeDouble(value);
    }

    @Override
    public double readFromAsn(AsnInputStream in) throws AsnException {
        return in.readDouble();
    }

    @Override
    protected void addRequiredProps(Vector v) {
        super.addRequiredProps(v);
        v.remove(BBacnetPropertyIdentifier.outOfService);
        v.remove(BBacnetPropertyIdentifier.priorityArray);
        v.remove(BBacnetPropertyIdentifier.relinquishDefault);
        v.remove(BBacnetPropertyIdentifier.eventState);
    }

    @Override
    protected void addOptionalProps(Vector v) {
        super.addOptionalProps(v);
        v.add(BBacnetPropertyIdentifier.outOfService);
        v.add(BBacnetPropertyIdentifier.priorityArray);
        v.add(BBacnetPropertyIdentifier.relinquishDefault);
        v.add(BBacnetPropertyIdentifier.eventState);
    }

    public final BFacets getSlotFacets(Slot s) {
        if (s == objectId) {
            return BBacnetObjectType.getObjectIdFacets(46);
        }
        return super.getSlotFacets(s);
    }
}

