/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.bacnet.export;

import com.tridium.bacnet.asn.AsnInputStream;
import com.tridium.bacnet.asn.AsnOutputStream;
import com.tridium.bacnet.asn.AsnUtil;
import com.tridium.bacnet.asn.NReadPropertyResult;
import java.util.Vector;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.enums.BBacnetObjectType;
import javax.baja.bacnet.enums.BBacnetPropertyIdentifier;
import javax.baja.bacnet.export.BBacnetAnalogWritableDescriptor;
import javax.baja.bacnet.io.AsnException;
import javax.baja.bacnet.io.PropertyValue;
import javax.baja.sys.BFacets;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BBacnetIntegerValuePrioritizedDescriptor
extends BBacnetAnalogWritableDescriptor {
    public static final Property objectId = BBacnetIntegerValuePrioritizedDescriptor.newProperty((int)64, (BValue)BBacnetObjectIdentifier.make(45));
    public static final Type TYPE = Sys.loadType(BBacnetIntegerValuePrioritizedDescriptor.class);

    @Override
    public Type getType() {
        return TYPE;
    }

    @Override
    public int asnType() {
        return 3;
    }

    @Override
    public byte[] convertToAsn(double value) {
        return AsnUtil.toAsnInteger((int)value);
    }

    @Override
    public double convertFromAsn(byte[] value) throws AsnException {
        return AsnUtil.fromAsnSignedInteger(value);
    }

    @Override
    protected void addRequiredProps(Vector v) {
        super.addRequiredProps(v);
        v.remove(BBacnetPropertyIdentifier.outOfService);
        v.remove(BBacnetPropertyIdentifier.priorityArray);
        v.remove(BBacnetPropertyIdentifier.relinquishDefault);
        v.remove(BBacnetPropertyIdentifier.eventState);
    }

    @Override
    protected void addOptionalProps(Vector v) {
        super.addOptionalProps(v);
        v.add(BBacnetPropertyIdentifier.outOfService);
        v.add(BBacnetPropertyIdentifier.priorityArray);
        v.add(BBacnetPropertyIdentifier.relinquishDefault);
        v.add(BBacnetPropertyIdentifier.eventState);
    }

    @Override
    public void appendToAsn(AsnOutputStream out, double value) {
        out.writeSignedInteger((int)value);
    }

    @Override
    public double readFromAsn(AsnInputStream in) throws AsnException {
        return in.readSignedInteger();
    }

    public final BFacets getSlotFacets(Slot s) {
        if (s == objectId) {
            return BBacnetObjectType.getObjectIdFacets(45);
        }
        return super.getSlotFacets(s);
    }

    @Override
    protected PropertyValue readProperty(int pId, int ndx) {
        switch (pId) {
            case 22: {
                return new NReadPropertyResult(pId, AsnUtil.toAsnUnsigned((int)this.getCovIncrement()));
            }
        }
        return super.readProperty(pId, ndx);
    }

    @Override
    public double getDeadBandValue(byte[] value) throws AsnException {
        return AsnUtil.fromAsnUnsignedInteger(value);
    }

    @Override
    public byte[] getDeadBandBytes(double value) {
        return AsnUtil.toAsnUnsigned((long)value);
    }

    @Override
    protected double getCovIncrement(byte[] value) throws AsnException {
        return AsnUtil.fromAsnUnsignedInteger(value);
    }
}

