/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.bacnet.export;

import com.tridium.bacnet.BacUtil;
import com.tridium.bacnet.asn.AsnUtil;
import com.tridium.bacnet.asn.NErrorType;
import com.tridium.bacnet.asn.NReadPropertyResult;
import com.tridium.bacnet.history.BBacnetTrendLogAlarmSourceExt;
import com.tridium.bacnet.history.BBacnetTrendLogRemoteExt;
import com.tridium.bacnet.history.BIBacnetTrendLogExt;
import com.tridium.bacnet.services.error.NChangeListError;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.alarm.BAlarmClass;
import javax.baja.alarm.BAlarmService;
import javax.baja.alarm.BAlarmTransitionBits;
import javax.baja.alarm.BIAlarmSource;
import javax.baja.alarm.ext.BAlarmSourceExt;
import javax.baja.alarm.ext.BAlarmTimestamps;
import javax.baja.alarm.ext.BFaultAlgorithm;
import javax.baja.alarm.ext.BLimitEnable;
import javax.baja.alarm.ext.BNotifyType;
import javax.baja.alarm.ext.BOffnormalAlgorithm;
import javax.baja.alarm.ext.fault.BEnumFaultAlgorithm;
import javax.baja.alarm.ext.fault.BOutOfRangeFaultAlgorithm;
import javax.baja.alarm.ext.offnormal.BBooleanChangeOfStateAlgorithm;
import javax.baja.alarm.ext.offnormal.BBooleanCommandFailureAlgorithm;
import javax.baja.alarm.ext.offnormal.BEnumChangeOfStateAlgorithm;
import javax.baja.alarm.ext.offnormal.BEnumCommandFailureAlgorithm;
import javax.baja.alarm.ext.offnormal.BFloatingLimitAlgorithm;
import javax.baja.alarm.ext.offnormal.BOutOfRangeAlgorithm;
import javax.baja.alarm.ext.offnormal.BStringChangeOfStateAlgorithm;
import javax.baja.alarm.ext.offnormal.BStringChangeOfStateFaultAlgorithm;
import javax.baja.bacnet.BBacnetNetwork;
import javax.baja.bacnet.BacnetException;
import javax.baja.bacnet.alarm.BBacnetStatusAlgorithm;
import javax.baja.bacnet.datatypes.BBacnetArray;
import javax.baja.bacnet.datatypes.BBacnetBitString;
import javax.baja.bacnet.datatypes.BBacnetDeviceObjectPropertyReference;
import javax.baja.bacnet.datatypes.BBacnetEventParameter;
import javax.baja.bacnet.datatypes.BBacnetListOf;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.datatypes.BBacnetObjectPropertyReference;
import javax.baja.bacnet.datatypes.BBacnetPropertyStates;
import javax.baja.bacnet.datatypes.BBacnetTimeStamp;
import javax.baja.bacnet.datatypes.BBacnetUnsigned;
import javax.baja.bacnet.enums.BBacnetBinaryPv;
import javax.baja.bacnet.enums.BBacnetEventState;
import javax.baja.bacnet.enums.BBacnetEventType;
import javax.baja.bacnet.enums.BBacnetNotifyType;
import javax.baja.bacnet.enums.BBacnetObjectType;
import javax.baja.bacnet.enums.BBacnetPropertyIdentifier;
import javax.baja.bacnet.enums.BBacnetReliability;
import javax.baja.bacnet.export.BBacnetAnalogPointDescriptor;
import javax.baja.bacnet.export.BBacnetBinaryPointDescriptor;
import javax.baja.bacnet.export.BBacnetEventSource;
import javax.baja.bacnet.export.BBacnetMultiStatePointDescriptor;
import javax.baja.bacnet.export.BBacnetNotificationClassDescriptor;
import javax.baja.bacnet.export.BIBacnetExportObject;
import javax.baja.bacnet.export.BLocalBacnetDevice;
import javax.baja.bacnet.export.BacnetDescriptorUtil;
import javax.baja.bacnet.export.BacnetPropertyList;
import javax.baja.bacnet.export.BacnetPropertyListProvider;
import javax.baja.bacnet.io.AsnException;
import javax.baja.bacnet.io.ChangeListError;
import javax.baja.bacnet.io.ErrorType;
import javax.baja.bacnet.io.OutOfRangeException;
import javax.baja.bacnet.io.PropertyReference;
import javax.baja.bacnet.io.PropertyValue;
import javax.baja.bacnet.io.RangeData;
import javax.baja.bacnet.io.RangeReference;
import javax.baja.bacnet.io.RejectException;
import javax.baja.bacnet.point.BBacnetProxyExt;
import javax.baja.bacnet.util.BacnetBitStringUtil;
import javax.baja.control.BBooleanPoint;
import javax.baja.control.BControlPoint;
import javax.baja.control.BEnumPoint;
import javax.baja.control.BNumericPoint;
import javax.baja.control.BPointExtension;
import javax.baja.control.BStringPoint;
import javax.baja.control.ext.BAbstractProxyExt;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.PermissionException;
import javax.baja.spy.SpyWriter;
import javax.baja.status.BIStatus;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusBoolean;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BLink;
import javax.baja.sys.BNumber;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.DuplicateSlotException;
import javax.baja.sys.Property;
import javax.baja.sys.ServiceNotFoundException;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.user.BUser;
import javax.baja.util.BFormat;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="eventEnrollmentOrd", type="BOrd", defaultValue="BOrd.DEFAULT", flags=64), @NiagaraProperty(name="objectId", type="BBacnetObjectIdentifier", defaultValue="BBacnetObjectIdentifier.make(BBacnetObjectType.EVENT_ENROLLMENT)", flags=64), @NiagaraProperty(name="objectName", type="String", defaultValue="", flags=64), @NiagaraProperty(name="description", type="String", defaultValue="", flags=64), @NiagaraProperty(name="typeOfEvent", type="BBacnetEventType", defaultValue="BBacnetEventType.none", flags=65), @NiagaraProperty(name="notifyTypeId", type="BNotifyType", defaultValue="BNotifyType.alarm", flags=69), @NiagaraProperty(name="objectPropertyReference", type="BBacnetDeviceObjectPropertyReference", defaultValue="new BBacnetDeviceObjectPropertyReference()", flags=69), @NiagaraProperty(name="notificationClassId", type="int", defaultValue="0", flags=64), @NiagaraProperty(name="reliability", type="BBacnetReliability", defaultValue="BBacnetReliability.configurationError", flags=65), @NiagaraProperty(name="eventParameter", type="BBacnetEventParameter", defaultValue="new BBacnetEventParameter()", flags=5)})
public class BBacnetEventEnrollmentDescriptor
extends BBacnetEventSource
implements BacnetPropertyListProvider {
    public static final Property eventEnrollmentOrd = BBacnetEventEnrollmentDescriptor.newProperty((int)64, (BValue)BOrd.DEFAULT, null);
    public static final Property objectId = BBacnetEventEnrollmentDescriptor.newProperty((int)64, (BValue)BBacnetObjectIdentifier.make(9), null);
    public static final Property objectName = BBacnetEventEnrollmentDescriptor.newProperty((int)64, (String)"", null);
    public static final Property description = BBacnetEventEnrollmentDescriptor.newProperty((int)64, (String)"", null);
    public static final Property typeOfEvent = BBacnetEventEnrollmentDescriptor.newProperty((int)65, (BValue)BBacnetEventType.none, null);
    public static final Property notifyTypeId = BBacnetEventEnrollmentDescriptor.newProperty((int)69, (BValue)BNotifyType.alarm, null);
    public static final Property objectPropertyReference = BBacnetEventEnrollmentDescriptor.newProperty((int)69, (BValue)new BBacnetDeviceObjectPropertyReference(), null);
    public static final Property notificationClassId = BBacnetEventEnrollmentDescriptor.newProperty((int)64, (int)0, null);
    public static final Property reliability = BBacnetEventEnrollmentDescriptor.newProperty((int)65, (BValue)BBacnetReliability.configurationError, null);
    public static final Property eventParameter = BBacnetEventEnrollmentDescriptor.newProperty((int)5, (BValue)new BBacnetEventParameter(), null);
    public static final Type TYPE = Sys.loadType(BBacnetEventEnrollmentDescriptor.class);
    private static final int[] ARRAY_PROPS = new int[]{130, 351, 352, 371};
    private static final Logger logger = Logger.getLogger("bacnet.export.object.eventEnrollment");
    private static final int[] REQUIRED_PROPS = new int[]{75, 77, 79, 37, 72, 83, 78, 36, 35, 0, 17, 130, 353, 111, 103};
    private static final int[] OPTIONAL_PROPS = new int[]{28, 351, 352, 355, 354};
    private static final PropertyValue[] EMPTY_PROP_VALUE_ARRAY = new PropertyValue[0];
    private static final BBacnetBitString STATUS_FLAGS_DEFAULT = BBacnetBitString.make(new boolean[]{false, true, false, false});
    private static final BLink[] EMPTY_LINKS_ARRAY = new BLink[0];
    private BPointExtension pointExt;
    private BAlarmTransitionBits eventEnable = BAlarmTransitionBits.DEFAULT;
    private String toOffnormalText = "";
    private String toFaultText = "";
    private String toNormalText = "";
    private boolean eventAlgorithmInhibit;
    private static final BBacnetObjectPropertyReference OBJECT_PROP_REF_DEFAULT = new BBacnetObjectPropertyReference(BBacnetObjectIdentifier.make(0, 0x3FFFFF));
    private BBacnetObjectPropertyReference eventAlgorithmInhibitRef = OBJECT_PROP_REF_DEFAULT;
    private BBacnetObjectIdentifier oldId;
    private String oldName;
    private boolean duplicate;
    private boolean configOk;

    public BOrd getEventEnrollmentOrd() {
        return (BOrd)this.get(eventEnrollmentOrd);
    }

    public void setEventEnrollmentOrd(BOrd v) {
        this.set(eventEnrollmentOrd, (BValue)v, null);
    }

    @Override
    public BBacnetObjectIdentifier getObjectId() {
        return (BBacnetObjectIdentifier)this.get(objectId);
    }

    @Override
    public void setObjectId(BBacnetObjectIdentifier v) {
        this.set(objectId, (BValue)v, null);
    }

    @Override
    public String getObjectName() {
        return this.getString(objectName);
    }

    @Override
    public void setObjectName(String v) {
        this.setString(objectName, v, null);
    }

    public String getDescription() {
        return this.getString(description);
    }

    public void setDescription(String v) {
        this.setString(description, v, null);
    }

    public BBacnetEventType getTypeOfEvent() {
        return (BBacnetEventType)this.get(typeOfEvent);
    }

    public void setTypeOfEvent(BBacnetEventType v) {
        this.set(typeOfEvent, (BValue)v, null);
    }

    public BNotifyType getNotifyTypeId() {
        return (BNotifyType)this.get(notifyTypeId);
    }

    public void setNotifyTypeId(BNotifyType v) {
        this.set(notifyTypeId, (BValue)v, null);
    }

    public BBacnetDeviceObjectPropertyReference getObjectPropertyReference() {
        return (BBacnetDeviceObjectPropertyReference)this.get(objectPropertyReference);
    }

    public void setObjectPropertyReference(BBacnetDeviceObjectPropertyReference v) {
        this.set(objectPropertyReference, (BValue)v, null);
    }

    public int getNotificationClassId() {
        return this.getInt(notificationClassId);
    }

    public void setNotificationClassId(int v) {
        this.setInt(notificationClassId, v, null);
    }

    public BBacnetReliability getReliability() {
        return (BBacnetReliability)this.get(reliability);
    }

    public void setReliability(BBacnetReliability v) {
        this.set(reliability, (BValue)v, null);
    }

    public BBacnetEventParameter getEventParameter() {
        return (BBacnetEventParameter)this.get(eventParameter);
    }

    public void setEventParameter(BBacnetEventParameter v) {
        this.set(eventParameter, (BValue)v, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    @Override
    public void started() throws Exception {
        super.started();
        this.oldId = this.getObjectId();
        this.oldName = this.getObjectName();
        if (Sys.isStationStarted()) {
            this.initialize();
            BBacnetNetwork.localDevice().incrementDatabaseRevision();
        }
    }

    public void stationStarted() throws Exception {
        super.stationStarted();
        this.initialize();
    }

    private void initialize() {
        BBacnetNetwork.localDevice().export(this);
        BPointExtension pointExt = (BPointExtension)this.getObject();
        this.updateEventParameters(pointExt);
        this.getEventEnable(pointExt);
        this.getNotificationClass(pointExt);
        this.updateEventMessageTextsConfig(pointExt);
        this.updateEventAlgorithmInhibitInfo(pointExt);
    }

    @Override
    public void changed(Property p, Context cx) {
        super.changed(p, cx);
        if (!this.isRunning()) {
            return;
        }
        if (p.equals(objectId)) {
            BLocalBacnetDevice local = BBacnetNetwork.localDevice();
            local.unexport(this.oldId, this.oldName, this);
            this.checkConfiguration();
            this.oldId = this.getObjectId();
            try {
                ((BComponent)this.getParent()).rename(this.getPropertyInParent(), this.getObjectId().toString(nameContext));
            }
            catch (DuplicateSlotException duplicateSlotException) {
                // empty catch block
            }
            if (this.configOk) {
                local.incrementDatabaseRevision();
            }
        } else if (p.equals(objectName)) {
            BLocalBacnetDevice local = BBacnetNetwork.localDevice();
            local.unexport(this.oldId, this.oldName, this);
            this.checkConfiguration();
            this.oldName = this.getObjectName();
            if (this.configOk) {
                local.incrementDatabaseRevision();
            }
        } else if (p.equals(eventEnrollmentOrd)) {
            this.pointExt = null;
            BLocalBacnetDevice local = BBacnetNetwork.localDevice();
            local.exportByOrd(this);
            if (this.configOk) {
                local.incrementDatabaseRevision();
            }
        }
    }

    public void stopped() throws Exception {
        BLocalBacnetDevice local = BBacnetNetwork.localDevice();
        local.unexport(this.oldId, this.oldName, this);
        this.oldId = null;
        this.oldName = null;
        this.pointExt = null;
        if (local.isRunning()) {
            local.incrementDatabaseRevision();
        }
        super.stopped();
    }

    public String toString(Context context) {
        return this.getObjectName() + " [" + (Object)((Object)this.getObjectId()) + ']';
    }

    @Override
    public BObject getObject() {
        BPointExtension pointExt = this.pointExt;
        if (pointExt == null && (pointExt = this.resolvePointExt()) == null) {
            return null;
        }
        BComponent target = (BComponent)pointExt.getParent();
        if (target == null) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine((Object)((Object)this.getObjectId()) + ": associated PointExt (" + pointExt.getSlotPath() + ") has no parent");
            }
            this.resetDescriptor();
            return null;
        }
        this.pointExt = pointExt;
        return pointExt;
    }

    private BPointExtension resolvePointExt() {
        BObject resolved;
        BOrd objectOrd = this.getEventEnrollmentOrd();
        if (objectOrd.isNull()) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine((Object)((Object)this.getObjectId()) + ": eventEnrollmentOrd is null");
            }
            this.resetDescriptor();
            return null;
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine((Object)((Object)this.getObjectId()) + ": resolving eventEnrollmentOrd: " + objectOrd);
        }
        try {
            resolved = objectOrd.get((BObject)this);
        }
        catch (Exception e) {
            BBacnetEventEnrollmentDescriptor.logException(Level.WARNING, new StringBuilder(this.getObjectId().toString()).append(": could not resolve eventEnrollmentOrd: ").append(objectOrd), e);
            this.resetDescriptor();
            return null;
        }
        if (resolved instanceof BAlarmSourceExt || resolved instanceof BBacnetTrendLogAlarmSourceExt) {
            return (BPointExtension)resolved;
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine((Object)((Object)this.getObjectId()) + ": eventEnrollmentOrd resolved to type " + resolved.getType() + " and not instanceof alarm:AlarmSourceExt or bacnet:BacnetTrendLogAlarmSourceExt");
        }
        this.resetDescriptor();
        return null;
    }

    @Override
    public BOrd getObjectOrd() {
        return this.getEventEnrollmentOrd();
    }

    @Override
    public void setObjectOrd(BOrd objectOrd, Context cx) {
        this.set(eventEnrollmentOrd, (BValue)objectOrd, cx);
    }

    @Override
    public void checkConfiguration() {
        if (this.isFatalFault()) {
            this.setStatus(BStatus.makeFault((BStatus)this.getStatus(), (boolean)true));
            this.configOk = false;
            return;
        }
        if (!this.getObjectId().isValid()) {
            this.setStatusFaulted("Invalid Object ID");
            return;
        }
        String err = BBacnetNetwork.localDevice().export(this);
        if (err != null) {
            this.duplicate = true;
            this.setStatusFaulted(err);
            return;
        }
        this.duplicate = false;
        this.configOk = true;
        this.setStatus(BStatus.ok);
        this.setFaultCause("");
    }

    private void setStatusFaulted(String faultCause) {
        this.setStatus(BStatus.makeFault((BStatus)this.getStatus(), (boolean)true));
        this.setFaultCause(faultCause);
        this.configOk = false;
    }

    @Override
    public int[] getPropertyList() {
        return BacnetPropertyList.makePropertyList(REQUIRED_PROPS, OPTIONAL_PROPS);
    }

    public int[] getOptionalProps() {
        return OPTIONAL_PROPS;
    }

    public int[] getRequiredProps() {
        return REQUIRED_PROPS;
    }

    @Override
    public PropertyValue readProperty(PropertyReference propertyReference) throws RejectException {
        return this.readProperty(propertyReference.getPropertyId(), propertyReference.getPropertyArrayIndex());
    }

    @Override
    public PropertyValue[] readPropertyMultiple(PropertyReference[] propertyReferences) throws RejectException {
        ArrayList<PropertyValue> results = new ArrayList<PropertyValue>(propertyReferences.length);
        block5: for (PropertyReference ref : propertyReferences) {
            switch (ref.getPropertyId()) {
                case 8: {
                    for (int prop : REQUIRED_PROPS) {
                        results.add(this.readProperty(prop, -1));
                    }
                    for (int prop : OPTIONAL_PROPS) {
                        results.add(this.readProperty(prop, -1));
                    }
                    continue block5;
                }
                case 80: {
                    for (int prop : OPTIONAL_PROPS) {
                        results.add(this.readProperty(prop, -1));
                    }
                    continue block5;
                }
                case 105: {
                    for (int prop : REQUIRED_PROPS) {
                        results.add(this.readProperty(prop, -1));
                    }
                    continue block5;
                }
                default: {
                    results.add(this.readProperty(ref.getPropertyId(), ref.getPropertyArrayIndex()));
                }
            }
        }
        return results.toArray(EMPTY_PROP_VALUE_ARRAY);
    }

    @Override
    public RangeData readRange(RangeReference rangeReference) throws RejectException {
        return null;
    }

    @Override
    public ErrorType writeProperty(PropertyValue propertyValue) throws BacnetException {
        return this.writeProperty(propertyValue.getPropertyId(), propertyValue.getPropertyArrayIndex(), propertyValue.getPropertyValue(), propertyValue.getPriority());
    }

    @Override
    public ChangeListError addListElements(PropertyValue propertyValue) throws BacnetException {
        return BBacnetEventEnrollmentDescriptor.handleChangeList(propertyValue.getPropertyId(), 8);
    }

    @Override
    public ChangeListError removeListElements(PropertyValue propertyValue) throws BacnetException {
        return BBacnetEventEnrollmentDescriptor.handleChangeList(propertyValue.getPropertyId(), 9);
    }

    private static ChangeListError handleChangeList(int propertyId, int serviceChoice) {
        for (int prop : REQUIRED_PROPS) {
            if (propertyId != prop) continue;
            return new NChangeListError(serviceChoice, new NErrorType(5, 22), 0L);
        }
        for (int prop : OPTIONAL_PROPS) {
            if (propertyId != prop) continue;
            return new NChangeListError(serviceChoice, new NErrorType(5, 22), 0L);
        }
        return new NChangeListError(serviceChoice, new NErrorType(2, 32), 0L);
    }

    public BBacnetEventState getEventState() {
        BPointExtension pointExt = (BPointExtension)this.getObject();
        if (pointExt instanceof BAlarmSourceExt) {
            return BBacnetEventState.make(((BAlarmSourceExt)pointExt).getAlarmState());
        }
        if (pointExt instanceof BBacnetTrendLogAlarmSourceExt) {
            return BBacnetEventState.make(((BBacnetTrendLogAlarmSourceExt)pointExt).getAlarmState());
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine((Object)((Object)this.getObjectId()) + ": associated PointExt (" + (pointExt != null ? pointExt.getSlotPath() : null) + ") is not an AlarmSourceExt or BacnetTrendLogAlarmSourceExt; returning null for event state");
        }
        return null;
    }

    private BBacnetEventState getEventState(BPointExtension pointExt) {
        if (pointExt instanceof BAlarmSourceExt) {
            return BBacnetEventState.make(((BAlarmSourceExt)pointExt).getAlarmState());
        }
        if (pointExt instanceof BBacnetTrendLogAlarmSourceExt) {
            return BBacnetEventState.make(((BBacnetTrendLogAlarmSourceExt)pointExt).getAlarmState());
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine((Object)((Object)this.getObjectId()) + ": associated PointExt (" + (pointExt != null ? pointExt.getSlotPath() : null) + ") is not an AlarmSourceExt or BacnetTrendLogAlarmSourceExt; returning BacnetEventState.normal");
        }
        return BBacnetEventState.normal;
    }

    @Override
    public BControlPoint getPoint() {
        BPointExtension pointExt = (BPointExtension)this.getObject();
        if (pointExt instanceof BAlarmSourceExt) {
            return pointExt.getParentPoint();
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine((Object)((Object)this.getObjectId()) + ": associated PointExt (" + (pointExt != null ? pointExt.getSlotPath() : null) + ") is not an AlarmSourceExt; returning null for getPoint");
        }
        return null;
    }

    @Override
    public BBacnetBitString getAckedTransitions() {
        BAlarmTransitionBits ackedTransitions = BBacnetEventEnrollmentDescriptor.getAckedTransitions((BPointExtension)this.getObject());
        if (ackedTransitions == null) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine((Object)((Object)this.getObjectId()) + ": associated PointExt (" + (this.pointExt != null ? this.pointExt.getSlotPath() : null) + ") is not an AlarmSourceExt or BacnetTrendLogAlarmSourceExt; returning default ackedTransitions value");
            }
            return null;
        }
        return BacnetBitStringUtil.getBacnetEventTransitionBits(ackedTransitions);
    }

    private static BAlarmTransitionBits getAckedTransitions(BPointExtension pointExt) {
        if (pointExt instanceof BAlarmSourceExt) {
            return ((BAlarmSourceExt)pointExt).getAckedTransitions();
        }
        if (pointExt instanceof BBacnetTrendLogAlarmSourceExt) {
            return ((BBacnetTrendLogAlarmSourceExt)pointExt).getAckedTransitions();
        }
        return null;
    }

    @Override
    public BBacnetTimeStamp[] getEventTimeStamps() {
        BPointExtension pointExt = (BPointExtension)this.getObject();
        if (pointExt instanceof BAlarmSourceExt) {
            BAlarmSourceExt alarmExt = (BAlarmSourceExt)pointExt;
            return new BBacnetTimeStamp[]{new BBacnetTimeStamp(alarmExt.getLastOffnormalTime()), new BBacnetTimeStamp(alarmExt.getLastFaultTime()), new BBacnetTimeStamp(alarmExt.getLastToNormalTime())};
        }
        if (pointExt instanceof BBacnetTrendLogAlarmSourceExt) {
            BBacnetTrendLogAlarmSourceExt trendAlarmExt = (BBacnetTrendLogAlarmSourceExt)pointExt;
            BAlarmTimestamps toOffnormalTimes = trendAlarmExt.getToOffnormalTimes();
            BAlarmTimestamps toFaultTimes = trendAlarmExt.getToFaultTimes();
            BAbsTime normalTime = toOffnormalTimes.getNormalTime();
            if (normalTime.isBefore(toFaultTimes.getNormalTime())) {
                normalTime = toFaultTimes.getNormalTime();
            }
            return new BBacnetTimeStamp[]{new BBacnetTimeStamp(toOffnormalTimes.getAlarmTime()), new BBacnetTimeStamp(toFaultTimes.getAlarmTime()), new BBacnetTimeStamp(normalTime)};
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine((Object)((Object)this.getObjectId()) + ": associated PointExt (" + (pointExt != null ? pointExt.getSlotPath() : null) + ") is not an AlarmSourceExt or BacnetTrendLogAlarmSourceExt; returning default eventTimeStamps");
        }
        return null;
    }

    @Override
    public BBacnetNotifyType getNotifyType() {
        return BBacnetNotifyType.make(this.getNotifyTypeId());
    }

    @Override
    public BBacnetBitString getEventEnable() {
        BPointExtension pointExt = (BPointExtension)this.getObject();
        BAlarmTransitionBits alarmEnable = this.getEventEnable(pointExt);
        return alarmEnable != null ? BacnetBitStringUtil.getBacnetEventTransitionBits(alarmEnable) : null;
    }

    private BAlarmTransitionBits getEventEnable(BPointExtension pointExt) {
        BAlarmTransitionBits alarmEnable = null;
        if (pointExt instanceof BAlarmSourceExt) {
            alarmEnable = ((BAlarmSourceExt)pointExt).getAlarmEnable();
        } else if (pointExt instanceof BBacnetTrendLogAlarmSourceExt) {
            alarmEnable = ((BBacnetTrendLogAlarmSourceExt)pointExt).getAlarmEnable();
        }
        if (alarmEnable != null) {
            this.eventEnable = alarmEnable;
        } else if (logger.isLoggable(Level.FINE)) {
            logger.fine((Object)((Object)this.getObjectId()) + ": associated PointExt (" + (pointExt != null ? pointExt.getSlotPath() : null) + ") is not an AlarmSourceExt or BacnetTrendLogAlarmSourceExt");
        }
        return alarmEnable;
    }

    @Override
    public BEnum getEventType() {
        this.updateEventParameters((BPointExtension)this.getObject());
        return this.getTypeOfEvent();
    }

    @Override
    public void statusChanged() {
        this.setBacnetStatusFlags(this.getStatusFlags());
    }

    public BBacnetBitString getStatusFlags() {
        BPointExtension pointExt = (BPointExtension)this.getObject();
        if (pointExt == null) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine((Object)((Object)this.getObjectId()) + ": associated PointExt (" + (pointExt != null ? pointExt.getSlotPath() : null) + ") is not an AlarmSourceExt or BacnetTrendLogAlarmSourceExt; returning default status flags");
            }
            return STATUS_FLAGS_DEFAULT;
        }
        return BBacnetBitString.make(new boolean[]{!BBacnetEventState.isNormal((BEnum)this.getEventState(pointExt)), !this.readReliability().equals(BBacnetReliability.noFaultDetected), false, false});
    }

    @Override
    public boolean isValidAlarmExt(BIAlarmSource ext) {
        BPointExtension pointExt = (BPointExtension)this.getObject();
        return pointExt instanceof BAlarmSourceExt || pointExt instanceof BBacnetTrendLogAlarmSourceExt;
    }

    @Override
    public boolean isEventInitiationEnabled() {
        return true;
    }

    @Override
    public int[] getEventPriorities() {
        BBacnetNotificationClassDescriptor nc = this.getNotificationClass();
        return nc != null ? nc.getEventPriorities() : null;
    }

    @Override
    public BBacnetNotificationClassDescriptor getNotificationClass() {
        return this.getNotificationClass((BPointExtension)this.getObject());
    }

    private BBacnetNotificationClassDescriptor getNotificationClass(BPointExtension pointExt) {
        String alarmClassName = BBacnetEventEnrollmentDescriptor.getAlarmClassName(pointExt);
        if (alarmClassName == null) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine((Object)((Object)this.getObjectId()) + ": cannot retrieve the notification class descriptor- associated PointExt (" + (pointExt != null ? pointExt.getSlotPath() : null) + ") is not an AlarmSourceExt or BacnetTrendLogAlarmSourceExt");
            }
            return null;
        }
        if (alarmClassName.isEmpty()) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine((Object)((Object)this.getObjectId()) + ": pointExt's alarmClassName is an empty string; setting notification class ID to unconfigured instance number");
            }
            this.setNotificationClassId(0x3FFFFF);
            this.setReliability(BBacnetReliability.configurationError);
            return null;
        }
        BBacnetNotificationClassDescriptor descriptor = this.findNotificationClass(alarmClassName);
        if (descriptor == null) {
            this.setReliability(BBacnetReliability.configurationError);
            return null;
        }
        this.setNotificationClassId(descriptor.getObjectId().getInstanceNumber());
        return descriptor;
    }

    private BBacnetNotificationClassDescriptor findNotificationClass(String alarmClassName) {
        BAlarmService alarmService;
        try {
            alarmService = (BAlarmService)Sys.getService((Type)BAlarmService.TYPE);
        }
        catch (ServiceNotFoundException e) {
            BBacnetEventEnrollmentDescriptor.logException(Level.WARNING, new StringBuilder(this.getObjectId().toString()).append(": getNotificationClass: could not find the alarm service"), (Exception)((Object)e));
            return null;
        }
        BAlarmClass alarmClass = alarmService.lookupAlarmClass(alarmClassName);
        if (alarmClass == null) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine((Object)((Object)this.getObjectId()) + ": getNotificationClass: could not find alarm class " + alarmClassName + " in the alarm service");
            }
            return null;
        }
        BIBacnetExportObject descriptor = this.findDescriptor(alarmClass.getHandleOrd());
        if (descriptor instanceof BBacnetNotificationClassDescriptor) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine((Object)((Object)this.getObjectId()) + ": getNotificationClass: found new notification class descriptor for alarm class " + alarmClassName);
            }
            return (BBacnetNotificationClassDescriptor)descriptor;
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine((Object)((Object)this.getObjectId()) + ": getNotificationClass: could not find a notification class descriptor for alarmClass \"" + alarmClass.getSlotPath() + '\"');
        }
        return null;
    }

    @Override
    @Deprecated
    protected void updateAlarmInhibit() {
    }

    protected PropertyValue readProperty(int pId, int ndx) {
        if (ndx >= 0 && !BBacnetEventEnrollmentDescriptor.isArray(pId)) {
            return new NReadPropertyResult(pId, ndx, new NErrorType(2, 50));
        }
        if (ndx < -1) {
            return new NReadPropertyResult(pId, ndx, new NErrorType(2, 42));
        }
        switch (pId) {
            case 75: {
                return new NReadPropertyResult(pId, ndx, AsnUtil.toAsnObjectId(this.getObjectId()));
            }
            case 77: {
                return new NReadPropertyResult(pId, ndx, AsnUtil.toAsnCharacterString(this.getObjectName()));
            }
            case 79: {
                return new NReadPropertyResult(pId, ndx, AsnUtil.toAsnEnumerated(9));
            }
            case 37: {
                return new NReadPropertyResult(pId, ndx, AsnUtil.toAsnEnumerated(this.getEventType()));
            }
            case 72: {
                return new NReadPropertyResult(pId, ndx, AsnUtil.toAsnEnumerated(0));
            }
            case 83: {
                return this.readEventParameters();
            }
            case 78: {
                return this.readObjectPropertyReference();
            }
            case 36: {
                return this.readEventState();
            }
            case 35: {
                return this.readEventEnable();
            }
            case 0: {
                return this.readAckedTransitions();
            }
            case 17: {
                this.getNotificationClass();
                return new NReadPropertyResult(pId, ndx, AsnUtil.toAsnUnsigned(this.getNotificationClassId()));
            }
            case 130: {
                return this.readEventTimeStamps(ndx);
            }
            case 353: {
                return new NReadPropertyResult(pId, ndx, AsnUtil.toAsnBoolean(this.getEventDetectionEnable()));
            }
            case 111: {
                return new NReadPropertyResult(pId, ndx, AsnUtil.toAsnBitString(this.getStatusFlags()));
            }
            case 103: {
                return new NReadPropertyResult(pId, ndx, AsnUtil.toAsnEnumerated((BEnum)this.readReliability()));
            }
            case 371: {
                return this.readPropertyList(ndx);
            }
        }
        return this.readOptionalProperty(pId, ndx);
    }

    private static String getAlarmClassName(BPointExtension pointExt) {
        if (pointExt instanceof BAlarmSourceExt) {
            return ((BAlarmSourceExt)pointExt).getAlarmClass();
        }
        if (pointExt instanceof BBacnetTrendLogAlarmSourceExt) {
            return ((BBacnetTrendLogAlarmSourceExt)pointExt).getAlarmClass();
        }
        return null;
    }

    private PropertyValue readEventParameters() {
        try {
            BBacnetEventParameter params = this.readEventParameters((BPointExtension)this.getObject());
            return new NReadPropertyResult(83, AsnUtil.toAsn(-4, (BValue)params));
        }
        catch (EventEnrollmentException e) {
            return new NReadPropertyResult(83, e.errorType);
        }
    }

    private PropertyValue readObjectPropertyReference() {
        BPointExtension pointExt = (BPointExtension)this.getObject();
        if (pointExt == null) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine((Object)((Object)this.getObjectId()) + ": target alarm ext not configured; falling back to cached objectPropertyReference value");
            }
            return BBacnetEventEnrollmentDescriptor.makeObjPropRefPropValue(this.getObjectPropertyReference());
        }
        BComponent target = (BComponent)pointExt.getParent();
        if (target == null) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine((Object)((Object)this.getObjectId()) + ": target alarm ext has no parent");
            }
            return BBacnetEventEnrollmentDescriptor.makeObjPropRefError();
        }
        return this.getTargetObjPropRef(target);
    }

    private PropertyValue getTargetObjPropRef(BComponent target) {
        if (target instanceof BControlPoint) {
            return this.getPointPropRef((BControlPoint)target);
        }
        if (target instanceof BIBacnetTrendLogExt) {
            return this.getTrendPropRef((BIBacnetTrendLogExt)target);
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine((Object)((Object)this.getObjectId()) + ": target alarm ext has no parent");
        }
        return BBacnetEventEnrollmentDescriptor.makeObjPropRefError();
    }

    private PropertyValue getPointPropRef(BControlPoint point) {
        BAbstractProxyExt proxyExt = point.getProxyExt();
        if (proxyExt instanceof BBacnetProxyExt) {
            return BBacnetEventEnrollmentDescriptor.makeObjPropRefPropValue(BBacnetEventEnrollmentDescriptor.makeRemoteDeviceObjPropRef((BBacnetProxyExt)proxyExt));
        }
        BIBacnetExportObject descriptor = this.findDescriptor(point.getHandleOrd());
        if (descriptor == null) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine((Object)((Object)this.getObjectId()) + ": alarm ext's target's descriptor not found in local device; target slot path: " + point.getSlotPath());
            }
            return BBacnetEventEnrollmentDescriptor.makeObjPropRefError();
        }
        return BBacnetEventEnrollmentDescriptor.makeObjPropRefPropValue(BBacnetEventEnrollmentDescriptor.makeLocalDeviceObjPropRef(descriptor.getObjectId()));
    }

    private BIBacnetExportObject findDescriptor(BOrd ord) {
        BBacnetObjectIdentifier objectId = BBacnetNetwork.localDevice().lookupBacnetObjectId(ord);
        if (objectId == null) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine((Object)((Object)this.getObjectId()) + ": could not find object ID for ord \"" + ord + '\"');
            }
            return null;
        }
        BIBacnetExportObject descriptor = BBacnetNetwork.localDevice().lookupBacnetObject(objectId);
        if (descriptor == null) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine((Object)((Object)this.getObjectId()) + ": found object ID \"" + (Object)((Object)objectId) + "\" for ord \"" + ord + "\" but could not find descriptor");
            }
            return null;
        }
        return descriptor;
    }

    private PropertyValue getTrendPropRef(BIBacnetTrendLogExt trendLogExt) {
        if (trendLogExt instanceof BBacnetTrendLogRemoteExt) {
            BBacnetTrendLogRemoteExt trendLogRemoteExt = (BBacnetTrendLogRemoteExt)trendLogExt;
            BBacnetDeviceObjectPropertyReference deviceObjPropRef = new BBacnetDeviceObjectPropertyReference(trendLogRemoteExt.getObjectId(), trendLogRemoteExt.getPropertyId(), trendLogRemoteExt.getArrayIndex(), trendLogRemoteExt.getDevice().getObjectId());
            return BBacnetEventEnrollmentDescriptor.makeObjPropRefPropValue(deviceObjPropRef);
        }
        BIBacnetExportObject descriptor = this.findDescriptor(((BComponent)trendLogExt).getHandleOrd());
        if (descriptor == null) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine((Object)((Object)this.getObjectId()) + ": alarm ext's target's descriptor not found in local device; target slot path: " + ((BComponent)trendLogExt).getSlotPath());
            }
            return BBacnetEventEnrollmentDescriptor.makeObjPropRefError();
        }
        return BBacnetEventEnrollmentDescriptor.makeObjPropRefPropValue(BBacnetEventEnrollmentDescriptor.makeLocalDeviceObjPropRef(descriptor.getObjectId()));
    }

    private static PropertyValue makeObjPropRefPropValue(BBacnetDeviceObjectPropertyReference objPropRef) {
        return new NReadPropertyResult(78, -1, AsnUtil.toAsn(-4, (BValue)objPropRef));
    }

    private static PropertyValue makeObjPropRefError() {
        return new NReadPropertyResult(78, new NErrorType(2, 0));
    }

    private PropertyValue readEventState() {
        BBacnetEventState eventState = null;
        if (this.getEventDetectionEnable()) {
            eventState = this.getEventState();
        }
        if (eventState == null) {
            eventState = BBacnetEventState.normal;
        }
        return new NReadPropertyResult(36, -1, AsnUtil.toAsnEnumerated((BEnum)eventState));
    }

    private PropertyValue readEventEnable() {
        BBacnetBitString eventEnable = this.getEventEnable();
        if (eventEnable == null) {
            eventEnable = BacnetBitStringUtil.getBacnetEventTransitionBits(this.eventEnable);
        }
        return new NReadPropertyResult(35, -1, AsnUtil.toAsnBitString(eventEnable));
    }

    private PropertyValue readAckedTransitions() {
        if (!this.getEventDetectionEnable()) {
            return new NReadPropertyResult(0, -1, AsnUtil.toAsnBitString(ACKED_TRANS_DEFAULT));
        }
        BAlarmTransitionBits ackedTrans = BBacnetEventEnrollmentDescriptor.getAckedTransitions((BPointExtension)this.getObject());
        if (ackedTrans == null) {
            return new NReadPropertyResult(0, -1, AsnUtil.toAsnBitString(ACKED_TRANS_DEFAULT));
        }
        BAlarmTransitionBits eventTrans = this.readEventTransition(ackedTrans);
        return new NReadPropertyResult(0, -1, AsnUtil.toAsnBitString(BacnetBitStringUtil.getBacnetEventTransitionBits(eventTrans)));
    }

    protected PropertyValue readOptionalProperty(int pId, int ndx) {
        switch (pId) {
            case 28: {
                return new NReadPropertyResult(pId, ndx, AsnUtil.toAsnCharacterString(this.getDescription()));
            }
            case 351: {
                return this.readEventMessageTexts(ndx);
            }
            case 352: {
                return this.readEventMessageTextsConfig(ndx);
            }
            case 354: {
                return this.readEventAlgorithmInhibit();
            }
            case 355: {
                return this.readEventAlgorithmInhibitRef();
            }
        }
        return new NReadPropertyResult(pId, ndx, new NErrorType(2, 32));
    }

    private PropertyValue readEventMessageTextsConfig(int ndx) {
        this.updateEventMessageTextsConfig((BPointExtension)this.getObject());
        return this.readEventMessageTextsConfig(this.toOffnormalText, this.toFaultText, this.toNormalText, ndx);
    }

    private void updateEventMessageTextsConfig(BPointExtension pointExt) {
        if (pointExt instanceof BAlarmSourceExt) {
            BAlarmSourceExt alarmExt = (BAlarmSourceExt)pointExt;
            this.toOffnormalText = alarmExt.getToOffnormalText().getFormat();
            this.toFaultText = alarmExt.getToFaultText().getFormat();
            this.toNormalText = alarmExt.getToNormalText().getFormat();
        } else if (pointExt instanceof BBacnetTrendLogAlarmSourceExt) {
            BBacnetTrendLogAlarmSourceExt trendAlarmExt = (BBacnetTrendLogAlarmSourceExt)pointExt;
            this.toOffnormalText = trendAlarmExt.getToOffnormalText().getFormat();
            this.toFaultText = trendAlarmExt.getToFaultText().getFormat();
            this.toNormalText = trendAlarmExt.getToNormalText().getFormat();
        }
    }

    private void updateEventParameters(BPointExtension pointExt) {
        try {
            this.readEventParameters(pointExt);
        }
        catch (EventEnrollmentException e) {
            logger.log(Level.FINE, (Object)((Object)this.getObjectId()) + ": exception while updating event parameters", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private BBacnetEventParameter readEventParameters(BPointExtension pointExt) throws EventEnrollmentException {
        BBacnetEventParameter eventParam;
        if (pointExt == null) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine((Object)((Object)this.getObjectId()) + ": target alarm ext not configured; falling back to cached eventParameters value");
            }
            return this.getEventParameter();
        }
        if (pointExt instanceof BBacnetTrendLogAlarmSourceExt) {
            BBacnetTrendLogAlarmSourceExt trendAlarmExt = (BBacnetTrendLogAlarmSourceExt)pointExt;
            eventParam = BBacnetEventParameter.makeBufferReady(trendAlarmExt.getNotificationThreshold(), trendAlarmExt.getLastNotifyRecord());
        } else {
            if (!(pointExt instanceof BAlarmSourceExt)) {
                logger.warning((Object)((Object)this.getObjectId()) + ": could not construct EventParameters for BPointExtension of type " + pointExt.getType());
                throw new EventEnrollmentException("pointExt type " + pointExt.getType() + " not supported", new NErrorType(2, 0));
            }
            BAlarmSourceExt alarmExt = (BAlarmSourceExt)pointExt;
            BOffnormalAlgorithm offnormalAlgorithm = alarmExt.getOffnormalAlgorithm();
            if (offnormalAlgorithm instanceof BBooleanChangeOfStateAlgorithm) {
                eventParam = BBacnetEventParameter.makeChangeOfState(alarmExt.getTimeDelay(), BBacnetEventEnrollmentDescriptor.getListOfValues((BBooleanChangeOfStateAlgorithm)offnormalAlgorithm));
            } else if (offnormalAlgorithm instanceof BEnumChangeOfStateAlgorithm) {
                eventParam = BBacnetEventParameter.makeChangeOfState(alarmExt.getTimeDelay(), BBacnetEventEnrollmentDescriptor.getListOfValues((BEnumChangeOfStateAlgorithm)offnormalAlgorithm));
            } else if (offnormalAlgorithm instanceof BStringChangeOfStateAlgorithm) {
                eventParam = BBacnetEventParameter.makeChangeOfCharacterString(alarmExt.getTimeDelay(), BBacnetEventEnrollmentDescriptor.getListOfValues((BStringChangeOfStateAlgorithm)offnormalAlgorithm));
            } else if (offnormalAlgorithm instanceof BBooleanCommandFailureAlgorithm) {
                eventParam = BBacnetEventParameter.makeCommandFailure(alarmExt.getTimeDelay(), this.getLinkedPropertyReference((BComponent)offnormalAlgorithm, BBooleanCommandFailureAlgorithm.feedbackValue, BBacnetBinaryPointDescriptor.TYPE));
            } else if (offnormalAlgorithm instanceof BEnumCommandFailureAlgorithm) {
                eventParam = BBacnetEventParameter.makeCommandFailure(alarmExt.getTimeDelay(), this.getLinkedPropertyReference((BComponent)offnormalAlgorithm, BEnumCommandFailureAlgorithm.feedbackValue, BBacnetMultiStatePointDescriptor.TYPE));
            } else if (offnormalAlgorithm instanceof BFloatingLimitAlgorithm) {
                BFloatingLimitAlgorithm floatingLimitAlgorithm = (BFloatingLimitAlgorithm)offnormalAlgorithm;
                eventParam = BBacnetEventParameter.makeFloatingLimit(alarmExt.getTimeDelay(), this.getLinkedPropertyReference((BComponent)offnormalAlgorithm, BFloatingLimitAlgorithm.setpoint, BBacnetAnalogPointDescriptor.TYPE), (float)floatingLimitAlgorithm.getLowDiffLimit(), (float)floatingLimitAlgorithm.getHighDiffLimit(), (float)floatingLimitAlgorithm.getDeadband());
            } else {
                if (!(offnormalAlgorithm instanceof BOutOfRangeAlgorithm)) {
                    logger.warning((Object)((Object)this.getObjectId()) + ": could not construct EventParameters for BAlarmExt offnormalAlgorithm of type " + offnormalAlgorithm.getType());
                    throw new EventEnrollmentException("alarmExt offnormal algorithm type " + offnormalAlgorithm.getType() + " not supported", new NErrorType(2, 0));
                }
                BOutOfRangeAlgorithm outOfRangeAlgorithm = (BOutOfRangeAlgorithm)offnormalAlgorithm;
                eventParam = BBacnetEventParameter.makeOutOfRange(alarmExt.getTimeDelay(), (float)outOfRangeAlgorithm.getLowLimit(), (float)outOfRangeAlgorithm.getHighLimit(), (float)outOfRangeAlgorithm.getDeadband());
            }
        }
        this.setEventParameter(eventParam);
        this.setTypeOfEvent(BBacnetEventType.make(eventParam.getChoice()));
        return eventParam;
    }

    private static BBacnetListOf getListOfValues(BBooleanChangeOfStateAlgorithm offnormalAlgorithm) {
        BBacnetPropertyStates element = BBacnetPropertyStates.makeBinaryPv(offnormalAlgorithm.getAlarmValue());
        BBacnetListOf listOfValues = new BBacnetListOf(BBacnetPropertyStates.TYPE);
        listOfValues.addListElement((BValue)element, null);
        return listOfValues;
    }

    private static BBacnetListOf getListOfValues(BEnumChangeOfStateAlgorithm offnormalAlgorithm) {
        BBacnetListOf listOfValues = new BBacnetListOf(BBacnetPropertyStates.TYPE);
        BEnumRange alarmValues = offnormalAlgorithm.getAlarmValues();
        for (int ordinal : alarmValues.getOrdinals()) {
            listOfValues.addListElement((BValue)BBacnetPropertyStates.makeUnsigned(ordinal), null);
        }
        return listOfValues;
    }

    private static BBacnetListOf getListOfValues(BStringChangeOfStateAlgorithm offnormalAlgorithm) {
        BBacnetListOf listOfValues = new BBacnetListOf(BString.TYPE);
        listOfValues.addListElement(offnormalAlgorithm.get(BStringChangeOfStateAlgorithm.expression), null);
        return listOfValues;
    }

    private PropertyValue readEventTimeStamps(int ndx) {
        BPointExtension pointExt = (BPointExtension)this.getObject();
        BAbsTime lastOffnormalTime = BAbsTime.DEFAULT;
        BAbsTime lastFaultTime = BAbsTime.DEFAULT;
        BAbsTime lastToNormalTime = BAbsTime.DEFAULT;
        if (pointExt instanceof BAlarmSourceExt) {
            BAlarmSourceExt alarmExt = (BAlarmSourceExt)pointExt;
            lastOffnormalTime = alarmExt.getLastOffnormalTime();
            lastFaultTime = alarmExt.getLastFaultTime();
            lastToNormalTime = alarmExt.getLastToNormalTime();
        } else if (pointExt instanceof BBacnetTrendLogAlarmSourceExt) {
            BBacnetTrendLogAlarmSourceExt trendAlarmExt = (BBacnetTrendLogAlarmSourceExt)pointExt;
            BAlarmTimestamps toOffnormalTimes = trendAlarmExt.getToOffnormalTimes();
            BAlarmTimestamps toFaultTimes = trendAlarmExt.getToFaultTimes();
            lastOffnormalTime = toOffnormalTimes.getAlarmTime();
            lastFaultTime = toFaultTimes.getAlarmTime();
            lastToNormalTime = toOffnormalTimes.getNormalTime();
            if (lastToNormalTime.isBefore(toFaultTimes.getNormalTime())) {
                lastToNormalTime = toFaultTimes.getNormalTime();
            }
        }
        return this.readEventTimeStamps(lastOffnormalTime, lastFaultTime, lastToNormalTime, ndx);
    }

    private BBacnetReliability readReliability() {
        BComplex parent;
        BBacnetReliability eventEnrollmentReliability = this.getReliability();
        if (!eventEnrollmentReliability.equals(BBacnetReliability.noFaultDetected)) {
            return eventEnrollmentReliability;
        }
        BPointExtension target = (BPointExtension)this.getObject();
        BComplex bComplex = parent = target != null ? target.getParent() : null;
        if (parent == null) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine((Object)((Object)this.getObjectId()) + ": reliability set to configurationError because target could not be resolved");
            }
            this.setReliability(BBacnetReliability.configurationError);
            return BBacnetReliability.configurationError;
        }
        if (!(parent instanceof BIStatus)) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine((Object)((Object)this.getObjectId()) + ": resolved target is type " + parent.getType() + " and not instanceof BIStatus; returning noFaultDetected as reliability value");
            }
            return BBacnetReliability.noFaultDetected;
        }
        BStatus parentStatus = ((BIStatus)parent).getStatus();
        if (parentStatus.isNull()) {
            return BBacnetReliability.unreliableOther;
        }
        if (parentStatus.isDown() || parentStatus.isStale()) {
            return BBacnetReliability.communicationFailure;
        }
        if (parentStatus.isFault()) {
            return BBacnetReliability.monitoredObjectFault;
        }
        return BBacnetReliability.noFaultDetected;
    }

    private PropertyValue readEventAlgorithmInhibit() {
        this.updateEventAlgorithmInhibitInfo((BPointExtension)this.getObject());
        return new NReadPropertyResult(354, -1, AsnUtil.toAsnBoolean(this.eventAlgorithmInhibit));
    }

    private PropertyValue readEventAlgorithmInhibitRef() {
        this.updateEventAlgorithmInhibitInfo((BPointExtension)this.getObject());
        return new NReadPropertyResult(355, -1, AsnUtil.toAsn(-4, (BValue)this.eventAlgorithmInhibitRef));
    }

    private void updateEventAlgorithmInhibitInfo(BPointExtension pointExt) {
        if (pointExt instanceof BAlarmSourceExt) {
            this.eventAlgorithmInhibit = ((BAlarmSourceExt)pointExt).getAlarmInhibit().getBoolean();
            this.updateAlarmInhibitRef(pointExt.getLinks((Slot)BAlarmSourceExt.alarmInhibit));
        } else if (pointExt instanceof BBacnetTrendLogAlarmSourceExt) {
            this.eventAlgorithmInhibit = ((BBacnetTrendLogAlarmSourceExt)pointExt).getAlarmInhibit().getBoolean();
            this.updateAlarmInhibitRef(pointExt.getLinks((Slot)BBacnetTrendLogAlarmSourceExt.alarmInhibit));
        }
    }

    private void updateAlarmInhibitRef(BLink[] links) {
        for (BLink link : links) {
            BIBacnetExportObject descriptor;
            BComponent source;
            if (!link.isActive() || !link.isEnabled() || !((source = link.getSourceComponent()) instanceof BBooleanPoint) || (descriptor = this.findDescriptor(source.getHandleOrd())) == null) continue;
            BBacnetObjectPropertyReference newValue = new BBacnetObjectPropertyReference(descriptor.getObjectId());
            if (logger.isLoggable(Level.FINE) && this.eventAlgorithmInhibitRef.getObjectId().getInstanceNumber() == 0x3FFFFF) {
                logger.fine((Object)((Object)this.getObjectId()) + ": updating unconfigured eventAlgorithmInhibitRef because there is a valid link to alarmInhibitRef; new value: " + newValue);
            }
            this.eventAlgorithmInhibitRef = newValue;
            return;
        }
        if (logger.isLoggable(Level.FINE) && this.eventAlgorithmInhibitRef.getObjectId().getInstanceNumber() != 0x3FFFFF) {
            logger.fine((Object)((Object)this.getObjectId()) + ": setting eventAlgorithmInhibitRef as unconfigured because there are no valid links to alarmInhibitRef; old value: " + this.eventAlgorithmInhibitRef);
        }
        this.eventAlgorithmInhibitRef = OBJECT_PROP_REF_DEFAULT;
    }

    protected ErrorType writeProperty(int pId, int ndx, byte[] val, int pri) {
        if (ndx >= 0) {
            if (!BBacnetEventEnrollmentDescriptor.isArray(pId)) {
                return new NErrorType(2, 50);
            }
        } else if (ndx < -1) {
            return new NErrorType(2, 42);
        }
        try {
            switch (pId) {
                case 0: 
                case 36: 
                case 37: 
                case 75: 
                case 79: 
                case 103: 
                case 111: 
                case 130: 
                case 351: 
                case 371: {
                    if (logger.isLoggable(Level.FINE)) {
                        logger.fine((Object)((Object)this.getObjectId()) + ": attempted to write read-only property " + BBacnetPropertyIdentifier.tag(pId));
                    }
                    return new NErrorType(2, 40);
                }
                case 77: {
                    return BacUtil.setObjectName(this, objectName, val);
                }
                case 28: {
                    this.setString(description, AsnUtil.fromAsnCharacterString(val), BLocalBacnetDevice.getBacnetContext());
                    return null;
                }
                case 72: {
                    return this.writeNotifyType(val);
                }
                case 83: {
                    return this.writeEventParameters(val);
                }
                case 78: {
                    return this.writeObjectPropertyReference(val);
                }
                case 35: {
                    return this.writeEventEnable(val);
                }
                case 17: {
                    return this.writeNotificationClass(val);
                }
                case 353: {
                    this.setBoolean(BBacnetEventSource.eventDetectionEnable, AsnUtil.fromAsnBoolean(val), BLocalBacnetDevice.getBacnetContext());
                    return null;
                }
                case 352: {
                    return this.writeMessageTextsConfig(ndx, val);
                }
                case 354: {
                    return this.writeEventAlgorithmInhibit(val);
                }
                case 355: {
                    return this.writeEventAlgorithmInhibitRef(val);
                }
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.fine((Object)((Object)this.getObjectId()) + ": unknown property: " + BBacnetPropertyIdentifier.tag(pId));
            }
            return new NErrorType(2, 32);
        }
        catch (OutOfRangeException e) {
            BBacnetEventEnrollmentDescriptor.logException(Level.INFO, new StringBuilder(this.getObjectId().toString()).append(": OutOfRangeException writing property ").append(BBacnetPropertyIdentifier.tag(pId)), (Exception)((Object)e));
            return new NErrorType(2, 37);
        }
        catch (AsnException e) {
            BBacnetEventEnrollmentDescriptor.logException(Level.INFO, new StringBuilder(this.getObjectId().toString()).append(": AsnException writing property ").append(BBacnetPropertyIdentifier.tag(pId)), (Exception)((Object)e));
            return new NErrorType(2, 9);
        }
        catch (PermissionException e) {
            BBacnetEventEnrollmentDescriptor.logException(Level.INFO, new StringBuilder(this.getObjectId().toString()).append(": PermissionException writing property ").append(BBacnetPropertyIdentifier.tag(pId)), (Exception)((Object)e));
            return new NErrorType(2, 40);
        }
    }

    private ErrorType writeNotifyType(byte[] val) throws AsnException {
        BBacnetNotifyType notifyType = BBacnetNotifyType.make(AsnUtil.fromAsnEnumerated(val));
        if (notifyType.getOrdinal() == 0) {
            return null;
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine((Object)((Object)this.getObjectId()) + ": the notify type must be 'Alarm': attempted value: " + (Object)((Object)notifyType));
        }
        return new NErrorType(2, 37);
    }

    private ErrorType writeEventParameters(byte[] val) throws AsnException {
        BBacnetEventParameter eventParam = new BBacnetEventParameter();
        AsnUtil.fromAsn(-4, val, (BValue)eventParam);
        Context bacnetContext = BLocalBacnetDevice.getBacnetContext();
        bacnetContext.getUser().checkWrite((BComponent)this, (Slot)eventParameter);
        bacnetContext.getUser().checkWrite((BComponent)this, (Slot)typeOfEvent);
        this.checkEventType(eventParam.getChoice());
        ErrorType error = this.writeEventParameters(eventParam);
        if (error != null) {
            return error;
        }
        this.set(eventParameter, (BValue)eventParam, bacnetContext);
        this.set(typeOfEvent, (BValue)BBacnetEventType.make(eventParam.getChoice()), bacnetContext);
        return null;
    }

    private void checkEventType(int eventType) throws OutOfRangeException {
        switch (eventType) {
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 10: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 20: {
                return;
            }
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine((Object)((Object)this.getObjectId()) + ": event type " + BBacnetEventType.tag(eventType) + " is not supported");
        }
        throw new OutOfRangeException("event type " + BBacnetEventType.tag(eventType) + " is not supported");
    }

    private ErrorType writeEventParameters(BBacnetEventParameter eventParam) {
        BComponent target;
        BPointExtension pointExt = (BPointExtension)this.getObject();
        if (pointExt != null) {
            target = (BComponent)pointExt.getParent();
            this.getEventEnable(pointExt);
            this.getNotificationClass(pointExt);
            this.updateEventMessageTextsConfig(pointExt);
            this.updateEventAlgorithmInhibitInfo(pointExt);
        } else {
            target = this.resolveTarget(this.getObjectPropertyReference());
            if (target == null) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine((Object)((Object)this.getObjectId()) + ": eventParameters BACnet property (" + eventParam + ") was written but a target could not be resolved based on the objectPropertyReference: " + this.getObjectPropertyReference());
                }
                return null;
            }
        }
        ErrorType error = this.configureExt(eventParam, pointExt, target);
        if (error != null && logger.isLoggable(Level.FINE)) {
            logger.fine((Object)((Object)this.getObjectId()) + ": error configuring alarm ext while writing EventParameters property: " + eventParam);
        }
        return error;
    }

    private ErrorType writeObjectPropertyReference(byte[] val) throws AsnException {
        BBacnetDeviceObjectPropertyReference objPropRef = new BBacnetDeviceObjectPropertyReference();
        AsnUtil.fromAsn(-4, val, (BValue)objPropRef);
        BComponent newTarget = this.resolveTarget(objPropRef);
        if (newTarget == null) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine((Object)((Object)this.getObjectId()) + ": could not find a target when writing BACnet objectPropertyReference property: " + objPropRef);
            }
            return new NErrorType(2, 37);
        }
        BPointExtension pointExt = (BPointExtension)this.getObject();
        if (pointExt != null) {
            BComponent oldTarget = (BComponent)pointExt.getParent();
            if (oldTarget == newTarget) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine((Object)((Object)this.getObjectId()) + ": BACnet write of Object_Property_Reference points to existing extension's parent: " + objPropRef);
                }
                return null;
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.fine((Object)((Object)this.getObjectId()) + ": BACnet changing Object_Property_Reference to " + objPropRef);
            }
            this.updateEventParameters(pointExt);
            this.getEventEnable(pointExt);
            this.getNotificationClass(pointExt);
            this.updateEventMessageTextsConfig(pointExt);
            this.updateEventAlgorithmInhibitInfo(pointExt);
        } else if (logger.isLoggable(Level.FINE)) {
            logger.fine((Object)((Object)this.getObjectId()) + ": BACnet writing Object_Property_Reference when extension is not yet configured: " + objPropRef);
        }
        this.resetDescriptor();
        ErrorType error = this.configureExt(this.getEventParameter(), null, newTarget);
        if (error != null) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine((Object)((Object)this.getObjectId()) + ": error configuring alarm ext when writing BACnet objectPropertyReference property: " + objPropRef);
            }
        } else {
            this.setObjectPropertyReference(objPropRef);
        }
        return error;
    }

    private ErrorType writeNotificationClass(byte[] val) throws AsnException {
        int instanceNum = AsnUtil.fromAsnUnsignedInt(val);
        Context context = BLocalBacnetDevice.getBacnetContext();
        ErrorType error = this.configureAlarmClass((BPointExtension)this.getObject(), instanceNum, context);
        if (error == null) {
            this.setInt(notificationClassId, instanceNum, context);
        } else if (logger.isLoggable(Level.FINE)) {
            logger.fine((Object)((Object)this.getObjectId()) + ": error in writeNotificationClass");
        }
        return error;
    }

    private static BBacnetNotificationClassDescriptor lookupNotificationClass(int instanceNum) {
        BBacnetObjectIdentifier id = BBacnetObjectIdentifier.make(15, instanceNum);
        return (BBacnetNotificationClassDescriptor)BBacnetNetwork.localDevice().lookupBacnetObject(id);
    }

    private ErrorType writeEventEnable(byte[] val) throws AsnException {
        BBacnetBitString eventEnableBits = AsnUtil.fromAsnBitString(val);
        BAlarmTransitionBits alarmEnable = BacnetBitStringUtil.getBAlarmTransitionBits(eventEnableBits);
        if (alarmEnable == null) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine((Object)((Object)this.getObjectId()) + ": could not write the eventEnable property because the alarm transition bits could not be retrieved for value " + (Object)((Object)eventEnableBits));
            }
            return new NErrorType(2, 37);
        }
        this.eventEnable = alarmEnable;
        BPointExtension pointExt = (BPointExtension)this.getObject();
        if (pointExt instanceof BAlarmSourceExt) {
            pointExt.set(BAlarmSourceExt.alarmEnable, (BValue)alarmEnable, BLocalBacnetDevice.getBacnetContext());
        } else if (pointExt instanceof BBacnetTrendLogAlarmSourceExt) {
            pointExt.set(BBacnetTrendLogAlarmSourceExt.alarmEnable, (BValue)alarmEnable, BLocalBacnetDevice.getBacnetContext());
        } else if (logger.isLoggable(Level.FINE)) {
            logger.fine((Object)((Object)this.getObjectId()) + ": could not write the eventEnable property because the associated point ext is not set or not an AlarmSourceExt or BacnetTrendLogAlarmSourceExt");
        }
        return null;
    }

    private ErrorType writeMessageTextsConfig(int ndx, byte[] val) throws AsnException {
        if (ndx < -1 || ndx > 3) {
            return new NErrorType(2, 42);
        }
        if (ndx == 0) {
            return new NErrorType(2, 40);
        }
        switch (ndx) {
            case -1: {
                BBacnetArray textsConfig = new BBacnetArray(BString.TYPE, 3);
                AsnUtil.fromAsn(-4, val, (BValue)textsConfig);
                this.toOffnormalText = textsConfig.getElement(1).toString(null);
                this.toFaultText = textsConfig.getElement(2).toString(null);
                this.toNormalText = textsConfig.getElement(3).toString(null);
                break;
            }
            case 1: {
                this.toOffnormalText = AsnUtil.fromAsnCharacterString(val);
                break;
            }
            case 2: {
                this.toFaultText = AsnUtil.fromAsnCharacterString(val);
                break;
            }
            case 3: {
                this.toNormalText = AsnUtil.fromAsnCharacterString(val);
            }
        }
        BPointExtension pointExt = (BPointExtension)this.getObject();
        if (pointExt instanceof BAlarmSourceExt) {
            BAlarmSourceExt alarmExt = (BAlarmSourceExt)pointExt;
            Context context = BLocalBacnetDevice.getBacnetContext();
            switch (ndx) {
                case -1: {
                    alarmExt.set(BAlarmSourceExt.toOffnormalText, (BValue)BFormat.make((String)this.toOffnormalText), context);
                    alarmExt.set(BAlarmSourceExt.toFaultText, (BValue)BFormat.make((String)this.toFaultText), context);
                    alarmExt.set(BAlarmSourceExt.toNormalText, (BValue)BFormat.make((String)this.toNormalText), context);
                    BBacnetEventEnrollmentDescriptor.resetOutOfRangeTexts(alarmExt);
                    break;
                }
                case 1: {
                    alarmExt.set(BAlarmSourceExt.toOffnormalText, (BValue)BFormat.make((String)this.toOffnormalText), context);
                    BBacnetEventEnrollmentDescriptor.resetOutOfRangeTexts(alarmExt);
                    break;
                }
                case 2: {
                    alarmExt.set(BAlarmSourceExt.toFaultText, (BValue)BFormat.make((String)this.toFaultText), context);
                    break;
                }
                case 3: {
                    alarmExt.set(BAlarmSourceExt.toNormalText, (BValue)BFormat.make((String)this.toNormalText), context);
                }
            }
        } else if (pointExt instanceof BBacnetTrendLogAlarmSourceExt) {
            BBacnetTrendLogAlarmSourceExt trendAlarmExt = (BBacnetTrendLogAlarmSourceExt)pointExt;
            switch (ndx) {
                case -1: {
                    if (!this.toOffnormalText.isEmpty() || !this.toFaultText.isEmpty()) {
                        return new NErrorType(2, 40);
                    }
                    trendAlarmExt.set(BBacnetTrendLogAlarmSourceExt.toNormalText, (BValue)BFormat.make((String)this.toNormalText), BLocalBacnetDevice.getBacnetContext());
                    break;
                }
                case 1: {
                    if (this.toOffnormalText.isEmpty()) break;
                    return new NErrorType(2, 40);
                }
                case 2: {
                    if (this.toFaultText.isEmpty()) break;
                    return new NErrorType(2, 40);
                }
                case 3: {
                    trendAlarmExt.set(BBacnetTrendLogAlarmSourceExt.toNormalText, (BValue)BFormat.make((String)this.toNormalText), BLocalBacnetDevice.getBacnetContext());
                }
            }
        } else if (logger.isLoggable(Level.FINE)) {
            logger.fine((Object)((Object)this.getObjectId()) + ": could not write the eventMessageTextsConfig property because the associated point ext is not set or not an AlarmSourceExt or BacnetTrendLogAlarmSourceExt");
        }
        return null;
    }

    private ErrorType writeEventAlgorithmInhibit(byte[] val) throws AsnException {
        boolean newValue = AsnUtil.fromAsnBoolean(val);
        if (!this.getEventDetectionEnable()) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine((Object)((Object)this.getObjectId()) + ": could not write the alarmInhibit property because event detection is disabled");
            }
            return new NErrorType(2, 40);
        }
        BPointExtension pointExt = (BPointExtension)this.getObject();
        if (pointExt != null) {
            BLink[] alarmInhibitLinks = BBacnetEventEnrollmentDescriptor.getAlarmInhibitLinks(pointExt);
            if (alarmInhibitLinks.length > 0) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine((Object)((Object)this.getObjectId()) + ": could not write the eventAlgorithmInhibit property because alarmInhibit is linked");
                }
                return new NErrorType(2, 40);
            }
            if (pointExt instanceof BAlarmSourceExt) {
                pointExt.set(BAlarmSourceExt.alarmInhibit, (BValue)new BStatusBoolean(newValue), BLocalBacnetDevice.getBacnetContext());
            } else if (pointExt instanceof BBacnetTrendLogAlarmSourceExt) {
                pointExt.set(BBacnetTrendLogAlarmSourceExt.alarmInhibit, (BValue)new BStatusBoolean(newValue), BLocalBacnetDevice.getBacnetContext());
            }
        } else if (this.eventAlgorithmInhibitRef.getObjectId().getInstanceNumber() != 0x3FFFFF) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine((Object)((Object)this.getObjectId()) + ": could not write the eventAlgorithmInhibit property because eventAlgorithmInhibitRef (" + this.eventAlgorithmInhibitRef + ") is configured");
            }
            return new NErrorType(2, 40);
        }
        this.eventAlgorithmInhibit = newValue;
        return null;
    }

    private static BLink[] getAlarmInhibitLinks(BPointExtension pointExt) {
        if (pointExt instanceof BAlarmSourceExt) {
            return pointExt.getLinks((Slot)BAlarmSourceExt.alarmInhibit);
        }
        if (pointExt instanceof BBacnetTrendLogAlarmSourceExt) {
            return pointExt.getLinks((Slot)BBacnetTrendLogAlarmSourceExt.alarmInhibit);
        }
        return EMPTY_LINKS_ARRAY;
    }

    private ErrorType writeEventAlgorithmInhibitRef(byte[] val) throws AsnException {
        BBooleanPoint sourcePoint;
        BBacnetObjectPropertyReference newObjPropRef = new BBacnetObjectPropertyReference();
        AsnUtil.fromAsn(val, (BValue)newObjPropRef);
        Context context = BLocalBacnetDevice.getBacnetContext();
        if (newObjPropRef.getObjectId().getInstanceNumber() == 0x3FFFFF) {
            this.eventAlgorithmInhibitRef = newObjPropRef;
            this.removeAlarmInhibitLinks((BPointExtension)this.getObject(), context);
            return null;
        }
        try {
            sourcePoint = BBacnetEventEnrollmentDescriptor.findEventAlgorithmInhibitSourcePoint(newObjPropRef);
        }
        catch (EventEnrollmentException e) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine((Object)((Object)this.getObjectId()) + ": error adding eventAlgorithmInhibitRef link; message: " + e.getMessage());
            }
            return e.errorType;
        }
        BBacnetEventEnrollmentDescriptor.checkLinkPermissions((BComponent)sourcePoint, "out", context);
        BPointExtension pointExt = (BPointExtension)this.getObject();
        if (pointExt instanceof BAlarmSourceExt) {
            BBacnetEventEnrollmentDescriptor.replaceLinks((BComponent)pointExt, BAlarmSourceExt.alarmInhibit, (BComponent)sourcePoint, context);
        } else if (pointExt instanceof BBacnetTrendLogAlarmSourceExt) {
            BBacnetEventEnrollmentDescriptor.replaceLinks((BComponent)pointExt, BBacnetTrendLogAlarmSourceExt.alarmInhibit, (BComponent)sourcePoint, context);
        }
        this.eventAlgorithmInhibitRef = newObjPropRef;
        return null;
    }

    private void removeAlarmInhibitLinks(BPointExtension pointExt, Context context) {
        if (pointExt != null) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine((Object)((Object)this.getObjectId()) + ": removing links to alarmInhibit because eventAlgorithmInhibitRef is set to the unconfigured instance number " + 0x3FFFFF);
            }
            for (BLink link : BBacnetEventEnrollmentDescriptor.getAlarmInhibitLinks(pointExt)) {
                pointExt.remove(link.getPropertyInParent(), context);
            }
        }
    }

    private static BBooleanPoint findEventAlgorithmInhibitSourcePoint(BBacnetObjectPropertyReference objPropRef) throws EventEnrollmentException {
        BComponent sourcePoint;
        int newObjectType = objPropRef.getObjectId().getObjectType();
        if (newObjectType != 3 && newObjectType != 4 && newObjectType != 5) {
            throw new EventEnrollmentException("EventAlgorithmInhibitRef is to non-binary object type " + BBacnetObjectType.tag(newObjectType), new NErrorType(2, 37));
        }
        try {
            sourcePoint = BacnetDescriptorUtil.findLocalPoint(objPropRef);
        }
        catch (Exception e) {
            BBacnetEventEnrollmentDescriptor.logException(Level.SEVERE, new StringBuilder(objPropRef.getObjectId().toString()).append(": could not resolve the point for objectPropertyReference ").append(objPropRef), e);
            throw new EventEnrollmentException("Could not resolve point for eventAlgorithmInhibitRef " + objPropRef, new NErrorType(2, 37));
        }
        if (!(sourcePoint instanceof BBooleanPoint)) {
            throw new EventEnrollmentException("eventAlgorithmRef (" + objPropRef + ") point is type " + sourcePoint.getType() + " but should be instanceof BooleanPoint", new NErrorType(2, 37));
        }
        return (BBooleanPoint)sourcePoint;
    }

    private ErrorType configureExt(BBacnetEventParameter eventParam, BPointExtension pointExt, BComponent target) {
        try {
            int eventType = eventParam.getChoice();
            switch (eventType) {
                case 1: {
                    this.configureChangeOfStateExt(eventParam, pointExt, target);
                    break;
                }
                case 3: {
                    this.configureCommandFailureExt(eventParam, pointExt, target);
                    break;
                }
                case 4: {
                    this.configureFloatingLimitExt(eventParam, pointExt, target);
                    break;
                }
                case 5: 
                case 14: 
                case 15: 
                case 16: {
                    this.configureOutOfRangeExt(eventParam, pointExt, target);
                    break;
                }
                case 10: {
                    this.configureTrendAlarmExt(eventParam, pointExt, target);
                    break;
                }
                case 17: {
                    this.configureStringChangeOfStateExt(eventParam, pointExt, target);
                    break;
                }
                case 20: {
                    this.configureNoneExt();
                    break;
                }
                default: {
                    throw new EventEnrollmentException("event type " + BBacnetEventType.tag(eventType) + " is not supported", new NErrorType(2, 45));
                }
            }
            return null;
        }
        catch (EventEnrollmentException e) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine((Object)((Object)this.getObjectId()) + ": error configuring alarm ext; message: " + e.getMessage());
            }
            this.resetDescriptor();
            return e.errorType;
        }
        catch (PermissionException e) {
            BBacnetEventEnrollmentDescriptor.logException(Level.INFO, new StringBuilder(this.getObjectId().toString()).append(": permission exception configuring alarm ext"), (Exception)((Object)e));
            this.resetDescriptor();
            return new NErrorType(2, 40);
        }
        catch (Exception e) {
            BBacnetEventEnrollmentDescriptor.logException(Level.INFO, new StringBuilder(this.getObjectId().toString()).append(": unexpected error configuring alarm ext"), e);
            this.resetDescriptor();
            return new NErrorType(2, 0);
        }
    }

    private void configureAlarmExt(BBacnetEventParameter eventParam, BAlarmSourceExt alarmExt) {
        Context context = BLocalBacnetDevice.getBacnetContext();
        BBacnetEventEnrollmentDescriptor.configureTimeDelays(eventParam, alarmExt, context);
        alarmExt.set(BAlarmSourceExt.alarmEnable, (BValue)this.eventEnable, context);
        this.configureAlarmClass((BPointExtension)alarmExt, this.getNotificationClassId(), context);
        alarmExt.set(BAlarmSourceExt.toOffnormalText, (BValue)BFormat.make((String)this.toOffnormalText), context);
        alarmExt.set(BAlarmSourceExt.toFaultText, (BValue)BFormat.make((String)this.toFaultText), context);
        alarmExt.set(BAlarmSourceExt.toNormalText, (BValue)BFormat.make((String)this.toNormalText), context);
        this.configureAlarmInhibit((BPointExtension)alarmExt, context);
    }

    private static void configureTimeDelays(BBacnetEventParameter eventParam, BAlarmSourceExt ext, Context context) {
        BRelTime timeDelay = BRelTime.makeSeconds((int)((BBacnetUnsigned)eventParam.get("timeDelay")).getInt());
        ext.set(BAlarmSourceExt.timeDelay, (BValue)timeDelay, context);
        ext.set(BAlarmSourceExt.timeDelayToNormal, (BValue)timeDelay, context);
    }

    private ErrorType configureAlarmClass(BPointExtension ext, int instanceNum, Context context) {
        String alarmClassName;
        if (instanceNum < 0 || instanceNum > 0x3FFFFF) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine((Object)((Object)this.getObjectId()) + ": configureAlarmClass: notification class instance number " + instanceNum + " exceeds the maximum allowable instance number value");
            }
            return new NErrorType(2, 37);
        }
        if (instanceNum == 0x3FFFFF) {
            alarmClassName = "";
        } else {
            BBacnetNotificationClassDescriptor descriptor = BBacnetEventEnrollmentDescriptor.lookupNotificationClass(instanceNum);
            if (descriptor == null) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine((Object)((Object)this.getObjectId()) + ": configureAlarmClass: cannot find descriptor for notification class instance number " + instanceNum);
                }
                return new NErrorType(2, 37);
            }
            BAlarmClass alarmClass = descriptor.getAlarmClass();
            if (alarmClass == null) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine((Object)((Object)this.getObjectId()) + ": configureAlarmClass: descriptor for notification class instance number " + instanceNum + " could not resolve its alarm class");
                }
                return new NErrorType(2, 0);
            }
            alarmClassName = alarmClass.getName();
        }
        if (ext instanceof BAlarmSourceExt) {
            ext.setString(BAlarmSourceExt.alarmClass, alarmClassName, context);
        } else if (ext instanceof BBacnetTrendLogAlarmSourceExt) {
            ext.setString(BBacnetTrendLogAlarmSourceExt.alarmClass, alarmClassName, context);
        } else if (logger.isLoggable(Level.FINE)) {
            logger.fine((Object)((Object)this.getObjectId()) + ": configureAlarmClass: no associated point ext on which to update the alarm class based on notification-class instance number " + instanceNum);
        }
        return null;
    }

    private void configureAlarmInhibit(BPointExtension ext, Context context) {
        boolean isLinked = this.addAlarmInhibitLink(ext, context);
        if (!isLinked) {
            if (ext instanceof BAlarmSourceExt) {
                ((BAlarmSourceExt)ext).setAlarmInhibit(new BStatusBoolean(this.eventAlgorithmInhibit));
            } else if (ext instanceof BBacnetTrendLogAlarmSourceExt) {
                ((BBacnetTrendLogAlarmSourceExt)ext).setAlarmInhibit(new BStatusBoolean(this.eventAlgorithmInhibit));
            }
        }
    }

    private boolean addAlarmInhibitLink(BPointExtension ext, Context context) {
        if (this.eventAlgorithmInhibitRef.getObjectId().getInstanceNumber() == 0x3FFFFF) {
            this.removeAlarmInhibitLinks(ext, context);
            return false;
        }
        try {
            BBooleanPoint sourcePoint = BBacnetEventEnrollmentDescriptor.findEventAlgorithmInhibitSourcePoint(this.eventAlgorithmInhibitRef);
            BBacnetEventEnrollmentDescriptor.checkLinkPermissions((BComponent)sourcePoint, "out", context);
            if (ext instanceof BAlarmSourceExt) {
                BBacnetEventEnrollmentDescriptor.replaceLinks((BComponent)ext, BAlarmSourceExt.alarmInhibit, (BComponent)sourcePoint, context);
                return true;
            }
            if (ext instanceof BBacnetTrendLogAlarmSourceExt) {
                BBacnetEventEnrollmentDescriptor.replaceLinks((BComponent)ext, BBacnetTrendLogAlarmSourceExt.alarmInhibit, (BComponent)sourcePoint, context);
                return true;
            }
            if (logger.isLoggable(Level.WARNING)) {
                logger.log(Level.WARNING, (Object)((Object)this.getObjectId()) + ": when adding alarm inhibit link, type not supported: " + ext.getType());
            }
            return false;
        }
        catch (Exception e) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, (Object)((Object)this.getObjectId()) + ": error adding eventAlgorithmInhibitRef link", e);
            }
            return false;
        }
    }

    private void configureGeneralFaultAlgorithm(BBacnetEventParameter eventParam, BAlarmSourceExt ext) {
        BFaultAlgorithm faultAlgorithm = ext.getFaultAlgorithm();
        if (!(ext.getFaultAlgorithm() instanceof BFaultAlgorithm)) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine((Object)((Object)this.getObjectId()) + ": replacing fault algorithm of type " + faultAlgorithm.getType() + " with FaultAlgorithm for event type " + BBacnetEventType.tag(eventParam.getChoice()));
            }
            ext.set(BAlarmSourceExt.faultAlgorithm, (BValue)new BFaultAlgorithm(), BLocalBacnetDevice.getBacnetContext());
        }
    }

    private BAlarmSourceExt updateToAlarmExt(BPointExtension pointExt) {
        if (!(pointExt instanceof BAlarmSourceExt)) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine((Object)((Object)this.getObjectId()) + ": replacing point extension of type " + (pointExt != null ? pointExt.getType() : null) + " with BAlarmExt");
            }
            return new BAlarmSourceExt();
        }
        return (BAlarmSourceExt)pointExt;
    }

    private BBacnetTrendLogAlarmSourceExt updateToTrendAlarmExt(BPointExtension pointExt) {
        if (!(pointExt instanceof BBacnetTrendLogAlarmSourceExt)) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine((Object)((Object)this.getObjectId()) + ": replacing point extension of type " + (pointExt != null ? pointExt.getType() : null) + " with BBacnetTrendLogAlarmSourceExt");
            }
            return new BBacnetTrendLogAlarmSourceExt();
        }
        return (BBacnetTrendLogAlarmSourceExt)pointExt;
    }

    private static void addExtIfMissing(BPointExtension pointExt, BComponent target) {
        if (pointExt.getParent() == null) {
            target.add("EventEnrollmentAlarmExt?", (BValue)pointExt, BLocalBacnetDevice.getBacnetContext());
        }
    }

    private void configureNoneExt() {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine((Object)((Object)this.getObjectId()) + ": resetting the descriptor because event type is none");
        }
        this.resetDescriptor();
    }

    private void configureChangeOfStateExt(BBacnetEventParameter eventParam, BPointExtension pointExt, BComponent target) throws EventEnrollmentException {
        BAlarmSourceExt alarmExt;
        if (target instanceof BBooleanPoint || target instanceof BEnumPoint) {
            alarmExt = this.updateToAlarmExt(pointExt);
            this.configureAlarmExt(eventParam, alarmExt);
            if (target instanceof BBooleanPoint) {
                this.configureBooleanChangeOfStateOffnormal(eventParam, alarmExt);
            } else {
                this.configureEnumChangeOfStateOffnormal(eventParam, alarmExt, (BEnumPoint)target);
            }
        } else {
            throw new EventEnrollmentException("referenced object is of type " + target.getType() + " and not instanceof BooleanPoint or EnumPoint, which is required for change-of-state extensions; event type: " + BBacnetEventType.tag(eventParam.getChoice()), new NErrorType(2, 37));
        }
        this.configureGeneralFaultAlgorithm(eventParam, alarmExt);
        BBacnetEventEnrollmentDescriptor.addExtIfMissing((BPointExtension)alarmExt, target);
        this.updateDescriptor((BPointExtension)alarmExt);
    }

    private void configureBooleanChangeOfStateOffnormal(BBacnetEventParameter eventParam, BAlarmSourceExt alarmExt) throws EventEnrollmentException {
        BOffnormalAlgorithm offnormalAlgorithm = alarmExt.getOffnormalAlgorithm();
        if (offnormalAlgorithm instanceof BBooleanChangeOfStateAlgorithm) {
            BBacnetEventEnrollmentDescriptor.configureBooleanChangeOfStateOffnormal(eventParam, (BBooleanChangeOfStateAlgorithm)offnormalAlgorithm);
        } else {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine((Object)((Object)this.getObjectId()) + ": replacing offnormal algorithm of type " + offnormalAlgorithm.getType() + " with BooleanChangeOfStateAlgorithm for event type " + BBacnetEventType.tag(eventParam.getChoice()));
            }
            BBooleanChangeOfStateAlgorithm changeOfStateAlgorithm = new BBooleanChangeOfStateAlgorithm();
            BBacnetEventEnrollmentDescriptor.configureBooleanChangeOfStateOffnormal(eventParam, changeOfStateAlgorithm);
            alarmExt.set(BAlarmSourceExt.offnormalAlgorithm, (BValue)changeOfStateAlgorithm, BLocalBacnetDevice.getBacnetContext());
        }
    }

    private static void configureBooleanChangeOfStateOffnormal(BBacnetEventParameter eventParam, BBooleanChangeOfStateAlgorithm algorithm) throws EventEnrollmentException {
        boolean alarmValue;
        BBacnetListOf listOfValues = (BBacnetListOf)eventParam.get("listOfValues");
        BBacnetPropertyStates[] propStates = (BBacnetPropertyStates[])listOfValues.getChildren(BBacnetPropertyStates.class);
        if (propStates.length < 1) {
            throw new EventEnrollmentException("boolean change-of-state alarm extensions require at least 1 alarm value; event type: " + BBacnetEventType.tag(eventParam.getChoice()), new NErrorType(2, 37));
        }
        switch (propStates[0].getChoice()) {
            case 0: {
                alarmValue = ((BBoolean)propStates[0].get("booleanValue")).getBoolean();
                break;
            }
            case 1: {
                alarmValue = ((BBacnetBinaryPv)propStates[0].get("binaryValue")).isActive();
                break;
            }
            default: {
                throw new EventEnrollmentException("boolean change-of-state alarm extensions require a BOOLEAN (0) or BACnetBinaryPv (1) value; found: " + propStates[0].getChoice() + ", event type: " + BBacnetEventType.tag(eventParam.getChoice()), new NErrorType(2, 37));
            }
        }
        algorithm.setBoolean(BBooleanChangeOfStateAlgorithm.alarmValue, alarmValue, BLocalBacnetDevice.getBacnetContext());
    }

    private void configureEnumChangeOfStateOffnormal(BBacnetEventParameter eventParam, BAlarmSourceExt alarmExt, BEnumPoint point) throws EventEnrollmentException {
        BOffnormalAlgorithm offnormalAlgorithm = alarmExt.getOffnormalAlgorithm();
        if (offnormalAlgorithm instanceof BEnumChangeOfStateAlgorithm) {
            BBacnetEventEnrollmentDescriptor.configureEnumChangeOfStateOffnormal(eventParam, (BEnumChangeOfStateAlgorithm)offnormalAlgorithm, point);
        } else {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine((Object)((Object)this.getObjectId()) + ": replacing offnormal algorithm of type " + offnormalAlgorithm.getType() + " with EnumChangeOfStateAlgorithm for event type " + BBacnetEventType.tag(eventParam.getChoice()));
            }
            BEnumChangeOfStateAlgorithm changeOfStateAlgorithm = new BEnumChangeOfStateAlgorithm();
            BBacnetEventEnrollmentDescriptor.configureEnumChangeOfStateOffnormal(eventParam, changeOfStateAlgorithm, point);
            alarmExt.set(BAlarmSourceExt.offnormalAlgorithm, (BValue)changeOfStateAlgorithm, BLocalBacnetDevice.getBacnetContext());
        }
    }

    private static void configureEnumChangeOfStateOffnormal(BBacnetEventParameter eventParam, BEnumChangeOfStateAlgorithm algorithm, BEnumPoint point) throws EventEnrollmentException {
        BBacnetListOf listOfValues = (BBacnetListOf)eventParam.get("listOfValues");
        BBacnetPropertyStates[] propStates = (BBacnetPropertyStates[])listOfValues.getChildren(BBacnetPropertyStates.class);
        BEnumRange range = (BEnumRange)point.getFacets().get("range");
        int[] ordinals = new int[propStates.length];
        String[] tags = new String[propStates.length];
        for (int i = 0; i < propStates.length; ++i) {
            if (propStates[i].getChoice() != 11) {
                throw new EventEnrollmentException("enum change-of-state alarm extensions require an UNSIGNED (11) value; found: " + propStates[i].getChoice() + ", event type: " + BBacnetEventType.tag(eventParam.getChoice()), new NErrorType(2, 37));
            }
            BBacnetUnsigned child = (BBacnetUnsigned)propStates[i].get("unsignedValue");
            ordinals[i] = child.getInt();
            tags[i] = range != null ? SlotPath.escape((String)range.getTag(ordinals[i])) : SlotPath.escape((String)String.valueOf(ordinals[i]));
        }
        algorithm.set(BEnumChangeOfStateAlgorithm.alarmValues, (BValue)BEnumRange.make((int[])ordinals, (String[])tags), BLocalBacnetDevice.getBacnetContext());
    }

    private void configureCommandFailureExt(BBacnetEventParameter eventParam, BPointExtension pointExt, BComponent target) throws EventEnrollmentException {
        BAlarmSourceExt alarmExt;
        if (target instanceof BBooleanPoint || target instanceof BEnumPoint) {
            alarmExt = this.updateToAlarmExt(pointExt);
            this.configureAlarmExt(eventParam, alarmExt);
            if (target instanceof BBooleanPoint) {
                this.configureBooleanCommandFailureOffnormal(eventParam, alarmExt);
                this.configureGeneralFaultAlgorithm(eventParam, alarmExt);
            } else {
                this.configureEnumCommandFailureOffnormal(eventParam, alarmExt);
                this.configureEnumCommandFailureFault(eventParam, alarmExt);
            }
        } else {
            throw new EventEnrollmentException("referenced object is of type " + target.getType() + " and not instanceof BooleanPoint or EnumPoint, which is required for command failure extensions; event type: " + BBacnetEventType.tag(eventParam.getChoice()), new NErrorType(2, 37));
        }
        BBacnetEventEnrollmentDescriptor.addExtIfMissing((BPointExtension)alarmExt, target);
        this.updateDescriptor((BPointExtension)alarmExt);
    }

    private void configureBooleanCommandFailureOffnormal(BBacnetEventParameter eventParam, BAlarmSourceExt alarmExt) throws EventEnrollmentException {
        BOffnormalAlgorithm offnormalAlgorithm = alarmExt.getOffnormalAlgorithm();
        if (offnormalAlgorithm instanceof BBooleanCommandFailureAlgorithm) {
            this.configureBooleanCommandFailureOffnormal(eventParam, (BBooleanCommandFailureAlgorithm)offnormalAlgorithm);
        } else {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine((Object)((Object)this.getObjectId()) + ": replacing offnormal algorithm of type " + offnormalAlgorithm.getType() + " with BooleanCommandFailureAlgorithm for event type " + BBacnetEventType.tag(eventParam.getChoice()));
            }
            BBooleanCommandFailureAlgorithm commandFailureAlgorithm = new BBooleanCommandFailureAlgorithm();
            this.configureBooleanCommandFailureOffnormal(eventParam, commandFailureAlgorithm);
            alarmExt.set(BAlarmSourceExt.offnormalAlgorithm, (BValue)commandFailureAlgorithm, BLocalBacnetDevice.getBacnetContext());
        }
    }

    private void configureBooleanCommandFailureOffnormal(BBacnetEventParameter eventParam, BBooleanCommandFailureAlgorithm algorithm) throws EventEnrollmentException {
        BComponent feedbackPoint = this.getCommandFailureFeedbackPoint(eventParam);
        if (!(feedbackPoint instanceof BBooleanPoint)) {
            throw new EventEnrollmentException("feedback point for boolean command failure is type " + feedbackPoint.getType() + " but should be instanceof BooleanPoint", new NErrorType(2, 37));
        }
        Context context = BLocalBacnetDevice.getBacnetContext();
        BBacnetEventEnrollmentDescriptor.checkLinkPermissions(feedbackPoint, "out", context);
        BBacnetEventEnrollmentDescriptor.replaceLinks((BComponent)algorithm, BBooleanCommandFailureAlgorithm.feedbackValue, feedbackPoint, context);
    }

    private static void replaceLinks(BComponent target, Property targetSlot, BComponent source, Context context) {
        BLink existingLink = null;
        for (BLink link : target.getLinks((Slot)targetSlot)) {
            if (!link.getSourceOrd().equals((Object)source.getHandleOrd()) || !link.getSourceSlotName().equals("out") || existingLink != null) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("Before adding a link to feedback point, cleared link to source ord " + link.getSourceOrd() + " and source slot " + link.getSourceSlotName());
                }
                target.remove(link.getPropertyInParent(), context);
                continue;
            }
            existingLink = link;
        }
        if (existingLink == null) {
            target.add(null, (BValue)new BLink(source.getHandleOrd(), "out", targetSlot.getName(), true), context);
        }
    }

    private BBacnetDeviceObjectPropertyReference getLinkedPropertyReference(BComponent component, Property targetSlot, Type targetDescType) {
        BLink[] targetSlotLinks;
        for (BLink link : targetSlotLinks = component.getLinks((Slot)targetSlot)) {
            BAbstractProxyExt proxyExt;
            if (!link.getSourceSlotName().equals("out") || !link.isActive() || !link.isEnabled()) continue;
            BComponent source = link.getSourceComponent();
            if (source instanceof BControlPoint && (proxyExt = ((BControlPoint)source).getProxyExt()) instanceof BBacnetProxyExt) {
                return BBacnetEventEnrollmentDescriptor.makeRemoteDeviceObjPropRef((BBacnetProxyExt)proxyExt);
            }
            BIBacnetExportObject descriptor = this.findDescriptor(source.getHandleOrd());
            if (descriptor == null || !descriptor.getType().is(targetDescType)) continue;
            return BBacnetEventEnrollmentDescriptor.makeLocalDeviceObjPropRef(descriptor.getObjectId());
        }
        return BBacnetEventEnrollmentDescriptor.makeUnconfiguredDeviceObjPropRef();
    }

    private static BBacnetDeviceObjectPropertyReference makeUnconfiguredDeviceObjPropRef() {
        return new BBacnetDeviceObjectPropertyReference(BBacnetObjectIdentifier.make(0, 0x3FFFFF), 85, -1, BBacnetObjectIdentifier.make(8, 0x3FFFFF));
    }

    private static BBacnetDeviceObjectPropertyReference makeLocalDeviceObjPropRef(BBacnetObjectIdentifier objectId) {
        return new BBacnetDeviceObjectPropertyReference(objectId, 85, -1, BBacnetNetwork.localDevice().getObjectId());
    }

    private static BBacnetDeviceObjectPropertyReference makeRemoteDeviceObjPropRef(BBacnetProxyExt proxyExt) {
        return new BBacnetDeviceObjectPropertyReference(proxyExt.getObjectId(), proxyExt.getPropertyId().getOrdinal(), proxyExt.getPropertyArrayIndex(), proxyExt.device().getObjectId());
    }

    private static void checkLinkPermissions(BComponent source, String sourceSlotName, Context context) {
        BUser user;
        BUser bUser = user = context != null ? context.getUser() : null;
        if (user == null) {
            return;
        }
        user.checkWrite(source, source.getSlot(sourceSlotName));
    }

    private void configureEnumCommandFailureOffnormal(BBacnetEventParameter eventParam, BAlarmSourceExt alarmExt) throws EventEnrollmentException {
        BOffnormalAlgorithm offnormalAlgorithm = alarmExt.getOffnormalAlgorithm();
        if (offnormalAlgorithm instanceof BEnumCommandFailureAlgorithm) {
            this.configureEnumCommandFailureOffnormal(eventParam, (BEnumCommandFailureAlgorithm)offnormalAlgorithm);
        } else {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine((Object)((Object)this.getObjectId()) + ": replacing offnormal algorithm of type " + offnormalAlgorithm.getType() + " with EnumCommandFailureAlgorithm for event type " + BBacnetEventType.tag(eventParam.getChoice()));
            }
            BEnumCommandFailureAlgorithm commandFailureAlgorithm = new BEnumCommandFailureAlgorithm();
            this.configureEnumCommandFailureOffnormal(eventParam, commandFailureAlgorithm);
            alarmExt.set(BAlarmSourceExt.offnormalAlgorithm, (BValue)commandFailureAlgorithm, BLocalBacnetDevice.getBacnetContext());
        }
    }

    private void configureEnumCommandFailureOffnormal(BBacnetEventParameter eventParam, BEnumCommandFailureAlgorithm algorithm) throws EventEnrollmentException {
        BComponent feedbackPoint = this.getCommandFailureFeedbackPoint(eventParam);
        if (!(feedbackPoint instanceof BEnumPoint)) {
            throw new EventEnrollmentException("feedback point for enum command failure is type " + feedbackPoint.getType() + " but should be instanceof EnumPoint", new NErrorType(2, 37));
        }
        Context context = BLocalBacnetDevice.getBacnetContext();
        BBacnetEventEnrollmentDescriptor.checkLinkPermissions(feedbackPoint, "out", context);
        BBacnetEventEnrollmentDescriptor.replaceLinks((BComponent)algorithm, BEnumCommandFailureAlgorithm.feedbackValue, feedbackPoint, context);
    }

    private void configureEnumCommandFailureFault(BBacnetEventParameter eventParam, BAlarmSourceExt alarmExt) {
        BFaultAlgorithm faultAlgorithm = alarmExt.getFaultAlgorithm();
        if (!(alarmExt.getFaultAlgorithm() instanceof BEnumFaultAlgorithm)) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine((Object)((Object)this.getObjectId()) + ": replacing fault algorithm of type " + faultAlgorithm.getType() + " with EnumFaultAlgorithm for event type " + BBacnetEventType.tag(eventParam.getChoice()));
            }
            alarmExt.set(BAlarmSourceExt.faultAlgorithm, (BValue)new BEnumFaultAlgorithm(), BLocalBacnetDevice.getBacnetContext());
        }
    }

    private BComponent getCommandFailureFeedbackPoint(BBacnetEventParameter eventParam) throws EventEnrollmentException {
        BValue feedbackRef = eventParam.get("feedbackPropertyReference");
        if (!(feedbackRef instanceof BBacnetDeviceObjectPropertyReference)) {
            throw new EventEnrollmentException("feedback reference for command failure is type " + (feedbackRef != null ? feedbackRef.getType() : null) + " but should be instanceof BacnetDeviceObjectPropertyReference", new NErrorType(2, 37));
        }
        try {
            return BacnetDescriptorUtil.findLocalOrRemotePoint((BBacnetDeviceObjectPropertyReference)feedbackRef);
        }
        catch (Exception e) {
            BBacnetEventEnrollmentDescriptor.logException(Level.FINE, new StringBuilder(this.getObjectId().toString()).append(": error finding point for command failure feedback ref"), e);
            throw new EventEnrollmentException("error finding point for command failure feedback ref", new NErrorType(2, 37));
        }
    }

    private void configureFloatingLimitExt(BBacnetEventParameter eventParam, BPointExtension pointExt, BComponent target) throws EventEnrollmentException {
        if (!(target instanceof BNumericPoint)) {
            throw new EventEnrollmentException("referenced object is of type " + target.getType() + " and not instanceof NumericPoint, which is required for Floating Limit Algorithm extensions; event type: " + BBacnetEventType.tag(eventParam.getChoice()), new NErrorType(2, 37));
        }
        BAlarmSourceExt alarmExt = this.updateToAlarmExt(pointExt);
        this.configureAlarmExt(eventParam, alarmExt);
        this.configureFloatingLimitOffnormal(eventParam, alarmExt);
        this.configureGeneralFaultAlgorithm(eventParam, alarmExt);
        BBacnetEventEnrollmentDescriptor.addExtIfMissing((BPointExtension)alarmExt, target);
        this.updateDescriptor((BPointExtension)alarmExt);
    }

    private void configureFloatingLimitOffnormal(BBacnetEventParameter eventParam, BAlarmSourceExt alarmExt) throws EventEnrollmentException {
        BOffnormalAlgorithm offnormalAlgorithm = alarmExt.getOffnormalAlgorithm();
        if (offnormalAlgorithm instanceof BFloatingLimitAlgorithm) {
            this.configureFloatingLimitOffnormal(eventParam, (BFloatingLimitAlgorithm)offnormalAlgorithm);
        } else {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine((Object)((Object)this.getObjectId()) + ": replacing offnormal algorithm of type " + offnormalAlgorithm.getType() + " with BFloatingLimitAlgorithm for event type " + BBacnetEventType.tag(eventParam.getChoice()));
            }
            BFloatingLimitAlgorithm floatingLimitAlgorithm = new BFloatingLimitAlgorithm();
            this.configureFloatingLimitOffnormal(eventParam, floatingLimitAlgorithm);
            alarmExt.set(BAlarmSourceExt.offnormalAlgorithm, (BValue)floatingLimitAlgorithm, BLocalBacnetDevice.getBacnetContext());
        }
    }

    private void configureFloatingLimitOffnormal(BBacnetEventParameter eventParam, BFloatingLimitAlgorithm algorithm) throws EventEnrollmentException {
        BComponent setpoint = this.getFloatingLimitSetpoint(eventParam);
        if (!(setpoint instanceof BNumericPoint)) {
            throw new EventEnrollmentException("feedback point for floating limit is type " + setpoint.getType() + " but should be instanceof BNumericPoint", new NErrorType(2, 37));
        }
        Context context = BLocalBacnetDevice.getBacnetContext();
        BBacnetEventEnrollmentDescriptor.checkLinkPermissions(setpoint, "out", context);
        BBacnetEventEnrollmentDescriptor.replaceLinks((BComponent)algorithm, BFloatingLimitAlgorithm.setpoint, setpoint, context);
        algorithm.setDouble(BFloatingLimitAlgorithm.lowDiffLimit, ((BNumber)eventParam.get("lowDiffLimit")).getDouble(), context);
        algorithm.setDouble(BFloatingLimitAlgorithm.highDiffLimit, ((BNumber)eventParam.get("highDiffLimit")).getDouble(), context);
        algorithm.setDouble(BFloatingLimitAlgorithm.deadband, ((BNumber)eventParam.get("deadband")).getDouble(), context);
        BLimitEnable limitEnable = algorithm.getLimitEnable();
        limitEnable.setBoolean(BLimitEnable.highLimitEnable, true, context);
        limitEnable.setBoolean(BLimitEnable.lowLimitEnable, true, context);
    }

    private BComponent getFloatingLimitSetpoint(BBacnetEventParameter eventParam) throws EventEnrollmentException {
        BValue setpointRef = eventParam.get("setpointReference");
        if (!(setpointRef instanceof BBacnetDeviceObjectPropertyReference)) {
            throw new EventEnrollmentException("setpoint reference for Floating Limit is type " + (setpointRef != null ? setpointRef.getType() : null) + " but should be instanceof BacnetDeviceObjectPropertyReference", new NErrorType(2, 37));
        }
        try {
            return BacnetDescriptorUtil.findLocalOrRemotePoint((BBacnetDeviceObjectPropertyReference)setpointRef);
        }
        catch (Exception e) {
            BBacnetEventEnrollmentDescriptor.logException(Level.WARNING, new StringBuilder(this.getObjectId().toString()).append(": error finding point for floating limit setpoint ref"), e);
            throw new EventEnrollmentException("error finding point for floating limit setpoint ref", new NErrorType(2, 37));
        }
    }

    private void configureOutOfRangeExt(BBacnetEventParameter eventParam, BPointExtension pointExt, BComponent target) throws EventEnrollmentException {
        if (!(target instanceof BNumericPoint)) {
            throw new EventEnrollmentException("referenced object is of type " + target.getType() + " and not instanceof NumericPoint, which is required for out-of-range extensions; event type: " + BBacnetEventType.tag(eventParam.getChoice()), new NErrorType(2, 37));
        }
        BAlarmSourceExt alarmExt = this.updateToAlarmExt(pointExt);
        this.configureAlarmExt(eventParam, alarmExt);
        this.configureOutOfRangeOffnormal(eventParam, alarmExt);
        this.configureOutOfRangeFault(eventParam, alarmExt);
        BBacnetEventEnrollmentDescriptor.addExtIfMissing((BPointExtension)alarmExt, target);
        this.updateDescriptor((BPointExtension)alarmExt);
    }

    private void configureOutOfRangeOffnormal(BBacnetEventParameter eventParam, BAlarmSourceExt ext) {
        BOffnormalAlgorithm offnormalAlgorithm = ext.getOffnormalAlgorithm();
        if (offnormalAlgorithm instanceof BOutOfRangeAlgorithm) {
            BBacnetEventEnrollmentDescriptor.configureOutOfRangeOffnormal(eventParam, (BOutOfRangeAlgorithm)offnormalAlgorithm);
        } else {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine((Object)((Object)this.getObjectId()) + ": replacing offnormal algorithm of type " + offnormalAlgorithm.getType() + " with OutOfRangeAlgorithm for event type " + BBacnetEventType.tag(eventParam.getChoice()));
            }
            BOutOfRangeAlgorithm outOfRangeAlgorithm = new BOutOfRangeAlgorithm();
            BBacnetEventEnrollmentDescriptor.configureOutOfRangeOffnormal(eventParam, outOfRangeAlgorithm);
            ext.set(BAlarmSourceExt.offnormalAlgorithm, (BValue)outOfRangeAlgorithm, BLocalBacnetDevice.getBacnetContext());
        }
    }

    private static void configureOutOfRangeOffnormal(BBacnetEventParameter eventParam, BOutOfRangeAlgorithm algorithm) {
        Context context = BLocalBacnetDevice.getBacnetContext();
        algorithm.setDouble(BOutOfRangeAlgorithm.lowLimit, ((BNumber)eventParam.get("lowLimit")).getDouble(), context);
        algorithm.setDouble(BOutOfRangeAlgorithm.highLimit, ((BNumber)eventParam.get("highLimit")).getDouble(), context);
        algorithm.setDouble(BOutOfRangeAlgorithm.deadband, ((BNumber)eventParam.get("deadband")).getDouble(), context);
        BLimitEnable limitEnable = algorithm.getLimitEnable();
        limitEnable.setBoolean(BLimitEnable.highLimitEnable, true, context);
        limitEnable.setBoolean(BLimitEnable.lowLimitEnable, true, context);
    }

    private void configureOutOfRangeFault(BBacnetEventParameter eventParam, BAlarmSourceExt ext) {
        BFaultAlgorithm faultAlgorithm = ext.getFaultAlgorithm();
        if (!(ext.getFaultAlgorithm() instanceof BOutOfRangeFaultAlgorithm)) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine((Object)((Object)this.getObjectId()) + ": replacing fault algorithm of type " + faultAlgorithm.getType() + " with OutOfRangeFaultAlgorithm for event type " + BBacnetEventType.tag(eventParam.getChoice()));
            }
            ext.set(BAlarmSourceExt.faultAlgorithm, (BValue)new BOutOfRangeFaultAlgorithm(), BLocalBacnetDevice.getBacnetContext());
        }
    }

    private void configureTrendAlarmExt(BBacnetEventParameter eventParam, BPointExtension pointExt, BComponent target) throws EventEnrollmentException {
        if (!(target instanceof BIBacnetTrendLogExt)) {
            throw new EventEnrollmentException("target is of type " + target.getType() + " and not instanceof BIBacnetTrendLogExt, which is required for trend log alarm source extensions; event type: " + BBacnetEventType.tag(eventParam.getChoice()), new NErrorType(2, 37));
        }
        BBacnetTrendLogAlarmSourceExt trendAlarmExt = this.updateToTrendAlarmExt(pointExt);
        BBacnetEventEnrollmentDescriptor.addExtIfMissing(trendAlarmExt, target);
        Context context = BLocalBacnetDevice.getBacnetContext();
        trendAlarmExt.set(BAlarmSourceExt.alarmEnable, (BValue)this.eventEnable, context);
        this.configureAlarmClass(trendAlarmExt, this.getNotificationClassId(), context);
        trendAlarmExt.set(BBacnetTrendLogAlarmSourceExt.toNormalText, (BValue)BFormat.make((String)this.toNormalText), context);
        trendAlarmExt.updateParameters(BBacnetEventEnrollmentDescriptor.getLongParameter(eventParam, "notificationThreshold"), BBacnetEventEnrollmentDescriptor.getLongParameter(eventParam, "previousNotificationCount"), context);
        this.configureAlarmInhibit(trendAlarmExt, context);
        this.updateDescriptor(trendAlarmExt);
    }

    private static long getLongParameter(BBacnetEventParameter eventParam, String slotName) {
        return ((BBacnetUnsigned)eventParam.get(slotName)).getLong();
    }

    private void configureStringChangeOfStateExt(BBacnetEventParameter eventParam, BPointExtension pointExt, BComponent target) throws EventEnrollmentException {
        if (!(target instanceof BStringPoint)) {
            throw new EventEnrollmentException("referenced object is of type " + target.getType() + " and not instanceof StringPoint, which is required for String change-of-state extensions; event type: " + BBacnetEventType.tag(eventParam.getChoice()), new NErrorType(2, 37));
        }
        BAlarmSourceExt alarmExt = this.updateToAlarmExt(pointExt);
        this.configureAlarmExt(eventParam, alarmExt);
        this.configureStringChangeOfStateOffnormal(eventParam, alarmExt);
        this.configureStringChangeOfStateFault(eventParam, alarmExt);
        BBacnetEventEnrollmentDescriptor.addExtIfMissing((BPointExtension)alarmExt, target);
        this.updateDescriptor((BPointExtension)alarmExt);
    }

    private void configureStringChangeOfStateOffnormal(BBacnetEventParameter eventParam, BAlarmSourceExt alarmExt) throws EventEnrollmentException {
        BOffnormalAlgorithm offnormalAlgorithm = alarmExt.getOffnormalAlgorithm();
        if (offnormalAlgorithm instanceof BStringChangeOfStateAlgorithm) {
            BBacnetEventEnrollmentDescriptor.configureStringChangeOfStateOffnormal(eventParam, (BStringChangeOfStateAlgorithm)offnormalAlgorithm);
        } else {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine((Object)((Object)this.getObjectId()) + ": replacing offnormal algorithm of type " + offnormalAlgorithm.getType() + " with StringChangeOfStateAlgorithm for event type " + BBacnetEventType.tag(eventParam.getChoice()));
            }
            BStringChangeOfStateAlgorithm stringChangeOfStateAlgorithm = new BStringChangeOfStateAlgorithm();
            BBacnetEventEnrollmentDescriptor.configureStringChangeOfStateOffnormal(eventParam, stringChangeOfStateAlgorithm);
            alarmExt.set(BAlarmSourceExt.offnormalAlgorithm, (BValue)stringChangeOfStateAlgorithm, BLocalBacnetDevice.getBacnetContext());
        }
    }

    private static void configureStringChangeOfStateOffnormal(BBacnetEventParameter eventParam, BStringChangeOfStateAlgorithm algorithm) throws EventEnrollmentException {
        BBacnetListOf listOfValues = (BBacnetListOf)eventParam.get("listOfAlarmValues");
        BString[] alarmValues = (BString[])listOfValues.getChildren(BString.class);
        if (alarmValues.length < 1) {
            throw new EventEnrollmentException("String change-of-state alarm extensions require at least 1 alarm value; event type: " + BBacnetEventType.tag(eventParam.getChoice()), new NErrorType(2, 37));
        }
        String alarmValue = alarmValues[0].getString();
        Context context = BLocalBacnetDevice.getBacnetContext();
        algorithm.setString(BStringChangeOfStateAlgorithm.expression, alarmValue, context);
        algorithm.setBoolean(BStringChangeOfStateAlgorithm.normalOnMatch, false, context);
    }

    private void configureStringChangeOfStateFault(BBacnetEventParameter eventParam, BAlarmSourceExt alarmExt) {
        BFaultAlgorithm faultAlgorithm = alarmExt.getFaultAlgorithm();
        if (!(alarmExt.getFaultAlgorithm() instanceof BStringChangeOfStateFaultAlgorithm)) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine((Object)((Object)this.getObjectId()) + ": replacing fault algorithm of type " + faultAlgorithm.getType() + " with StringChangeOfStateFaultAlgorithm for event type " + BBacnetEventType.tag(eventParam.getChoice()));
            }
            alarmExt.set(BAlarmSourceExt.faultAlgorithm, (BValue)new BStringChangeOfStateFaultAlgorithm(), BLocalBacnetDevice.getBacnetContext());
        }
    }

    private void configureChangeOfStatusFlagsExt(BBacnetEventParameter eventParam, BAlarmSourceExt alarmExt, BComponent target) {
        alarmExt = alarmExt == null ? new BAlarmSourceExt() : alarmExt;
        this.configureAlarmExt(eventParam, alarmExt);
        this.configureChangeOfStatusFlagsOffnormal(eventParam, alarmExt);
        this.configureGeneralFaultAlgorithm(eventParam, alarmExt);
        BBacnetEventEnrollmentDescriptor.addExtIfMissing((BPointExtension)alarmExt, target);
        this.updateDescriptor((BPointExtension)alarmExt);
    }

    private void configureChangeOfStatusFlagsOffnormal(BBacnetEventParameter eventParam, BAlarmSourceExt alarmExt) {
        BOffnormalAlgorithm offnormalAlgorithm = alarmExt.getOffnormalAlgorithm();
        if (offnormalAlgorithm instanceof BBacnetStatusAlgorithm) {
            BBacnetEventEnrollmentDescriptor.configureChangeOfStatusFlagsOffnormal(eventParam, (BBacnetStatusAlgorithm)offnormalAlgorithm);
        } else {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine((Object)((Object)this.getObjectId()) + ": replacing offnormal algorithm of type " + offnormalAlgorithm.getType() + " with BBacnetStatusAlgorithm for event type " + BBacnetEventType.tag(eventParam.getChoice()));
            }
            BBacnetStatusAlgorithm changeOfStatusFlagsAlgorithm = new BBacnetStatusAlgorithm();
            BBacnetEventEnrollmentDescriptor.configureChangeOfStatusFlagsOffnormal(eventParam, changeOfStatusFlagsAlgorithm);
            alarmExt.set(BAlarmSourceExt.offnormalAlgorithm, (BValue)changeOfStatusFlagsAlgorithm, BLocalBacnetDevice.getBacnetContext());
        }
    }

    private static void configureChangeOfStatusFlagsOffnormal(BBacnetEventParameter eventParam, BBacnetStatusAlgorithm algorithm) {
        algorithm.set(BBacnetStatusAlgorithm.alarmValues, eventParam.get("statusFlags"), BLocalBacnetDevice.getBacnetContext());
    }

    @Override
    public void spy(SpyWriter out) throws Exception {
        super.spy(out);
        out.startProps();
        out.trTitle((Object)"BacnetEventEnrollmentDescriptor", 2);
        out.prop((Object)"pointExt", (Object)this.pointExt);
        out.prop((Object)"oldId", (Object)this.oldId);
        out.prop((Object)"oldName", (Object)this.oldName);
        out.prop((Object)"configOk", this.configOk);
        out.prop((Object)"duplicate", this.duplicate);
        out.prop((Object)"typeOfEvent", (Object)this.getTypeOfEvent());
        out.prop((Object)"notificationClass", (Object)this.getNotificationClass());
        out.endProps();
    }

    private static boolean isArray(int propId) {
        for (int arrayPropId : ARRAY_PROPS) {
            if (propId != arrayPropId) continue;
            return true;
        }
        return false;
    }

    private BComponent resolveTarget(BBacnetDeviceObjectPropertyReference objPropRef) {
        if (!BacnetDescriptorUtil.isValidDeviceObjectPropertyReference(objPropRef)) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine((Object)((Object)this.getObjectId()) + ": objectPropertyReference (" + objPropRef + ") is not valid");
            }
            return null;
        }
        try {
            BComponent target = BacnetDescriptorUtil.findLocalOrRemotePoint(objPropRef);
            if (target == null && logger.isLoggable(Level.FINE)) {
                logger.fine((Object)((Object)this.getObjectId()) + ": did not resolve objectPropertyReference " + objPropRef);
            }
            return target;
        }
        catch (Exception e) {
            BBacnetEventEnrollmentDescriptor.logException(Level.SEVERE, new StringBuilder(this.getObjectId().toString()).append(": could not resolve target for objectPropertyReference ").append(objPropRef), e);
            return null;
        }
    }

    private void updateDescriptor(BPointExtension pointExt) {
        this.pointExt = pointExt;
        Context context = BLocalBacnetDevice.getBacnetContext();
        this.set(eventEnrollmentOrd, (BValue)pointExt.getHandleOrd(), context);
        if (this.getNotificationClass(pointExt) == null) {
            this.set(reliability, (BValue)BBacnetReliability.configurationError, context);
        } else {
            this.set(reliability, (BValue)BBacnetReliability.noFaultDetected, context);
        }
    }

    private void resetDescriptor() {
        BComplex parent;
        BPointExtension pointExt = this.pointExt;
        if (pointExt != null && (parent = pointExt.getParent()) instanceof BComponent) {
            ((BComponent)parent).remove((BComplex)pointExt);
        }
        this.pointExt = null;
        Context context = BLocalBacnetDevice.getBacnetContext();
        this.set(eventEnrollmentOrd, (BValue)BOrd.NULL, context);
        this.set(reliability, (BValue)BBacnetReliability.configurationError, context);
    }

    private static void logException(Level level, StringBuilder message, Exception e) {
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, message.append("; exception: ").append(e.getLocalizedMessage()).toString(), e);
        } else if (logger.isLoggable(level)) {
            logger.log(level, message.append("; exception: ").append(e.getLocalizedMessage()).toString());
        }
    }

    private static class EventEnrollmentException
    extends Exception {
        final ErrorType errorType;

        public EventEnrollmentException(String message, ErrorType errorType) {
            super(message);
            this.errorType = errorType;
        }
    }
}

