/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.bacnet.export;

import com.tridium.bacnet.asn.AsnUtil;
import com.tridium.bacnet.asn.NErrorType;
import com.tridium.bacnet.asn.NReadPropertyResult;
import java.util.Vector;
import javax.baja.alarm.BIAlarmSource;
import javax.baja.alarm.ext.BAlarmSourceExt;
import javax.baja.alarm.ext.offnormal.BBooleanChangeOfStateAlgorithm;
import javax.baja.bacnet.BacnetException;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.enums.BBacnetEventType;
import javax.baja.bacnet.enums.BBacnetObjectType;
import javax.baja.bacnet.enums.BBacnetPropertyIdentifier;
import javax.baja.bacnet.export.BBacnetBinaryWritableDescriptor;
import javax.baja.bacnet.export.BLocalBacnetDevice;
import javax.baja.bacnet.io.AsnException;
import javax.baja.bacnet.io.ErrorType;
import javax.baja.bacnet.io.OutOfRangeException;
import javax.baja.bacnet.io.PropertyValue;
import javax.baja.bacnet.util.BacnetBitStringUtil;
import javax.baja.control.BBooleanPoint;
import javax.baja.security.PermissionException;
import javax.baja.sys.BEnum;
import javax.baja.sys.BFacets;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BBacnetBinaryValuePrioritizedDescriptor
extends BBacnetBinaryWritableDescriptor {
    public static final Property objectId = BBacnetBinaryValuePrioritizedDescriptor.newProperty((int)64, (BValue)BBacnetObjectIdentifier.make(5));
    public static final Type TYPE = Sys.loadType(BBacnetBinaryValuePrioritizedDescriptor.class);

    @Override
    public Type getType() {
        return TYPE;
    }

    public final BFacets getSlotFacets(Slot s) {
        if (s == objectId) {
            return BBacnetObjectType.getObjectIdFacets(5);
        }
        return super.getSlotFacets(s);
    }

    @Override
    public BEnum getEventType() {
        return BBacnetEventType.changeOfState;
    }

    @Override
    protected boolean commandabilityRequired() {
        return false;
    }

    @Override
    public boolean isValidAlarmExt(BIAlarmSource ext) {
        if (ext instanceof BAlarmSourceExt) {
            return ((BAlarmSourceExt)ext).getOffnormalAlgorithm() instanceof BBooleanChangeOfStateAlgorithm;
        }
        return false;
    }

    @Override
    protected PropertyValue readProperty(int pId, int ndx) {
        BBooleanPoint pt = (BBooleanPoint)this.getPoint();
        if (pt == null) {
            return new NReadPropertyResult(pId, ndx, new NErrorType(1, 1000));
        }
        if (ndx >= 0 && !this.isArray(pId)) {
            return new NReadPropertyResult(pId, ndx, new NErrorType(2, 50));
        }
        switch (pId) {
            case 85: {
                return new NReadPropertyResult(pId, ndx, AsnUtil.toAsnEnumerated(pt.getOut().getValue()));
            }
        }
        return super.readProperty(pId, ndx);
    }

    @Override
    protected void addOptionalProps(Vector v) {
        super.addOptionalProps(v);
        BAlarmSourceExt almExt = this.getAlarmExt();
        if (almExt != null) {
            v.add(BBacnetPropertyIdentifier.alarmValue);
        }
    }

    @Override
    protected PropertyValue readOptionalProperty(int pId, int ndx) {
        BAlarmSourceExt almExt = this.getAlarmExt();
        if (almExt != null) {
            BBooleanChangeOfStateAlgorithm alg = (BBooleanChangeOfStateAlgorithm)almExt.getOffnormalAlgorithm();
            if (pId == 6) {
                return new NReadPropertyResult(pId, ndx, AsnUtil.toAsnEnumerated(alg.getAlarmValue()));
            }
        }
        return super.readOptionalProperty(pId, ndx);
    }

    @Override
    protected ErrorType writeOptionalProperty(int pId, int ndx, byte[] val, int pri) throws BacnetException {
        BAlarmSourceExt almExt = this.getAlarmExt();
        if (almExt != null) {
            try {
                BBooleanChangeOfStateAlgorithm alg = (BBooleanChangeOfStateAlgorithm)almExt.getOffnormalAlgorithm();
                switch (pId) {
                    case 6: {
                        alg.setBoolean(BBooleanChangeOfStateAlgorithm.alarmValue, AsnUtil.fromOnlyBinaryPv(val), BLocalBacnetDevice.getBacnetContext());
                        return null;
                    }
                    case 35: {
                        almExt.set(BAlarmSourceExt.alarmEnable, (BValue)BacnetBitStringUtil.getBAlarmTransitionBits(AsnUtil.fromAsnBitString(val)), BLocalBacnetDevice.getBacnetContext());
                        return null;
                    }
                }
            }
            catch (OutOfRangeException e) {
                log.info("OutOfRangeException writing property " + pId + " in object " + (Object)((Object)this.getObjectId()) + ":" + (Object)((Object)e));
                return new NErrorType(2, 37);
            }
            catch (AsnException e) {
                log.info("AsnException writing property " + pId + " in object " + (Object)((Object)this.getObjectId()) + ":" + (Object)((Object)e));
                return new NErrorType(2, 9);
            }
            catch (PermissionException e) {
                log.info("PermissionException writing property " + pId + " in object " + (Object)((Object)this.getObjectId()) + ":" + (Object)((Object)e));
                return new NErrorType(2, 40);
            }
        }
        return super.writeOptionalProperty(pId, ndx, val, pri);
    }
}

