/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.bacnet.export;

import com.tridium.bacnet.asn.AsnUtil;
import com.tridium.bacnet.asn.NErrorType;
import com.tridium.bacnet.asn.NReadPropertyResult;
import java.util.Vector;
import java.util.logging.Level;
import javax.baja.bacnet.BacnetException;
import javax.baja.bacnet.datatypes.BBacnetCovSubscription;
import javax.baja.bacnet.enums.BBacnetPropertyIdentifier;
import javax.baja.bacnet.enums.BBacnetReliability;
import javax.baja.bacnet.export.BBacnetPointDescriptor;
import javax.baja.bacnet.export.BLocalBacnetDevice;
import javax.baja.bacnet.io.AsnException;
import javax.baja.bacnet.io.ErrorType;
import javax.baja.bacnet.io.PropertyValue;
import javax.baja.control.BBooleanPoint;
import javax.baja.control.BControlPoint;
import javax.baja.control.ext.BAbstractProxyExt;
import javax.baja.control.ext.BDiscreteTotalizerExt;
import javax.baja.data.BIDataValue;
import javax.baja.driver.point.BDefaultProxyConversion;
import javax.baja.driver.point.BProxyConversion;
import javax.baja.driver.point.BProxyExt;
import javax.baja.driver.point.conv.BReversePolarityConversion;
import javax.baja.security.PermissionException;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BEnum;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIBoolean;
import javax.baja.sys.BIcon;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BFormat;

public abstract class BBacnetBinaryPointDescriptor
extends BBacnetPointDescriptor {
    public static final Type TYPE = Sys.loadType(BBacnetBinaryPointDescriptor.class);
    private static final BIcon icon = BIcon.make((BIcon)BIcon.std((String)"control/booleanPoint.png"), (BIcon)BIcon.std((String)"badges/export.png"));

    @Override
    public Type getType() {
        return TYPE;
    }

    @Override
    protected boolean isPointTypeLegal(BControlPoint pt) {
        return pt instanceof BBooleanPoint;
    }

    @Override
    protected PropertyValue readOptionalProperty(int pId, int ndx) {
        BDiscreteTotalizerExt totExt = this.getTotalizerExt();
        if (totExt != null) {
            switch (pId) {
                case 16: {
                    return new NReadPropertyResult(pId, ndx, AsnUtil.toBacnetDateTime(totExt.getChangeOfStateTime()));
                }
                case 15: {
                    return new NReadPropertyResult(pId, ndx, AsnUtil.toAsnUnsigned(totExt.getChangeOfStateCount()));
                }
                case 115: {
                    return new NReadPropertyResult(pId, ndx, AsnUtil.toBacnetDateTime(totExt.getTimeOfStateCountReset()));
                }
                case 33: {
                    return new NReadPropertyResult(pId, ndx, AsnUtil.toAsnUnsigned(totExt.getElapsedActiveTime().getSeconds()));
                }
                case 114: {
                    return new NReadPropertyResult(pId, ndx, AsnUtil.toBacnetDateTime(totExt.getTimeOfActiveTimeReset()));
                }
            }
        }
        BBooleanPoint pt = (BBooleanPoint)this.getPoint();
        switch (pId) {
            case 4: {
                BString tt = (BString)pt.getFacets().getFacet("trueText");
                if (tt == null) break;
                String trueText = BFormat.format((String)tt.toString(), null, null);
                return new NReadPropertyResult(pId, ndx, AsnUtil.toAsnCharacterString(trueText));
            }
            case 46: {
                BString ft = (BString)pt.getFacets().getFacet("falseText");
                if (ft == null) break;
                String falseText = BFormat.format((String)ft.toString(), null, null);
                return new NReadPropertyResult(pId, ndx, AsnUtil.toAsnCharacterString(falseText));
            }
        }
        return super.readOptionalProperty(pId, ndx);
    }

    @Override
    protected ErrorType writeOptionalProperty(int pId, int ndx, byte[] val, int pri) throws BacnetException {
        BDiscreteTotalizerExt totExt = this.getTotalizerExt();
        try {
            if (totExt != null) {
                switch (pId) {
                    case 16: {
                        return new NErrorType(2, 40);
                    }
                    case 15: {
                        if (AsnUtil.fromAsnUnsignedInteger(val) != 0L) {
                            return new NErrorType(2, 37);
                        }
                        totExt.invoke(BDiscreteTotalizerExt.resetChangeOfStateCount, null, BLocalBacnetDevice.getBacnetContext());
                        return null;
                    }
                    case 115: {
                        return new NErrorType(2, 40);
                    }
                    case 33: {
                        if (AsnUtil.fromAsnUnsignedInteger(val) != 0L) {
                            return new NErrorType(2, 37);
                        }
                        totExt.invoke(BDiscreteTotalizerExt.resetElapsedActiveTime, null, BLocalBacnetDevice.getBacnetContext());
                        return null;
                    }
                    case 114: {
                        return new NErrorType(2, 40);
                    }
                }
            }
            BBooleanPoint pt = (BBooleanPoint)this.getPoint();
            switch (pId) {
                case 4: {
                    BString tt = (BString)pt.getFacets().getFacet("trueText");
                    if (tt == null) break;
                    pt.set(BControlPoint.facets, (BValue)BFacets.make((BFacets)pt.getFacets(), (String)"trueText", (BIDataValue)BString.make((String)AsnUtil.fromAsnCharacterString(val))), BLocalBacnetDevice.getBacnetContext());
                    return null;
                }
                case 46: {
                    BString ft = (BString)pt.getFacets().getFacet("falseText");
                    if (ft == null) break;
                    pt.set(BControlPoint.facets, (BValue)BFacets.make((BFacets)pt.getFacets(), (String)"falseText", (BIDataValue)BString.make((String)AsnUtil.fromAsnCharacterString(val))), BLocalBacnetDevice.getBacnetContext());
                    return null;
                }
            }
            return super.writeOptionalProperty(pId, ndx, val, pri);
        }
        catch (AsnException e) {
            log.info("AsnException writing property " + pId + " in object " + (Object)((Object)this.getObjectId()));
            return new NErrorType(2, 9);
        }
        catch (PermissionException e) {
            log.info("PermissionException writing property " + pId + " in object " + (Object)((Object)this.getObjectId()) + ":" + (Object)((Object)e));
            return new NErrorType(2, 40);
        }
    }

    @Override
    protected void addRequiredProps(Vector v) {
        super.addRequiredProps(v);
        v.add(BBacnetPropertyIdentifier.presentValue);
        v.add(BBacnetPropertyIdentifier.statusFlags);
        v.add(BBacnetPropertyIdentifier.eventState);
        v.add(BBacnetPropertyIdentifier.outOfService);
    }

    @Override
    protected void addOptionalProps(Vector v) {
        BDiscreteTotalizerExt tot;
        BString ft;
        super.addOptionalProps(v);
        BControlPoint pt = this.getPoint();
        BString tt = (BString)pt.getFacets().getFacet("trueText");
        if (tt != null) {
            v.add(BBacnetPropertyIdentifier.activeText);
        }
        if ((ft = (BString)pt.getFacets().getFacet("falseText")) != null) {
            v.add(BBacnetPropertyIdentifier.inactiveText);
        }
        if ((tot = this.getTotalizerExt()) != null) {
            v.add(BBacnetPropertyIdentifier.changeOfStateTime);
            v.add(BBacnetPropertyIdentifier.changeOfStateCount);
            v.add(BBacnetPropertyIdentifier.timeOfStateCountReset);
            v.add(BBacnetPropertyIdentifier.elapsedActiveTime);
            v.add(BBacnetPropertyIdentifier.timeOfActiveTimeReset);
        }
    }

    @Override
    protected void validate() {
        BStatusBoolean sb = ((BBooleanPoint)this.getPoint()).getOut();
        BStatus s = sb.getStatus();
        if (s.isNull()) {
            this.setReliability((BEnum)BBacnetReliability.unreliableOther);
            this.setFaultCause("Invalid value for BACnet Object:" + sb);
            this.setStatus(BStatus.makeFault((BStatus)this.getStatus(), (boolean)true));
        } else if (s.isFault()) {
            this.setReliability((BEnum)BBacnetReliability.unreliableOther);
        } else if (s.isDown()) {
            this.setReliability((BEnum)BBacnetReliability.communicationFailure);
        } else {
            this.setReliability((BEnum)BBacnetReliability.noFaultDetected);
            if (this.configOk()) {
                this.setStatus(BStatus.makeFault((BStatus)this.getStatus(), (boolean)false));
                this.setFaultCause("");
            } else {
                this.setStatus(BStatus.makeFault((BStatus)this.getStatus(), (boolean)true));
                this.setFaultCause(lex.getText("export.configurationFault"));
            }
        }
    }

    @Override
    BStatusValue getCurrentStatusValue() {
        BStatusBoolean sv = new BStatusBoolean(((BBooleanPoint)this.getPoint()).getOut().getValue());
        sv.setStatus(this.getStatusFlags());
        return sv;
    }

    @Override
    boolean checkCov(BStatusValue currentValue, BStatusValue covValue) {
        if (currentValue.getStatus().getBits() != covValue.getStatus().getBits()) {
            return true;
        }
        return ((BStatusBoolean)currentValue).getBoolean() != ((BStatusBoolean)covValue).getBoolean();
    }

    @Deprecated
    boolean checkCov(BControlPoint pt, BBacnetCovSubscription covSub) {
        boolean covValue;
        if (pt.getStatus().getBits() != covSub.getLastValue().getStatus().getBits()) {
            return true;
        }
        boolean currentValue = ((BBooleanPoint)pt).getBoolean();
        return currentValue != (covValue = ((BIBoolean)covSub.getLastValue()).getBoolean());
    }

    private BDiscreteTotalizerExt getTotalizerExt() {
        BControlPoint pt = this.getPoint();
        if (pt == null) {
            return null;
        }
        SlotCursor c = pt.getProperties();
        if (c.next(BDiscreteTotalizerExt.class)) {
            return (BDiscreteTotalizerExt)c.get();
        }
        return null;
    }

    PropertyValue readPolarityProperty(BBooleanPoint pt) {
        BAbstractProxyExt proxyExt = pt.getProxyExt();
        if (proxyExt instanceof BProxyExt && ((BProxyExt)proxyExt).getConversion() instanceof BReversePolarityConversion) {
            return new NReadPropertyResult(84, AsnUtil.toAsnEnumerated(1));
        }
        return new NReadPropertyResult(84, AsnUtil.toAsnEnumerated(0));
    }

    protected ErrorType writePolarityProperty(BBooleanPoint pt, byte[] val) throws BacnetException {
        BAbstractProxyExt proxyExt = pt.getProxyExt();
        if (proxyExt instanceof BProxyExt) {
            if (AsnUtil.fromAsnEnumerated(val) == 1) {
                ((BProxyExt)proxyExt).setConversion((BProxyConversion)BReversePolarityConversion.DEFAULT);
            } else {
                ((BProxyExt)proxyExt).setConversion((BProxyConversion)BDefaultProxyConversion.DEFAULT);
            }
            return null;
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("Cannot write the Polarity property when the associated point's proxy ext is not instanceof BProxyExt; object ID: " + (Object)((Object)this.getObjectId()) + ", object name: " + this.getObjectName());
        }
        return new NErrorType(2, 40);
    }

    public BIcon getIcon() {
        return icon;
    }
}

