/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.bacnet.export;

import com.tridium.bacnet.asn.AsnUtil;
import com.tridium.bacnet.asn.NErrorType;
import javax.baja.alarm.ext.BAlarmSourceExt;
import javax.baja.bacnet.BacnetException;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.enums.BBacnetObjectType;
import javax.baja.bacnet.export.BBacnetAnalogPointDescriptor;
import javax.baja.bacnet.export.BLocalBacnetDevice;
import javax.baja.bacnet.export.BOutOfServiceExt;
import javax.baja.bacnet.io.AsnException;
import javax.baja.bacnet.io.ErrorType;
import javax.baja.bacnet.util.BacnetBitStringUtil;
import javax.baja.control.BControlPoint;
import javax.baja.control.BNumericPoint;
import javax.baja.security.PermissionException;
import javax.baja.status.BStatusNumeric;
import javax.baja.sys.BDouble;
import javax.baja.sys.BFacets;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BBacnetAnalogValueDescriptor
extends BBacnetAnalogPointDescriptor {
    public static final Property objectId = BBacnetAnalogValueDescriptor.newProperty((int)64, (BValue)BBacnetObjectIdentifier.make(2));
    public static final Type TYPE = Sys.loadType(BBacnetAnalogValueDescriptor.class);

    @Override
    public Type getType() {
        return TYPE;
    }

    @Deprecated
    public BStatusNumeric getBacnetValue() {
        throw new BajaRuntimeException("Method getBacnetValue() is deprecated!");
    }

    @Deprecated
    public void setBacnetValue(BStatusNumeric v) {
        throw new BajaRuntimeException("Method setBacnetValue() is deprecated!");
    }

    public final BFacets getSlotFacets(Slot s) {
        if (s == objectId) {
            return BBacnetObjectType.getObjectIdFacets(2);
        }
        return super.getSlotFacets(s);
    }

    @Override
    protected final boolean isPointTypeLegal(BControlPoint pt) {
        return pt instanceof BNumericPoint;
    }

    @Override
    protected ErrorType writeProperty(int pId, int ndx, byte[] val, int pri) throws BacnetException {
        BNumericPoint pt = (BNumericPoint)this.getPoint();
        if (pt == null) {
            return new NErrorType(1, 1000);
        }
        if (ndx >= 0 && !this.isArray(pId)) {
            return new NErrorType(2, 50);
        }
        try {
            switch (pId) {
                case 85: {
                    BOutOfServiceExt outOfServiceExt = this.getOosExt();
                    if (outOfServiceExt.getOutOfService()) {
                        outOfServiceExt.set(BOutOfServiceExt.presentValue, (BValue)BDouble.make((double)this.convertFromAsn(val)), BLocalBacnetDevice.getBacnetContext());
                        return null;
                    }
                    return new NErrorType(2, 40);
                }
            }
        }
        catch (AsnException e) {
            log.info("AsnException writing property " + pId + " in object " + (Object)((Object)this.getObjectId()) + ":" + (Object)((Object)e));
            return new NErrorType(2, 9);
        }
        catch (PermissionException e) {
            log.info("PermissionException writing property " + pId + " in object " + (Object)((Object)this.getObjectId()) + ":" + (Object)((Object)e));
            return new NErrorType(2, 40);
        }
        return super.writeProperty(pId, ndx, val, pri);
    }

    @Override
    protected ErrorType writeOptionalProperty(int pId, int ndx, byte[] val, int pri) throws BacnetException {
        switch (pId) {
            case 35: {
                BAlarmSourceExt almExt = this.getAlarmExt();
                if (almExt == null) break;
                almExt.set(BAlarmSourceExt.alarmEnable, (BValue)BacnetBitStringUtil.getBAlarmTransitionBits(AsnUtil.fromAsnBitString(val)), BLocalBacnetDevice.getBacnetContext());
                return null;
            }
        }
        return super.writeOptionalProperty(pId, ndx, val, pri);
    }
}

