/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.bacnet.export;

import com.tridium.bacnet.asn.AsnUtil;
import com.tridium.bacnet.asn.NErrorType;
import com.tridium.bacnet.asn.NReadPropertyResult;
import java.util.Vector;
import javax.baja.bacnet.BacnetException;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.enums.BBacnetObjectType;
import javax.baja.bacnet.enums.BBacnetPropertyIdentifier;
import javax.baja.bacnet.export.BBacnetAnalogWritableDescriptor;
import javax.baja.bacnet.io.ErrorType;
import javax.baja.bacnet.io.PropertyValue;
import javax.baja.control.BNumericPoint;
import javax.baja.sys.BFacets;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BBacnetAnalogOutputDescriptor
extends BBacnetAnalogWritableDescriptor {
    public static final Property objectId = BBacnetAnalogOutputDescriptor.newProperty((int)64, (BValue)BBacnetObjectIdentifier.make(1));
    public static final Property deviceType = BBacnetAnalogOutputDescriptor.newProperty((int)0, (String)"", null);
    public static final Type TYPE = Sys.loadType(BBacnetAnalogOutputDescriptor.class);

    public String getDeviceType() {
        return this.getString(deviceType);
    }

    public void setDeviceType(String v) {
        this.setString(deviceType, v, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    public final BFacets getSlotFacets(Slot s) {
        if (s == objectId) {
            return BBacnetObjectType.getObjectIdFacets(1);
        }
        return super.getSlotFacets(s);
    }

    @Override
    protected void addOptionalProps(Vector v) {
        super.addOptionalProps(v);
        v.add(BBacnetPropertyIdentifier.deviceType);
    }

    @Override
    protected PropertyValue readOptionalProperty(int pId, int ndx) {
        BNumericPoint pt = (BNumericPoint)this.getPoint();
        if (pt == null) {
            return new NReadPropertyResult(pId, ndx, new NErrorType(1, 1000));
        }
        switch (pId) {
            case 31: {
                return new NReadPropertyResult(pId, ndx, AsnUtil.toAsnCharacterString(this.getDeviceType()));
            }
        }
        return super.readOptionalProperty(pId, ndx);
    }

    @Override
    protected ErrorType writeOptionalProperty(int pId, int ndx, byte[] val, int pri) throws BacnetException {
        switch (pId) {
            case 31: {
                return new NErrorType(2, 40);
            }
        }
        return super.writeOptionalProperty(pId, ndx, val, pri);
    }
}

